* SAS Read-In Program
*
* Name: drug_char_2016_readin.sas
*
* Purpose: Read-In the delimited flat file DRUG_CHAR_2016.
*
* Delimiter: Fixed Column
*
* Date: 13SEP17   Time: 13:41
*
* Help: cmsdata@gdit.com, 1-866-766-1915
*
*;

filename in  'drug_char_2016.dat'  lrecl=32768;
libname  ccw '.';

data ccw.DRUG_CHAR_2016;
  length NDC                              $11
         BN                               $30
         GNN                              $30
         STR                              $10
         GCDF                             $2
         GCDF_DESC                        $40;

  format NDC                              $11.
         BN                               $30.
         GNN                              $30.
         STR                              $10.
         GCDF                             $2.
         GCDF_DESC                        $40.;

  label  NDC                              = "11-digit NDC"
         BN                               = "Brand Name"
         GNN                              = "USAN Generic Name - Short Version"
         STR                              = "Drug Strength Description"
         GCDF                             = "Dosage Form Code (2 character)"
         GCDF_DESC                        = "Dosage Form Code Description";

  infile in missover truncover;

  input @001   NDC                              $11.
        @012   BN                               $30.
        @042   GNN                              $30.
        @072   STR                              $10.
        @082   GCDF                             $2.
        @084   GCDF_DESC                        $40.;
run;

title 'DRUG_CHAR_2016';
proc contents data=ccw.DRUG_CHAR_2016 varnum;
proc print data=ccw.DRUG_CHAR_2016(obs=5);
  title2 'Sample Listing - First 5 Rows';
run;
proc means data=ccw.DRUG_CHAR_2016;
  title2 'Simple Means';
run;

proc freq data=ccw.DRUG_CHAR_2016;
  title2 'Freqs';
  table
    GCDF
        /missing;
run;

* End of Program *;
