* SAS Read-In Program
*
* Name: ibc_2020_readin.sas
*
* Purpose: Read-In the delimited flat file IBC_2020.
*
* Delimiter: Fixed Column
*
* Date: 14SEP21   Time: 12:42
*
* Help: cmsdata@gdit.com, 1-866-766-1915
*
*;

filename in  'ibc_2020.dat'  lrecl=32768;
libname  ccw '.';

data ccw.IBC_2020;
  length FORMULARY_ID $8
         FRMLRY_RX_ID $8
         BN           $30
         GNN          $30
         STR          $10
         GCDF         $2
         GCDF_DESC    $40
         MESH_CUI     $11
         DISEASE      $100;

  label FORMULARY_ID = "Unique ID Assigned to Each Newly Created Formulary"
        FRMLRY_RX_ID = "CCW Identifier for a Drug Product Found in a Part D Prescription Drug Plan Formulary"
        BN           = "FDB Brand Name"
        GNN          = "FDB USAN Generic Name - Short Version"
        STR          = "FDB Drug Strength Description"
        GCDF         = "FDB Dosage Form Code"
        GCDF_DESC    = "FDB Dosage Form Code Description"
        MESH_CUI     = "Coverage Indicator"
        DISEASE      = "Condition";

  infile in missover truncover;

  input @001 FORMULARY_ID $8.
        @009 FRMLRY_RX_ID $8.
        @017 BN           $30.
        @047 GNN          $30.
        @077 STR          $10.
        @087 GCDF         $2.
        @089 GCDF_DESC    $40.
        @129 MESH_CUI     $11.
        @140 DISEASE      $100.;
run;

title 'IBC 2020';
proc contents data=ccw.IBC_2020 varnum;
proc print data=ccw.IBC_2020(obs=5);
  title2 'Sample Listing - First 5 Rows';
run;
proc means data=ccw.IBC_2020;
  title2 'Simple Means';
run;

proc freq data=ccw.IBC_2020;
  title2 'Freqs';
  table GCDF/missing;
run;

* End of Program *;
