* SAS Read-In Program
*
* Name: plan_char_2007_readin.sas
*
* Purpose: Read-In the delimited flat file PLAN_CHAR_2007.
*
* Delimiter: Fixed Column
*
* Date: 27DEC14   Time: 23:29
*
* Programmer: Adam Hendricks, Adam.Hendricks@gdit.com, 515-645-3015
*
*;

%let dirpath = .; * <--  Directory Path for Input Flat File in FILENAME Statement *;

filename in  "%trim(&dirpath)/plan_char_2007.dat" lrecl=1018;

libname  out '.'; * <--  Directory Path for Output Library in LIBNAME Statement   *;

* Start *;
data out.PLAN_CHAR_2007;
  length CONTRACT_ID                      $5
         PLAN_ID                          $3
         FORMULARY_ID                     $8
         CONTRACT_NAME                    $150
         PLAN_NAME                        $75
         ORGANIZATION_MARKETING_NAME      $150
         EFFECTIVE_DATE                   $10
         ORGANIZATION_TYPE                $2
         PLAN_TYPE                        $2
         DEMO_TYPE                        $1
         REINSURANCE_DEMO_TYPE            $1
         SNP_TYPE                         $1
         DRUG_BENEFIT_TYPE                $1
         EGWP_INDICATOR                   $1
         EGHP_CALENDAR_YEAR_FLAG          $1
         COV_CRITERIA                     $1
         NATIONAL_PDP                     $1
         GAP_COVERAGE_TYPE                $1
         DED_APPLY                        $1
         DED_AMT                          8
         DED_APPLY_ALL                    $1
         DED_GENERIC_COPAY                8
         FREE_FIRST_FILL                  $1
         LESSER_OF_PRICING                $1
         PRE_ICL_APPLY                    $1
         ICL_APPLY                        $1
         ICL_AMT                          8
         POST_OOPT_APPLY                  $1
         OOPT_AMT                         8
         EXCLUDED_DRUGS                   $1
         REDUCED_COST_SHARE               $1
         REDUCED_DED                      $1
         REDUCED_PREICL_CS                $1
         REDUCED_GAP_CS                   $1
         REDUCED_OOPT_CS                  $1
         SPECIALTY_TIER                   $3
         PRE_ICL_DRUG_TYPE_TIER_01-PRE_ICL_DRUG_TYPE_TIER_09       $6
         PRE_ICL_INP_1M_COPAY_TIER_01-PRE_ICL_INP_1M_COPAY_TIER_09 8
         PRE_ICL_INP_1M_COINS_TIER_01-PRE_ICL_INP_1M_COINS_TIER_09 8
         GAP_DRUG_TYPE_TIER_01-GAP_DRUG_TYPE_TIER_09               $6
         GAP_INP_1M_COPAY_TIER_01-GAP_INP_1M_COPAY_TIER_09         8
         GAP_INP_1M_COINS_TIER_01-GAP_INP_1M_COINS_TIER_09         8;

  format CONTRACT_ID                      $5.
         PLAN_ID                          $3.
         FORMULARY_ID                     $8.
         CONTRACT_NAME                    $150.
         PLAN_NAME                        $75.
         ORGANIZATION_MARKETING_NAME      $150.
         EFFECTIVE_DATE                   $10.
         ORGANIZATION_TYPE                $2.
         PLAN_TYPE                        $2.
         DEMO_TYPE                        $1.
         REINSURANCE_DEMO_TYPE            $1.
         SNP_TYPE                         $1.
         DRUG_BENEFIT_TYPE                $1.
         EGWP_INDICATOR                   $1.
         EGHP_CALENDAR_YEAR_FLAG          $1.
         COV_CRITERIA                     $1.
         NATIONAL_PDP                     $1.
         GAP_COVERAGE_TYPE                $1.
         DED_APPLY                        $1.
         DED_AMT                          12.2
         DED_APPLY_ALL                    $1.
         DED_GENERIC_COPAY                12.2
         FREE_FIRST_FILL                  $1.
         LESSER_OF_PRICING                $1.
         PRE_ICL_APPLY                    $1.
         ICL_APPLY                        $1.
         ICL_AMT                          12.2
         POST_OOPT_APPLY                  $1.
         OOPT_AMT                         12.2
         EXCLUDED_DRUGS                   $1.
         REDUCED_COST_SHARE               $1.
         REDUCED_DED                      $1.
         REDUCED_PREICL_CS                $1.
         REDUCED_GAP_CS                   $1.
         REDUCED_OOPT_CS                  $1.
         SPECIALTY_TIER                   $3.
         PRE_ICL_DRUG_TYPE_TIER_01-PRE_ICL_DRUG_TYPE_TIER_09       $6.
         PRE_ICL_INP_1M_COPAY_TIER_01-PRE_ICL_INP_1M_COPAY_TIER_09 12.2
         PRE_ICL_INP_1M_COINS_TIER_01-PRE_ICL_INP_1M_COINS_TIER_09 12.2
         GAP_DRUG_TYPE_TIER_01-GAP_DRUG_TYPE_TIER_09               $6.
         GAP_INP_1M_COPAY_TIER_01-GAP_INP_1M_COPAY_TIER_09         12.2 
         GAP_INP_1M_COINS_TIER_01-GAP_INP_1M_COINS_TIER_09         12.2;

  label  CONTRACT_ID                      = "Contract ID"
         PLAN_ID                          = "Plan ID"
         FORMULARY_ID                     = "Formulary Identifier"
         CONTRACT_NAME                    = "Contract Name"
         PLAN_NAME                        = "Plan Name"
         ORGANIZATION_MARKETING_NAME      = "Organization Marketing Name"
         EFFECTIVE_DATE                   = "Effective Date"
         ORGANIZATION_TYPE                = "Organization Type"
         PLAN_TYPE                        = "Plan Type"
         DEMO_TYPE                        = "Demo Type"
         REINSURANCE_DEMO_TYPE            = "Part D Reinsurance Demo Type"
         SNP_TYPE                         = "SNP Type"
         DRUG_BENEFIT_TYPE                = "Drug Benefit Type"
         EGWP_INDICATOR                   = "EGWP Indicator"
         EGHP_CALENDAR_YEAR_FLAG          = "EGHP Calendar Year Indicator"
         COV_CRITERIA                     = "Coverage Criteria (A/B or B only)"
         NATIONAL_PDP                     = "Indicates whether plan belongs to a National PDP sponsor"
         GAP_COVERAGE_TYPE                = "Type of gap coverage offered"
         DED_APPLY                        = "How Deductible is applied"
         DED_AMT                          = "Deductible Amount"
         DED_APPLY_ALL                    = "Type of drugs to which deductible applies"
         DED_GENERIC_COPAY                = "Copay for generic drugs in deductible phase"
         FREE_FIRST_FILL                  = "Indicates whether first prescription fill is free of charge"
         LESSER_OF_PRICING                = "Indicates whether plan charges the lesser of the cost share amount or actual drug price"
         PRE_ICL_APPLY                    = "How Pre-ICL cost shares are applied"
         ICL_APPLY                        = "How ICL is applied"
         ICL_AMT                          = "ICL Amount"
         POST_OOPT_APPLY                  = "How Post OOP threshold cost shares are applied"
         OOPT_AMT                         = "OOP Threshold Amount"
         EXCLUDED_DRUGS                   = "Indicates whether the plan covers Part D excluded drugs"
         REDUCED_COST_SHARE               = "Indicates whether the plan has reduced cost sharing below Medicare standard"
         REDUCED_DED                      = "Flag for reduced deductible amount"
         REDUCED_PREICL_CS                = "Flag for reduced pre-ICL cost sharing amounts"
         REDUCED_GAP_CS                   = "Flag for reduced coverage gap cost sharing amounts"
         REDUCED_OOPT_CS                  = "Flag for reduced post out-of-pocket threshold cost sharing amounts"
         SPECIALTY_TIER                   = "Specialty Tier Number"
         PRE_ICL_DRUG_TYPE_TIER_01        = "Pre-ICL Drug Type for Tier 1"
         PRE_ICL_DRUG_TYPE_TIER_02        = "Pre-ICL Drug Type for Tier 2"
         PRE_ICL_DRUG_TYPE_TIER_03        = "Pre-ICL Drug Type for Tier 3"
         PRE_ICL_DRUG_TYPE_TIER_04        = "Pre-ICL Drug Type for Tier 4"
         PRE_ICL_DRUG_TYPE_TIER_05        = "Pre-ICL Drug Type for Tier 5"
         PRE_ICL_DRUG_TYPE_TIER_06        = "Pre-ICL Drug Type for Tier 6"
         PRE_ICL_DRUG_TYPE_TIER_07        = "Pre-ICL Drug Type for Tier 7"
         PRE_ICL_DRUG_TYPE_TIER_08        = "Pre-ICL Drug Type for Tier 8"
         PRE_ICL_DRUG_TYPE_TIER_09        = "Pre-ICL Drug Type for Tier 9"
         PRE_ICL_INP_1M_COPAY_TIER_01     = "Pre-ICL In-network Pharmacy 1 month Copay for Tier 1"
         PRE_ICL_INP_1M_COPAY_TIER_02     = "Pre-ICL In-network Pharmacy 1 month Copay for Tier 2"
         PRE_ICL_INP_1M_COPAY_TIER_03     = "Pre-ICL In-network Pharmacy 1 month Copay for Tier 3"
         PRE_ICL_INP_1M_COPAY_TIER_04     = "Pre-ICL In-network Pharmacy 1 month Copay for Tier 4"
         PRE_ICL_INP_1M_COPAY_TIER_05     = "Pre-ICL In-network Pharmacy 1 month Copay for Tier 5"
         PRE_ICL_INP_1M_COPAY_TIER_06     = "Pre-ICL In-network Pharmacy 1 month Copay for Tier 6"
         PRE_ICL_INP_1M_COPAY_TIER_07     = "Pre-ICL In-network Pharmacy 1 month Copay for Tier 7"
         PRE_ICL_INP_1M_COPAY_TIER_08     = "Pre-ICL In-network Pharmacy 1 month Copay for Tier 8"
         PRE_ICL_INP_1M_COPAY_TIER_09     = "Pre-ICL In-network Pharmacy 1 month Copay for Tier 9"
         PRE_ICL_INP_1M_COINS_TIER_01     = "Pre-ICL In-network Pharmacy 1 month Coinsurance for Tier 1"
         PRE_ICL_INP_1M_COINS_TIER_02     = "Pre-ICL In-network Pharmacy 1 month Coinsurance for Tier 2"
         PRE_ICL_INP_1M_COINS_TIER_03     = "Pre-ICL In-network Pharmacy 1 month Coinsurance for Tier 3"
         PRE_ICL_INP_1M_COINS_TIER_04     = "Pre-ICL In-network Pharmacy 1 month Coinsurance for Tier 4"
         PRE_ICL_INP_1M_COINS_TIER_05     = "Pre-ICL In-network Pharmacy 1 month Coinsurance for Tier 5"
         PRE_ICL_INP_1M_COINS_TIER_06     = "Pre-ICL In-network Pharmacy 1 month Coinsurance for Tier 6"
         PRE_ICL_INP_1M_COINS_TIER_07     = "Pre-ICL In-network Pharmacy 1 month Coinsurance for Tier 7"
         PRE_ICL_INP_1M_COINS_TIER_08     = "Pre-ICL In-network Pharmacy 1 month Coinsurance for Tier 8"
         PRE_ICL_INP_1M_COINS_TIER_09     = "Pre-ICL In-network Pharmacy 1 month Coinsurance for Tier 9"
         GAP_DRUG_TYPE_TIER_01            = "Gap Drug Type for Tier 1"
         GAP_DRUG_TYPE_TIER_02            = "Gap Drug Type for Tier 2"
         GAP_DRUG_TYPE_TIER_03            = "Gap Drug Type for Tier 3"
         GAP_DRUG_TYPE_TIER_04            = "Gap Drug Type for Tier 4"
         GAP_DRUG_TYPE_TIER_05            = "Gap Drug Type for Tier 5"
         GAP_DRUG_TYPE_TIER_06            = "Gap Drug Type for Tier 6"
         GAP_DRUG_TYPE_TIER_07            = "Gap Drug Type for Tier 7"
         GAP_DRUG_TYPE_TIER_08            = "Gap Drug Type for Tier 8"
         GAP_DRUG_TYPE_TIER_09            = "Gap Drug Type for Tier 9"
         GAP_INP_1M_COPAY_TIER_01         = "Gap In-network Pharmacy 1 month Copay for Tier 1"
         GAP_INP_1M_COPAY_TIER_02         = "Gap In-network Pharmacy 1 month Copay for Tier 2"
         GAP_INP_1M_COPAY_TIER_03         = "Gap In-network Pharmacy 1 month Copay for Tier 3"
         GAP_INP_1M_COPAY_TIER_04         = "Gap In-network Pharmacy 1 month Copay for Tier 4"
         GAP_INP_1M_COPAY_TIER_05         = "Gap In-network Pharmacy 1 month Copay for Tier 5"
         GAP_INP_1M_COPAY_TIER_06         = "Gap In-network Pharmacy 1 month Copay for Tier 6"
         GAP_INP_1M_COPAY_TIER_07         = "Gap In-network Pharmacy 1 month Copay for Tier 7"
         GAP_INP_1M_COPAY_TIER_08         = "Gap In-network Pharmacy 1 month Copay for Tier 8"
         GAP_INP_1M_COPAY_TIER_09         = "Gap In-network Pharmacy 1 month Copay for Tier 9"
         GAP_INP_1M_COINS_TIER_01         = "Gap In-network Pharmacy 1 month Coinsurance for Tier 1"
         GAP_INP_1M_COINS_TIER_02         = "Gap In-network Pharmacy 1 month Coinsurance for Tier 2"
         GAP_INP_1M_COINS_TIER_03         = "Gap In-network Pharmacy 1 month Coinsurance for Tier 3"
         GAP_INP_1M_COINS_TIER_04         = "Gap In-network Pharmacy 1 month Coinsurance for Tier 4"
         GAP_INP_1M_COINS_TIER_05         = "Gap In-network Pharmacy 1 month Coinsurance for Tier 5"
         GAP_INP_1M_COINS_TIER_06         = "Gap In-network Pharmacy 1 month Coinsurance for Tier 6"
         GAP_INP_1M_COINS_TIER_07         = "Gap In-network Pharmacy 1 month Coinsurance for Tier 7"
         GAP_INP_1M_COINS_TIER_08         = "Gap In-network Pharmacy 1 month Coinsurance for Tier 8"
         GAP_INP_1M_COINS_TIER_09         = "Gap In-network Pharmacy 1 month Coinsurance for Tier 9";

  infile in missover truncover;

  input @0001  CONTRACT_ID                      $5.
        @0006  PLAN_ID                          $3.
        @0009  FORMULARY_ID                     $8.
        @0017  CONTRACT_NAME                    $150.
        @0167  PLAN_NAME                        $75.
        @0242  ORGANIZATION_MARKETING_NAME      $150.
        @0392  EFFECTIVE_DATE                   $10.
        @0402  ORGANIZATION_TYPE                $2.
        @0404  PLAN_TYPE                        $2.
        @0406  DEMO_TYPE                        $1.
        @0407  REINSURANCE_DEMO_TYPE            $1.
        @0408  SNP_TYPE                         $1.
        @0409  DRUG_BENEFIT_TYPE                $1.
        @0410  EGWP_INDICATOR                   $1.
        @0411  EGHP_CALENDAR_YEAR_FLAG          $1.
        @0412  COV_CRITERIA                     $1.
        @0413  NATIONAL_PDP                     $1.
        @0414  GAP_COVERAGE_TYPE                $1.
        @0415  DED_APPLY                        $1.
        @0416  DED_AMT                          12.2
        @0428  DED_APPLY_ALL                    $1.
        @0429  DED_GENERIC_COPAY                12.2
        @0441  FREE_FIRST_FILL                  $1.
        @0442  LESSER_OF_PRICING                $1.
        @0443  PRE_ICL_APPLY                    $1.
        @0444  ICL_APPLY                        $1.
        @0445  ICL_AMT                          12.2
        @0457  POST_OOPT_APPLY                  $1.
        @0458  OOPT_AMT                         12.2
        @0470  EXCLUDED_DRUGS                   $1.
        @0471  REDUCED_COST_SHARE               $1.
        @0472  REDUCED_DED                      $1.
        @0473  REDUCED_PREICL_CS                $1.
        @0474  REDUCED_GAP_CS                   $1.
        @0475  REDUCED_OOPT_CS                  $1.
        @0476  SPECIALTY_TIER                   $3.
        @0479 (PRE_ICL_DRUG_TYPE_TIER_01-PRE_ICL_DRUG_TYPE_TIER_09)       ($6.)
        @0533 (PRE_ICL_INP_1M_COPAY_TIER_01-PRE_ICL_INP_1M_COPAY_TIER_09) (12.2)
        @0641 (PRE_ICL_INP_1M_COINS_TIER_01-PRE_ICL_INP_1M_COINS_TIER_09) (12.2)
        @0749 (GAP_DRUG_TYPE_TIER_01-GAP_DRUG_TYPE_TIER_09)               ($6.)
        @0803 (GAP_INP_1M_COPAY_TIER_01-GAP_INP_1M_COPAY_TIER_09)         (12.2)
        @0911 (GAP_INP_1M_COINS_TIER_01-GAP_INP_1M_COINS_TIER_09)         (12.2);
run;

title 'Part D Plan Characteristics 2007';
proc contents data=out.PLAN_CHAR_2007 varnum;
proc print data=out.PLAN_CHAR_2007(obs=5);
  title2 'Sample Listing - First 5 Rows';
run;
proc means data=out.PLAN_CHAR_2007;
  title2 'Simple Means';
run;

proc freq data=out.PLAN_CHAR_2007;
  title2 'Freqs';
  table COV_CRITERIA
        DED_APPLY
        DED_APPLY_ALL
        DEMO_TYPE
        DRUG_BENEFIT_TYPE
        EGHP_CALENDAR_YEAR_FLAG
        EGWP_INDICATOR
        EXCLUDED_DRUGS
        FREE_FIRST_FILL
        GAP_COVERAGE_TYPE
        ICL_APPLY
        LESSER_OF_PRICING
        NATIONAL_PDP
        ORGANIZATION_TYPE
        PLAN_TYPE
        POST_OOPT_APPLY
        PRE_ICL_APPLY
        REDUCED_COST_SHARE
        REDUCED_DED
        REDUCED_GAP_CS
        REDUCED_OOPT_CS
        REDUCED_PREICL_CS
        REINSURANCE_DEMO_TYPE
        SNP_TYPE/missing;
run;

* End of Program *;
