*** Code Formats for 2007 Part D Plan and Premium Characteristic Files ***;

proc format;

*EGWP_INDICATOR, EGHP_CALENDAR_YEAR_FLAG, NATIONAL_PDP, FREE_FIRST_FILL, LESSER_OF_PRICING,
 EXCLUDED_DRUGS, REDUCED_DED, REDUCED_PREICL_CS, REDUCED_GAP_CS, REDUCED_OOPT_CS;

value $yesno
'Y'='Yes'
'N'='No'
'9'='Not Applicable'
;

*ORGANIZATION_TYPE;
Value $ org_tp
'01'  = 'Local CCP'
'04'  = 'PFFS'
'05'  = 'Demo'
'06'  = '1876 Cost'
'08'  = 'National PACE'
'10'  = 'PDP'
'11'  = 'Regional CCP'
'13'  = 'Employer/Union Only Direct Contract PDP'
'14'  = 'Employer/Union Only Direct Contract PFFS'
;

*PLAN_TYPE;

Value $ plan_tp
'01' = 'HMO'
'02' = 'HMOPOS'
'04' = 'PPO'
'05' = 'PSO (State License)'
'06' = 'PSO (Federal Waiver of State License)'
'09' = 'PFFS'
'10' = 'SHMO'
'18' = '1876 Cost'
'20' = 'National PACE'
'29' = 'Medicare Prescription Drug Plan'
'30' = 'Employer Sponsored PDP'
'31' = 'Regional PPO'
'33' = 'MN Disability Health Options'
'34' = 'MN Senior Health Options'
'35' = 'WI Partnership Program'
'36' = 'MA Health Senior Care Options'
'37' = 'Continuing Care Retirement Community'
'39' = 'ESRD II'
;

*DEMO_TYPE;
Value $ demo_tp
'0'='Non-Demo'
'1'='CCRC Demo'
'2'='ESRDII Demo'
'3'='MA Health Senior Care Options'
'4'='Minnesota Disability Health Options'
'5'='Minnesota Senior Health Options'
'6'='SHMO'
'7'='SHMO II'
'8'='Wisconsin Partnership Program'
;

*REINSURANCE_DEMO_TYPE;
Value $ reins_tp
'0'= 'Non-Payment Demo'
'1'= 'Flexible capitated option'
'2'= 'Fixed capitated option'
'3'= 'Flexible MA rebate option'
;

*SNP_TYPE;
Value $ snp_tp
'0'= 'Non-SNP'
'C'= 'Chronic or Disabling Condition'
'D'= 'Dual-Eligible'
'I'= 'Institutional'
;

*DRUG_BENEFIT_TYPE;
Value $ benefit
'1' ='Defined Standard Benefit'
'2' ='Actuarially Equivalent Standard'
'3' ='Basic Alternative'
'4' ='Enhanced Alternative'
;

*COV_CRITERIA;
Value $ ben_cov
'1'='Part A/B'
'2'='Part B Only'
'9'='Not Applicable'
;

*DED_APPLY;
Value $ ded_ap
'1'='Medicare-defined amount'
'2'='Plan-defined amount'
'3'='No deductible'
;

*DED_APPLY_ALL;
value $ded_tp
'1'='Deductible applies to all drugs'
'2'='Deductible does not apply to generic drugs'
'9'='Not Applicable'
;

*PRE_ICL_APPLY;
Value $ pre_ap
'1'='Medicare-defined Part D Coinsurance Amount'
'2'='Cost Share Tiers'
'3'='No cost sharing'
;

*ICL_APPLY;
Value $ icl_ap
 '1'='Medicare-defined amount'
 '2'='Plan-defined amount'
 '3'='No ICL'
;

*POST_OOPT_APPLY;
Value $ post_ap
'1'= 'Medicare-defined Post Threshold Cost Shares'
'2'= 'Cost Share Tiers'
'3'= 'No cost sharing'
;

*GAP_COVERAGE_TYPE;
value $ gap
'N'  ='No Gap Coverage'
'G'  ='Generics'
'P'  ='Generics and Preferred Brands'
'B'  ='Generics and Brands'
'A'  ='All Formulary Drugs'
'9'  ='Not Applicable'
;

*BELOW_BENCHMARK;
value $ bench
'D'= 'Below De minimus Amount'
'B'= 'Below Regional Benchmark'
'N'= 'No'
'9'= 'Not Applicable'
;

*PRE_ICL_DRUG_TYPE_TIER_1 - PRE_ICL_DRUG_TYPE_TIER_9;
*GAP_DRUG_TYPE_TIER_1 - GAP_DRUG_TYPE_TIER_9;
*Drug type Codes:
1 in 2  Generic
1 in 3  Preferred Generic
1 in 4  Non-Preferred Generic
1 in 5  Brand
1 in 6  Preferred Brand
1 in 1  Non-Preferred Brand
all 9's =Not Applicable
;

*PRE_ICL_COSTSHARE_TYPE, GAP_COSTSHARE_TYPE, and POST_OOPT_COSTSHARE_TYPE;
value $ cs_tp
'1'= 'Coinsurance'
'2'= 'Copayment'
'3'= 'Greater of Coinsurance and Copayment'
'4'= 'Lesser of Coinsurance and Copayment'
;

run;
