*** SAS Custom Formats for Use with 2008 Part D Plan Characteristic Files ***;

proc format;

*EGHP_CALENDAR_YEAR_FLAG, EGWP_INDICATOR, EXCLUDED_DRUGS, FREE_FIRST_FILL, FREE_GENERICS,
 GAP_PARTIAL_TIER, GAP_TIER, LESSER_OF_PRICING, LIMITED_GAP_BENEFIT, NATIONAL_PDP,
 NAT_RX_COV_YN, OTC_UM_PROGRAM, REDUCED_DED, REDUCED_GAP_CS, REDUCED_OOPT_CS,
 REDUCED_PREICL_CS, REDUCED_COST_SHARE, SPECIALTY_ACCESS, SPECIALTY_TIER (in Tier File);

value $yesno
'Y'='Yes'
'N'='No'
'9'='Not Applicable'
;


*ORGANIZATION_TYPE;

Value $ org_tp
'01'  = 'Local CCP'
'04'  = 'PFFS'
'05'  = 'Demo'
'06'  = '1876 Cost'
'08'  = 'National PACE'
'10'  = 'PDP'
'11'  = 'Regional CCP'
'13'  = 'Employer/Union Only Direct Contract PDP'
'14'  = 'Employer/Union Only Direct Contract PFFS'
;


*PLAN_TYPE;
Value $ plan_tp
'01' = 'HMO'
'02' = 'HMOPOS'
'04' = 'PPO'
'05' = 'PSO (State License)'
'09' = 'PFFS'
'18' = '1876 Cost'
'20' = 'National PACE'
'29' = 'Medicare Prescription Drug Plan'
'30' = 'Employer/Union Only Direct Contract PDP'
'31' = 'Regional PPO'
'37' = 'Continuing Care Retirement Community'
'39' = 'ESRD II'
'40' = 'Employer/Union Only Direct Contract PFFS'
;

*DEMO_TYPE;

Value $ demo_tp
'0'='Non-Demo'
'1'='CCRC Demo'
'2'='ESRDII Demo'
;

*REINSURANCE_DEMO_TYPE;
Value $ reins_tp
'0'= 'Non-Payment Demo'
'1'= 'Flexible capitated option'
'2'= 'Fixed capitated option'
'3'= 'Flexible MA rebate option'
;
*SNP_TYPE;
Value $ snp_tp
'0'= 'Non-SNP'
'C'= 'Chronic or Disabling Condition'
'D'= 'Dual-Eligible'
'I'= 'Institutional'
;
*DRUG_BENEFIT_TYPE;
Value $ benefit
'0' ='No Plan Benefit Information Available'
'1' ='Defined Standard Benefit'
'2' ='Actuarially Equivalent Standard'
'3' ='Basic Alternative'
'4' ='Enhanced Alternative'
;
*COV_CRITERIA;
Value $ ben_cov
'1'='Part A/B'
'2'='Part B Only'
'9'='Not Applicable'
;
*DED_APPLY;
Value $ ded_ap
'1'='Medicare-defined amount'
'2'='Plan-defined amount'
'3'='No deductible'
;
*DED_APPLY_ALL;
value $ ded_tp
'1'='Deductible applies to all drugs'
'2'='Deductible does not apply to generic drugs'
'9'='Not Applicable'
;

*PRE_ICL_COSTSHARE_TYPE, GAP_COSTSHARE_TYPE, and POST_OOPT_COSTSHARE_TYPE;
value $ cs_tp
'1'= 'Coinsurance'
'2'= 'Copayment'
'3'= 'Greater of Coinsurance and Copayment'
'4'= 'Lesser of Coinsurance and Copayment'
;
*PRE_ICL_APPLY;
Value $ pre_ap
'1'='Medicare-defined Part D Coinsurance Amount'
'2'='Cost Share Tiers'
'3'='No cost sharing'
;
*ICL_APPLY;
Value $ icl_ap
 '1'='Medicare-defined amount'
 '2'='Plan-defined amount'
 '3'='No ICL'
;
*POST_OOPT_APPLY;
Value $ post_ap
'1'= 'Medicare-defined Post Threshold Cost Shares'
'2'= 'Cost Share Tiers'
'3'= 'No cost sharing'
;
*GAP_COVERAGE_TYPE;
value $ gap
'20'= 'Some Generics'
'22'= 'Some Generics and Some Brands'
'30'= 'All Preferred Generics'
'40'= 'All Generics'
'32'= 'All Preferred Generics and Some Brands'
'42'= 'All Generics and Some Brands'
'33'= 'All Preferred Generics and All Preferred Brands'
'43'= 'All Generics and All Preferred Brands'
'44'= 'All Generics and All Brands'
'A' = 'All Drugs on Your Formulary'
'N' = 'No Gap Coverage'
;
*BELOW_BENCHMARK;
value $ bench
'D'= 'Below De minimus Amount'
'B'= 'Below Regional Benchmark'
'N'= 'No'
'9'= 'Not Applicable'
;
*PRE_ICL_TIER_DRUG_TYPE, GAP_TIER_DRUG_TYPE, POST_OOPT_TIER_DRUG_TYPE (in Plan and
 Tier Files)
1 in 2  Generic
1 in 3  Preferred Generic
1 in 4  Non-Preferred Generic
1 in 5  Brand
1 in 6  Preferred Brand
1 in 1  Non-Preferred Brand
all 9's =Not Applicable
;

*Gap Tier Partial Drug Type Codes:
1 in 1 Only Select Brands
1 in 2 All Generics
1 in 3 All Preferred Generics
1 in 4 All Non-Preferred Generics
1 in 5 Only Select Generics
1 in 6 All Brands
1 in 7 All Preferred Brands
1 in 8 All Non-Preferred Brands
;

run;
