***  Custom SAS Formats for 2010 Plan Characteristics Code Variables  ***;

proc format;


***  ORGANIZATION_TYPE  ***;
value $ org_tp
'01'='Local CCP'
'04'='PFFS'
'05'='Demo'
'06'='1876 Cost'
'08'='National PACE'
'10'='PDP'
'11'='Regional CCP'
'13'='Employer/Union Only Direct Contract PDP'
'14'='Employer/Union Only Direct Contract PFFS'
'16'='POS Contractor'
;


***  PLAN_TYPE  ***;
value $ plan_tp
'01'='HMO'
'02'='HMOPOS'
'04'='Local PPO'
'05'='PSO (State License)'
'09'='PFFS'
'18'='1876 Cost'
'20'='National PACE'
'29'='Medicare Prescription Drug Plan'
'30'='Employer/Union Only Direct Contract PDP'
'31'='Regional PPO'
'37'='Continuing Care Retirement Community'
'39'='ESRD II'
'40'='Employer/Union Only Direct Contract PFFS'
'46'='Point-of-Sale Contractor'
;

***  DEMO_TYPE  ***;
value $ demo_tp
'0'='Non-Demo'
'1'='CCRC Demo'
'2'='ESRDII Demo'
;

***  REINSURANCE_DEMO_TYPE  ***;
value  $ reins_tp
'0'='Non-Payment Demo'
'1'='Flexible capitated option'
'2'='Fixed capitated option'
'3'='Flexible MA rebate option'
;

***  SNP_TYPE  ***;
value $ snp_tp
'0'='Non-SNP'
'C'='Chronic or Disabling Condition'
'D'='Dual-Eligible'
'I'='Institutional'
;

***  DRUG_BENEFIT_TYPE  ***;
value  $ benefit
'0'='No Plan Benefit Information'
'1'='Defined Standard Benefit'
'2'='Actuarially Equivalent Standard'
'3'='Basic Alternative'
'4'='Enhanced Alternative'
;

***  YES/NO VARIABLES  ***;
value $ yesno
'Y'='Yes'
'N'='No'
'9'='Not Applicable'
;

***  COV_CRITERIA  ***;
value  $ ben_cov
'1'='Part A/B'
'2'='Part B Only'
'9'='Not Applicable'
;

***  GAP_COVERAGE_TYPE  ***;
value $ gap
'10'='Few Generics'
'11'='Few Generics and Few Brands'
'20'='Some Generics'
'21'='Some Generics and Few Brands'
'22'='Some Generics and Some Brands'
'30'='All Preferred Generics'
'32'='All Preferred Generics and Some Brands'
'33'='All Preferred Generics and All Preferred Brands'
'40'='All Generics'
'41'='All Generics and Few Brands'
'42'='All Generics and Some Brands'
'43'='All Generics and All Preferred Brands'
'44'='All Generics and All Brands'
'50'='Many Generics'
'51'='Many Generics and Few Brands'
'52'='Many Generics and Some Brands'
'55'='Many Generics and Many Brands'
'A'='All Drugs on Your Formulary'
'N'='No Gap Coverage'
'9'='Not Applicable'
;

***  DED_APPLY  ***;
value $ ded_ap
'1'='Medicare-defined amount'
'2'='Plan-defined amount'
'3'='No deductible'
;

***  DED_APPLY_ALL  ***;
value $ ded_tp
'1'='No cost sharing'
'2'='Pre ICL cost sharing applies to selected tiers'
'3'='Other type of cost sharing applies to selected tiers'
'9'='Not Applicable'
;


***  PRE_ICL_APPLY  ***;
value  $ pre_ap
'1'='Medicare-defined Part D Coinsurance Amount'
'2'='Cost Share Tiers'
'3'='No cost sharing'
;

***  ICL_APPLY  ***;
value $ icl_ap
'1'='Medicare-defined amount'
'2'='Plan-defined amount'
'3'='No ICL'
;

***  POST_OOPT_APPLY  ***;
value $ post_ap
'1'='Medicare-defined Post Threshold Cost Shares'
'2'='Cost Share Tiers'
'3'='No cost sharing'
;

***  BELOW_BENCHMARK  ***;
value $ bench
'D'='Below De minimus Amount'
'B'='Below Regional Benchmark'
'N'='No'
'9'='Not Applicable'
;

***  TIER FILE COST SHARE VARIABLES  ***;
value $ cs_tp
'1'='Coinsurance'
'2'='Copayment'
'3'='Greater of Coinsurance and Copayment'
'4'='Lesser of Coinsurance and Copayment'
;

run;
