* SAS Read-In Program
*
* Name: plan_crosswalk_2009_readin.sas
*
* Purpose: Read-In the delimited flat file PLAN_CROSSWALK_2009.
*
* Delimiter: Fixed Column
*
* Date: 23DEC14   Time: 15:12
*
* Programmer: Adam Hendricks, Adam.Hendricks@gdit.com, 515-645-3015
*
*;

%let dirpath = .; * <--  Directory Path for Input Flat File in FILENAME Statement *;

filename in  "%trim(&dirpath)/plan_crosswalk_2009.dat" lrecl=32;

libname  out '.'; * <--  Directory Path for Output Library in LIBNAME Statement   *;

* Start *;
data out.PLAN_CROSSWALK_2009;
  length CONTRACT_ID_08                   $5
         PLAN_ID_08                       $3
         CONTRACT_ID_09                   $5
         PLAN_ID_09                       $3
         RELATIONSHIP_CODE                $1
         RELATIONSHIP_DESC                $15;

  format CONTRACT_ID_08                   $5.
         PLAN_ID_08                       $3.
         CONTRACT_ID_09                   $5.
         PLAN_ID_09                       $3.
         RELATIONSHIP_CODE                $1.
         RELATIONSHIP_DESC                $15.;

  label  CONTRACT_ID_08                   = "First Year Part D Plan Contract Identifier"
         PLAN_ID_08                       = "First Year Part D Plan Benefit Identifier"
         CONTRACT_ID_09                   = "Second Year Part D Plan Contract Identifier"
         PLAN_ID_09                       = "Second YearPart D Plan Benefit Identifier"
         RELATIONSHIP_CODE                = "Relationship Code"
         RELATIONSHIP_DESC                = "Relationship Description";

  infile in missover truncover;

  input @01    CONTRACT_ID_08                   $5.
        @06    PLAN_ID_08                       $3.
        @09    CONTRACT_ID_09                   $5.
        @14    PLAN_ID_09                       $3.
        @17    RELATIONSHIP_CODE                $1.
        @18    RELATIONSHIP_DESC                $15.;
run;

title 'Part D Plan Crosswalk 2009';
proc contents data=out.PLAN_CROSSWALK_2009 varnum;
proc print data=out.PLAN_CROSSWALK_2009(obs=5);
  title2 'Sample Listing - First 5 Rows';
run;

proc freq data=out.PLAN_CROSSWALK_2009;
  title2 'Freqs';
  table RELATIONSHIP_CODE/missing;
run;

* End of Program *;
