* SAS Read-In Program
*
* Name: plan_crosswalk_2013_readin.sas
*
* Purpose: Read-In the delimited flat file PLAN_CROSSWALK_2013.
*
* Delimiter: Fixed Column
*
* Date: 17DEC14   Time: 11:30
*
* Programmer: Adam Hendricks, Adam.Hendricks@gdit.com, 515-645-3015
*
*;

%let dirpath = .; * <--  Directory Path for Input Flat File in FILENAME Statement *;

filename in  "%trim(&dirpath)/plan_crosswalk_2013.dat" lrecl=32;

libname  out '.'; * <--  Directory Path for Output Library in LIBNAME Statement   *;

* Start *;
data out.PLAN_CROSSWALK_2013;
  length CONTRACT_ID_12                   $5
         PLAN_ID_12                       $3
         CONTRACT_ID_13                   $5
         PLAN_ID_13                       $3
         RELATIONSHIP_CODE                $1
         RELATIONSHIP_DESC                $15;

  format CONTRACT_ID_12                   $5.
         PLAN_ID_12                       $3.
         CONTRACT_ID_13                   $5.
         PLAN_ID_13                       $3.
         RELATIONSHIP_CODE                $1.
         RELATIONSHIP_DESC                $15.;

  label  CONTRACT_ID_12                   = "Previous Year Part D Plan Contract Identifier"
         PLAN_ID_12                       = "Previous Year Part D Plan Benefit Identifier"
         CONTRACT_ID_13                   = "Reference Year Part D Plan Contract Identifier"
         PLAN_ID_13                       = "Reference Year Part D Plan Benefit Identifier"
         RELATIONSHIP_CODE                = "Relationship Code"
         RELATIONSHIP_DESC                = "Relationship Description";

  infile in missover truncover;

  input @01    CONTRACT_ID_12                   $5.
        @06    PLAN_ID_12                       $3.
        @09    CONTRACT_ID_13                   $5.
        @14    PLAN_ID_13                       $3.
        @17    RELATIONSHIP_CODE                $1.
        @18    RELATIONSHIP_DESC                $15.;
run;

title 'Part D Plan Crosswalk 2013';
proc contents data=out.PLAN_CROSSWALK_2013 varnum;
proc print data=out.PLAN_CROSSWALK_2013(obs=5);
  title2 'Sample Listing - First 5 Rows';
run;

proc freq data=out.PLAN_CROSSWALK_2013;
  title2 'Freqs';
  table RELATIONSHIP_CODE/missing;
run;

* End of Program *;
