* SAS Read-In Program
*
* Name: plan_crosswalk_2014_readin.sas
*
* Purpose: Read-In the delimited flat file PLAN_CROSSWALK_2014.
*
* Delimiter: Fixed Column
*
* Date: 14DEC15   Time: 17:24
*
* Help: cmsdata@gdit.com, 1-866-766-1915
*
*;
 
filename in  'plan_crosswalk_2014.dat'  lrecl=32;
libname  ccw '.';
 
data ccw.PLAN_CROSSWALK_2014;
  length CONTRACT_ID_13                   $5
         PLAN_ID_13                       $3
         CONTRACT_ID_14                   $5
         PLAN_ID_14                       $3
         RELATIONSHIP_CODE                $1
         RELATIONSHIP_DESC                $15;
 
  format CONTRACT_ID_13                   $5.
         PLAN_ID_13                       $3.
         CONTRACT_ID_14                   $5.
         PLAN_ID_14                       $3.
         RELATIONSHIP_CODE                $1.
         RELATIONSHIP_DESC                $15.;
 
  label  CONTRACT_ID_13                   = "Previous Year Part D Plan Contract Identifier"
         PLAN_ID_13                       = "Previous Year Part D Plan Benefit Identifier"
         CONTRACT_ID_14                   = "Reference Year Part D Plan Contract Identifier"
         PLAN_ID_14                       = "Reference Year Part D Plan Benefit Identifier"
         RELATIONSHIP_CODE                = "Relationship Code"
         RELATIONSHIP_DESC                = "Relationship Description";
 
  infile in missover truncover;
 
  input @01    CONTRACT_ID_13                   $5.
        @06    PLAN_ID_13                       $3.
        @09    CONTRACT_ID_14                   $5.
        @14    PLAN_ID_14                       $3.
        @17    RELATIONSHIP_CODE                $1.
        @18    RELATIONSHIP_DESC                $15.;
run;
 
title 'PLAN_CROSSWALK_2014';
proc contents data=ccw.PLAN_CROSSWALK_2014 varnum;
proc print data=ccw.PLAN_CROSSWALK_2014(obs=5);
  title2 'Sample Listing - First 5 Rows';
run;
proc means data=ccw.PLAN_CROSSWALK_2014;
  title2 'Simple Means';
run;
 
proc freq data=ccw.PLAN_CROSSWALK_2014;
  title2 'Freqs';
  table
    RELATIONSHIP_CODE               
        /missing;
run;
 
* End of Program *;
