* SAS Read-In Program
*
* Name: plan_crosswalk_2015_readin.sas
*
* Purpose: Read-In the delimited flat file PLAN_CROSSWALK_2015.
*
* Delimiter: Fixed Column
*
* Date: 09MAY18   Time: 13:57
*
* Help: cmsdata@gdit.com, 1-866-766-1915
*
*;

filename in  'plan_crosswalk_2015.dat'  lrecl=32768;
libname  ccw '.';

data ccw.PLAN_CROSSWALK_2015;
  length CONTRACT_ID_14                   $5
         PLAN_ID_14                       $3
         CONTRACT_ID_15                   $5
         PLAN_ID_15                       $3
         PTCD_INDICATOR_15                $1
         RELATIONSHIP_CODE                $1
         RELATIONSHIP_DESC                $15;

  format CONTRACT_ID_14                   $5.
         PLAN_ID_14                       $3.
         CONTRACT_ID_15                   $5.
         PLAN_ID_15                       $3.
         PTCD_INDICATOR_15                $1.
         RELATIONSHIP_CODE                $1.
         RELATIONSHIP_DESC                $15.;

  label  CONTRACT_ID_14                   = "Previous Year Part D Plan Contract Identifier"
         PLAN_ID_14                       = "Previous Year Part D Plan Benefit Identifier"
         CONTRACT_ID_15                   = "Reference Year Part D Plan Contract Identifier"
         PLAN_ID_15                       = "Reference Year Part D Plan Benefit Identifier"
         PTCD_INDICATOR_15                = "Indicates Whether the Reference Year Plan is Part C, Part D or Both"
         RELATIONSHIP_CODE                = "Relationship Code"
         RELATIONSHIP_DESC                = "Relationship Description";

  infile in missover truncover;

  input @01    CONTRACT_ID_14                   $5.
        @06    PLAN_ID_14                       $3.
        @09    CONTRACT_ID_15                   $5.
        @14    PLAN_ID_15                       $3.
        @17    PTCD_INDICATOR_15                $1.
        @18    RELATIONSHIP_CODE                $1.
        @19    RELATIONSHIP_DESC                $15.;
run;

title 'PLAN_CROSSWALK_2015';
proc contents data=ccw.PLAN_CROSSWALK_2015 varnum;
proc print data=ccw.PLAN_CROSSWALK_2015(obs=5);
  title2 'Sample Listing - First 5 Rows';
run;
proc means data=ccw.PLAN_CROSSWALK_2015;
  title2 'Simple Means';
run;

proc freq data=ccw.PLAN_CROSSWALK_2015;
  title2 'Freqs';
  table
    PTCD_INDICATOR_15
    RELATIONSHIP_CODE
        /missing;
run;

* End of Program *;
