* SAS Read-In Program
*
* Name: plan_crosswalk_2016_readin.sas
*
* Purpose: Read-In the delimited flat file PLAN_CROSSWALK_2016.
*
* Delimiter: Fixed Column
*
* Date: 09MAY18   Time: 14:12
*
* Help: cmsdata@gdit.com, 1-866-766-1915
*
*;

filename in  'plan_crosswalk_2016.dat'  lrecl=32768;
libname  ccw '.';

data ccw.PLAN_CROSSWALK_2016;
  length CONTRACT_ID_15                   $5
         PLAN_ID_15                       $3
         CONTRACT_ID_16                   $5
         PLAN_ID_16                       $3
         PTCD_INDICATOR_16                $1
         RELATIONSHIP_CODE                $1
         RELATIONSHIP_DESC                $15;

  format CONTRACT_ID_15                   $5.
         PLAN_ID_15                       $3.
         CONTRACT_ID_16                   $5.
         PLAN_ID_16                       $3.
         PTCD_INDICATOR_16                $1.
         RELATIONSHIP_CODE                $1.
         RELATIONSHIP_DESC                $15.;

  label  CONTRACT_ID_15                   = "Previous Year Contract Identifier"
         PLAN_ID_15                       = "Previous Year Plan Benefit Package Identifier"
         CONTRACT_ID_16                   = "Reference Year Contract Identifier"
         PLAN_ID_16                       = "Reference Year Plan Benefit Package Identifier"
         PTCD_INDICATOR_16                = "Indicates Whether the Reference Year Plan is Part C, Part D or Both"
         RELATIONSHIP_CODE                = "Relationship Code"
         RELATIONSHIP_DESC                = "Relationship Description";

  infile in missover truncover;

  input @01    CONTRACT_ID_15                   $5.
        @06    PLAN_ID_15                       $3.
        @09    CONTRACT_ID_16                   $5.
        @14    PLAN_ID_16                       $3.
        @17    PTCD_INDICATOR_16                $1.
        @18    RELATIONSHIP_CODE                $1.
        @19    RELATIONSHIP_DESC                $15.;
run;

title 'PLAN_CROSSWALK_2016';
proc contents data=ccw.PLAN_CROSSWALK_2016 varnum;
proc print data=ccw.PLAN_CROSSWALK_2016(obs=5);
  title2 'Sample Listing - First 5 Rows';
run;
proc means data=ccw.PLAN_CROSSWALK_2016;
  title2 'Simple Means';
run;

proc freq data=ccw.PLAN_CROSSWALK_2016;
  title2 'Freqs';
  table
    PTCD_INDICATOR_16
    RELATIONSHIP_CODE
        /missing;
run;

* End of Program *;
