* SAS Read-In Program
*
* Name: premium_2016_readin.sas
*
* Purpose: Read-In the delimited flat file PREMIUM_2016.
*
* Delimiter: Fixed Column
*
* Date: 09MAY18   Time: 14:01
*
* Help: cmsdata@gdit.com, 1-866-766-1915
*
*;

filename in  'premium_2016.dat'  lrecl=32768;
libname  ccw '.';

data ccw.PREMIUM_2016;
  length CONTRACT_ID                      $5
         PLAN_ID                          $3
         SEGMENT_ID                       $3
         PTCD_INDICATOR                   $1
         PART_B_PREMIUM_REDUCTION_AMT     8
         PART_C_PREMIUM                   8
         PLAN_BASIC_PREMIUM_NET_REBATE    8
         PLAN_SUPP_PREMIUM_NET_REBATE     8
         PLAN_TOTAL_PREMIUM_NET_REBATE    8
         PART_D_LIS_25                    8
         PART_D_LIS_50                    8
         PART_D_LIS_75                    8
         PART_D_LIS_100                   8
         PART_D_LIPS_25                   8
         PART_D_LIPS_50                   8
         PART_D_LIPS_75                   8
         PART_D_LIPS_100                  8
         BELOW_BENCHMARK                  $1;

  format CONTRACT_ID                      $5.
         PLAN_ID                          $3.
         SEGMENT_ID                       $3.
         PTCD_INDICATOR                   $1.
         PART_B_PREMIUM_REDUCTION_AMT     12.2
         PART_C_PREMIUM                   12.2
         PLAN_BASIC_PREMIUM_NET_REBATE    12.2
         PLAN_SUPP_PREMIUM_NET_REBATE     12.2
         PLAN_TOTAL_PREMIUM_NET_REBATE    12.2
         PART_D_LIS_25                    12.2
         PART_D_LIS_50                    12.2
         PART_D_LIS_75                    12.2
         PART_D_LIS_100                   12.2
         PART_D_LIPS_25                   12.2
         PART_D_LIPS_50                   12.2
         PART_D_LIPS_75                   12.2
         PART_D_LIPS_100                  12.2
         BELOW_BENCHMARK                  $1.;

  label  CONTRACT_ID                      = "Contract ID"
         PLAN_ID                          = "Plan ID"
         SEGMENT_ID                       = "Segment Identifier"
         PTCD_INDICATOR                   = "Indicates Whether the Plan is Part C, Part D or Both"
         PART_B_PREMIUM_REDUCTION_AMT     = "Part B Premium Reduction Amt"
         PART_C_PREMIUM                   = "Part C Premium"
         PLAN_BASIC_PREMIUM_NET_REBATE    = "Part D Basic Premium Net of Rebate"
         PLAN_SUPP_PREMIUM_NET_REBATE     = "Part D Supplemental Premium Net of Rebate"
         PLAN_TOTAL_PREMIUM_NET_REBATE    = "Part D Total Premium Net of Rebate"
         PART_D_LIS_25                    = "Part D Low Income Subsidy 25%"
         PART_D_LIS_50                    = "Part D Low Income Subsidy 50%"
         PART_D_LIS_75                    = "Part D Low Income Subsidy 75%"
         PART_D_LIS_100                   = "Part D Low Income Subsidy 100%"
         PART_D_LIPS_25                   = "Part D Low Income Premium Subsidy 25%"
         PART_D_LIPS_50                   = "Part D Low Income Premium Subsidy 50%"
         PART_D_LIPS_75                   = "Part D Low Income Premium Subsidy 75%"
         PART_D_LIPS_100                  = "Part D Low Income Premium Subsidy 100%"
         BELOW_BENCHMARK                  = "Indicates whether the PDP is a basic plan with a premium below the regional benchmark or de minimis amount";

  infile in missover truncover;

  input @001   CONTRACT_ID                      $5.
        @006   PLAN_ID                          $3.
        @009   SEGMENT_ID                       $3.
        @012   PTCD_INDICATOR                   $1.
        @013   PART_B_PREMIUM_REDUCTION_AMT     12.2
        @025   PART_C_PREMIUM                   12.2
        @037   PLAN_BASIC_PREMIUM_NET_REBATE    12.2
        @049   PLAN_SUPP_PREMIUM_NET_REBATE     12.2
        @061   PLAN_TOTAL_PREMIUM_NET_REBATE    12.2
        @073   PART_D_LIS_25                    12.2
        @085   PART_D_LIS_50                    12.2
        @097   PART_D_LIS_75                    12.2
        @109   PART_D_LIS_100                   12.2
        @121   PART_D_LIPS_25                   12.2
        @133   PART_D_LIPS_50                   12.2
        @145   PART_D_LIPS_75                   12.2
        @157   PART_D_LIPS_100                  12.2
        @169   BELOW_BENCHMARK                  $1.;
run;

title 'PREMIUM_2016';
proc contents data=ccw.PREMIUM_2016 varnum;
proc print data=ccw.PREMIUM_2016(obs=5);
  title2 'Sample Listing - First 5 Rows';
run;
proc means data=ccw.PREMIUM_2016;
  title2 'Simple Means';
run;

proc freq data=ccw.PREMIUM_2016;
  title2 'Freqs';
  table
    BELOW_BENCHMARK
    PTCD_INDICATOR
        /missing;
run;

* End of Program *;
