* SAS Read-In Program
*
* Name: service_area_2012_readin.sas
*
* Purpose: Read-In the delimited flat file SERVICE_AREA_2012.
*
* Delimiter: Fixed Column
*
* Date: 17DEC14   Time: 18:03
*
* Programmer: Adam Hendricks, Adam.Hendricks@gdit.com, 515-645-3015
*
*;

%let dirpath = .; * <--  Directory Path for Input Flat File in FILENAME Statement *;

filename in  "%trim(&dirpath)/service_area_2012.dat" lrecl=193;

libname  out '.'; * <--  Directory Path for Output Library in LIBNAME Statement   *;

* Start *;
data out.SERVICE_AREA_2012;
  length CONTRACT_ID                      $5
         PLAN_ID                          $3
         SEGMENT_ID                       $3
         STATE_NAME                       $24
         COUNTY_NAME                      $30
         SSA_CODE                         $5
         PARTIAL_FLAG                     $1
         REGION_CODE                      $2
         REGION_NAME                      $120;

  format CONTRACT_ID                      $5.
         PLAN_ID                          $3.
         SEGMENT_ID                       $3.
         STATE_NAME                       $24.
         COUNTY_NAME                      $30.
         SSA_CODE                         $5.
         PARTIAL_FLAG                     $1.
         REGION_CODE                      $2.
         REGION_NAME                      $120.;

  label  CONTRACT_ID                      = "Contract ID"
         PLAN_ID                          = "Plan ID"
         SEGMENT_ID                       = "Segment ID"
         STATE_NAME                       = "State Name"
         COUNTY_NAME                      = "County Name"
         SSA_CODE                         = "SSA State Code + County Code"
         PARTIAL_FLAG                     = "Partial County Indicator"
         REGION_CODE                      = "Region Code"
         REGION_NAME                      = "Region Name";

  infile in missover truncover;

  input @001   CONTRACT_ID                      $5.
        @006   PLAN_ID                          $3.
        @009   SEGMENT_ID                       $3.
        @012   STATE_NAME                       $24.
        @036   COUNTY_NAME                      $30.
        @066   SSA_CODE                         $5.
        @071   PARTIAL_FLAG                     $1.
        @072   REGION_CODE                      $2.
        @074   REGION_NAME                      $120.;
run;

title 'Part D Service Area Characteristics 2012';
proc contents data=out.SERVICE_AREA_2012 varnum;
proc print data=out.SERVICE_AREA_2012(obs=5);
  title2 'Sample Listing - First 5 Rows';
run;

proc freq data=out.SERVICE_AREA_2012;
  title2 'Freqs';
  table PARTIAL_FLAG REGION_CODE/missing;
run;

* End of Program *;
