* SAS Read-In Program
*
* Name: service_area_2014_readin.sas
*
* Purpose: Read-In the delimited flat file SERVICE_AREA_2014.
*
* Delimiter: Fixed Column
*
* Date: 15DEC15   Time: 16:50
*
* Help: cmsdata@gdit.com, 1-866-766-1915
*
*;
 
filename in  'service_area_2014.dat'  lrecl=193;
libname  ccw '.';
 
data ccw.SERVICE_AREA_2014;
  length CONTRACT_ID                      $5
         PLAN_ID                          $3
         SEGMENT_ID                       $3
         STATE_NAME                       $24
         COUNTY_NAME                      $30
         SSA_CODE                         $5
         PARTIAL_FLAG                     $1
         REGION_CODE                      $2
         REGION_NAME                      $120;
 
  format CONTRACT_ID                      $5.
         PLAN_ID                          $3.
         SEGMENT_ID                       $3.
         STATE_NAME                       $24.
         COUNTY_NAME                      $30.
         SSA_CODE                         $5.
         PARTIAL_FLAG                     $1.
         REGION_CODE                      $2.
         REGION_NAME                      $120.;
 
  label  CONTRACT_ID                      = "Contract ID"
         PLAN_ID                          = "Plan ID"
         SEGMENT_ID                       = "Segment ID"
         STATE_NAME                       = "State Name"
         COUNTY_NAME                      = "County Name"
         SSA_CODE                         = "SSA State Code + County Code"
         PARTIAL_FLAG                     = "Partial County Indicator"
         REGION_CODE                      = "Region Code"
         REGION_NAME                      = "Region Name";
 
  infile in missover truncover;
 
  input @001   CONTRACT_ID                      $5.
        @006   PLAN_ID                          $3.
        @009   SEGMENT_ID                       $3.
        @012   STATE_NAME                       $24.
        @036   COUNTY_NAME                      $30.
        @066   SSA_CODE                         $5.
        @071   PARTIAL_FLAG                     $1.
        @072   REGION_CODE                      $2.
        @074   REGION_NAME                      $120.;
run;
 
title 'SERVICE_AREA_2014';
proc contents data=ccw.SERVICE_AREA_2014 varnum;
proc print data=ccw.SERVICE_AREA_2014(obs=5);
  title2 'Sample Listing - First 5 Rows';
run;
proc means data=ccw.SERVICE_AREA_2014;
  title2 'Simple Means';
run;
 
proc freq data=ccw.SERVICE_AREA_2014;
  title2 'Freqs';
  table
    PARTIAL_FLAG                    
    REGION_CODE                     
        /missing;
run;
 
* End of Program *;
