* SAS Read-In Program
*
* Name: service_area_2015_readin.sas
*
* Purpose: Read-In the delimited flat file SERVICE_AREA_2015.
*
* Delimiter: Fixed Column
*
* Date: 09MAY18   Time: 13:57
*
* Help: cmsdata@gdit.com, 1-866-766-1915
*
*;

filename in  'service_area_2015.dat'  lrecl=32768;
libname  ccw '.';

data ccw.SERVICE_AREA_2015;
  length CONTRACT_ID                      $5
         PLAN_ID                          $3
         SEGMENT_ID                       $3
         PTCD_INDICATOR                   $1
         STATE_NAME                       $25
         COUNTY_NAME                      $35
         SSA_CODE                         $5
         PARTIAL_FLAG                     $1
         REGION_CODE                      $2
         REGION_NAME                      $150;

  format CONTRACT_ID                      $5.
         PLAN_ID                          $3.
         SEGMENT_ID                       $3.
         PTCD_INDICATOR                   $1.
         STATE_NAME                       $25.
         COUNTY_NAME                      $35.
         SSA_CODE                         $5.
         PARTIAL_FLAG                     $1.
         REGION_CODE                      $2.
         REGION_NAME                      $150.;

  label  CONTRACT_ID                      = "Contract ID"
         PLAN_ID                          = "Plan ID"
         SEGMENT_ID                       = "Segment ID"
         PTCD_INDICATOR                   = "Indicates Whether the Plan is Part C, Part D or Both"
         STATE_NAME                       = "State Name"
         COUNTY_NAME                      = "County Name"
         SSA_CODE                         = "SSA State Code + County Code"
         PARTIAL_FLAG                     = "Partial County Indicator"
         REGION_CODE                      = "Region Code"
         REGION_NAME                      = "Region Name";

  infile in missover truncover;

  input @001   CONTRACT_ID                      $5.
        @006   PLAN_ID                          $3.
        @009   SEGMENT_ID                       $3.
        @012   PTCD_INDICATOR                   $1.
        @013   STATE_NAME                       $25.
        @038   COUNTY_NAME                      $35.
        @073   SSA_CODE                         $5.
        @078   PARTIAL_FLAG                     $1.
        @079   REGION_CODE                      $2.
        @081   REGION_NAME                      $150.;
run;

title 'SERVICE_AREA_2015';
proc contents data=ccw.SERVICE_AREA_2015 varnum;
proc print data=ccw.SERVICE_AREA_2015(obs=5);
  title2 'Sample Listing - First 5 Rows';
run;
proc means data=ccw.SERVICE_AREA_2015;
  title2 'Simple Means';
run;

proc freq data=ccw.SERVICE_AREA_2015;
  title2 'Freqs';
  table
    PARTIAL_FLAG
    PTCD_INDICATOR
    REGION_CODE
        /missing;
run;

* End of Program *;
