* SAS Read-In Program
*
* Name: tier_2007_readin.sas
*
* Purpose: Read-In the delimited flat file TIER_2007.
*
* Delimiter: Fixed Column
*
* Date: 26DEC14   Time: 23:30
*
* Programmer: Adam Hendricks, Adam.Hendricks@gdit.com, 515-645-3015
*
*;

%let dirpath = .; * <--  Directory Path for Input Flat File in FILENAME Statement *;

filename in  "%trim(&dirpath)/tier_2007.dat" lrecl=1277;

libname  out '.'; * <--  Directory Path for Output Library in LIBNAME Statement   *;

* Start *;
data out.TIER_2007;
  length CONTRACT_ID                      $5
         PLAN_ID                          $3
         TIER_ID                          $2
         GAP_TIER                         $1
         SPECIALTY_TIER                   $3
         PRE_ICL_TIER_DRUG_TYPE           $6
         PRE_ICL_COSTSHARE_TYPE           $1
         PRE_ICL_INP_COINS_1M             8
         PRE_ICL_INP_COINS_3M             8
         PRE_ICL_INP_COINS_OS             8
         PRE_ICL_INPP_COINS_1M            8
         PRE_ICL_INPP_COINS_3M            8
         PRE_ICL_INPP_COINS_OS            8
         PRE_ICL_INNPP_COINS_1M           8
         PRE_ICL_INNPP_COINS_3M           8
         PRE_ICL_INNPP_COINS_OS           8
         PRE_ICL_OONP_COINS_1M            8
         PRE_ICL_OONP_COINS_3M            8
         PRE_ICL_OONP_COINS_OS            8
         PRE_ICL_MO_COINS_1M              8
         PRE_ICL_MO_COINS_3M              8
         PRE_ICL_MO_COINS_OS              8
         PRE_ICL_MOPP_COINS_1M            8
         PRE_ICL_MOPP_COINS_3M            8
         PRE_ICL_MOPP_COINS_OS            8
         PRE_ICL_MONPP_COINS_1M           8
         PRE_ICL_MONPP_COINS_3M           8
         PRE_ICL_MONPP_COINS_OS           8
         PRE_ICL_INP_COPAY_1M             8
         PRE_ICL_INP_COPAY_3M             8
         PRE_ICL_INP_COPAY_OS             8
         PRE_ICL_INPP_COPAY_1M            8
         PRE_ICL_INPP_COPAY_3M            8
         PRE_ICL_INPP_COPAY_OS            8
         PRE_ICL_INNPP_COPAY_1M           8
         PRE_ICL_INNPP_COPAY_3M           8
         PRE_ICL_INNPP_COPAY_OS           8
         PRE_ICL_OONP_COPAY_1M            8
         PRE_ICL_OONP_COPAY_3M            8
         PRE_ICL_OONP_COPAY_OS            8
         PRE_ICL_MO_COPAY_1M              8
         PRE_ICL_MO_COPAY_3M              8
         PRE_ICL_MO_COPAY_OS              8
         PRE_ICL_MOPP_COPAY_1M            8
         PRE_ICL_MOPP_COPAY_3M            8
         PRE_ICL_MOPP_COPAY_OS            8
         PRE_ICL_MONPP_COPAY_1M           8
         PRE_ICL_MONPP_COPAY_3M           8
         PRE_ICL_MONPP_COPAY_OS           8
         PRE_ICL_DAYS_INP_1M              8
         PRE_ICL_DAYS_INP_3M              8
         PRE_ICL_DAYS_INP_OS              8
         PRE_ICL_DAYS_INPP_1M             8
         PRE_ICL_DAYS_INPP_3M             8
         PRE_ICL_DAYS_INPP_OS             8
         PRE_ICL_DAYS_INNPP_1M            8
         PRE_ICL_DAYS_INNPP_3M            8
         PRE_ICL_DAYS_INNPP_OS            8
         PRE_ICL_DAYS_OONP_1M             8
         PRE_ICL_DAYS_OONP_3M             8
         PRE_ICL_DAYS_OONP_OS             8
         PRE_ICL_DAYS_MO_1M               8
         PRE_ICL_DAYS_MO_3M               8
         PRE_ICL_DAYS_MO_OS               8
         PRE_ICL_DAYS_MOPP_1M             8
         PRE_ICL_DAYS_MOPP_3M             8
         PRE_ICL_DAYS_MOPP_OS             8
         PRE_ICL_DAYS_MONPP_1M            8
         PRE_ICL_DAYS_MONPP_3M            8
         PRE_ICL_DAYS_MONPP_OS            8
         GAP_TIER_DRUG_TYPE               $6
         GAP_COSTSHARE_TYPE               $1
         GAP_INP_COINS_1M                 8
         GAP_INP_COINS_3M                 8
         GAP_INP_COINS_OS                 8
         GAP_INPP_COINS_1M                8
         GAP_INPP_COINS_3M                8
         GAP_INPP_COINS_OS                8
         GAP_INNPP_COINS_1M               8
         GAP_INNPP_COINS_3M               8
         GAP_INNPP_COINS_OS               8
         GAP_OONP_COINS_1M                8
         GAP_OONP_COINS_3M                8
         GAP_OONP_COINS_OS                8
         GAP_MO_COINS_1M                  8
         GAP_MO_COINS_3M                  8
         GAP_MO_COINS_OS                  8
         GAP_MOPP_COINS_1M                8
         GAP_MOPP_COINS_3M                8
         GAP_MOPP_COINS_OS                8
         GAP_MONPP_COINS_1M               8
         GAP_MONPP_COINS_3M               8
         GAP_MONPP_COINS_OS               8
         GAP_INP_COPAY_1M                 8
         GAP_INP_COPAY_3M                 8
         GAP_INP_COPAY_OS                 8
         GAP_INPP_COPAY_1M                8
         GAP_INPP_COPAY_3M                8
         GAP_INPP_COPAY_OS                8
         GAP_INNPP_COPAY_1M               8
         GAP_INNPP_COPAY_3M               8
         GAP_INNPP_COPAY_OS               8
         GAP_OONP_COPAY_1M                8
         GAP_OONP_COPAY_3M                8
         GAP_OONP_COPAY_OS                8
         GAP_MO_COPAY_1M                  8
         GAP_MO_COPAY_3M                  8
         GAP_MO_COPAY_OS                  8
         GAP_MOPP_COPAY_1M                8
         GAP_MOPP_COPAY_3M                8
         GAP_MOPP_COPAY_OS                8
         GAP_MONPP_COPAY_1M               8
         GAP_MONPP_COPAY_3M               8
         GAP_MONPP_COPAY_OS               8
         GAP_DAYS_INP_1M                  8
         GAP_DAYS_INP_3M                  8
         GAP_DAYS_INP_OS                  8
         GAP_DAYS_INPP_1M                 8
         GAP_DAYS_INPP_3M                 8
         GAP_DAYS_INPP_OS                 8
         GAP_DAYS_INNPP_1M                8
         GAP_DAYS_INNPP_3M                8
         GAP_DAYS_INNPP_OS                8
         GAP_DAYS_OONP_1M                 8
         GAP_DAYS_OONP_3M                 8
         GAP_DAYS_OONP_OS                 8
         GAP_DAYS_MO_1M                   8
         GAP_DAYS_MO_3M                   8
         GAP_DAYS_MO_OS                   8
         GAP_DAYS_MOPP_1M                 8
         GAP_DAYS_MOPP_3M                 8
         GAP_DAYS_MOPP_OS                 8
         GAP_DAYS_MONPP_1M                8
         GAP_DAYS_MONPP_3M                8
         GAP_DAYS_MONPP_OS                8
         POST_OOPT_TIER_DRUG_TYPE         $6
         POST_OOPT_COSTSHARE_TYPE         $1
         POST_OOPT_COINS_PCT              8
         POST_OOPT_COPAY_AMT              8;

  format CONTRACT_ID                      $5.
         PLAN_ID                          $3.
         TIER_ID                          $2.
         GAP_TIER                         $1.
         SPECIALTY_TIER                   $3.
         PRE_ICL_TIER_DRUG_TYPE           $6.
         PRE_ICL_COSTSHARE_TYPE           $1.
         PRE_ICL_INP_COINS_1M             12.2
         PRE_ICL_INP_COINS_3M             12.2
         PRE_ICL_INP_COINS_OS             12.2
         PRE_ICL_INPP_COINS_1M            12.2
         PRE_ICL_INPP_COINS_3M            12.2
         PRE_ICL_INPP_COINS_OS            12.2
         PRE_ICL_INNPP_COINS_1M           12.2
         PRE_ICL_INNPP_COINS_3M           12.2
         PRE_ICL_INNPP_COINS_OS           12.2
         PRE_ICL_OONP_COINS_1M            12.2
         PRE_ICL_OONP_COINS_3M            12.2
         PRE_ICL_OONP_COINS_OS            12.2
         PRE_ICL_MO_COINS_1M              12.2
         PRE_ICL_MO_COINS_3M              12.2
         PRE_ICL_MO_COINS_OS              12.2
         PRE_ICL_MOPP_COINS_1M            12.2
         PRE_ICL_MOPP_COINS_3M            12.2
         PRE_ICL_MOPP_COINS_OS            12.2
         PRE_ICL_MONPP_COINS_1M           12.2
         PRE_ICL_MONPP_COINS_3M           12.2
         PRE_ICL_MONPP_COINS_OS           12.2
         PRE_ICL_INP_COPAY_1M             12.2
         PRE_ICL_INP_COPAY_3M             12.2
         PRE_ICL_INP_COPAY_OS             12.2
         PRE_ICL_INPP_COPAY_1M            12.2
         PRE_ICL_INPP_COPAY_3M            12.2
         PRE_ICL_INPP_COPAY_OS            12.2
         PRE_ICL_INNPP_COPAY_1M           12.2
         PRE_ICL_INNPP_COPAY_3M           12.2
         PRE_ICL_INNPP_COPAY_OS           12.2
         PRE_ICL_OONP_COPAY_1M            12.2
         PRE_ICL_OONP_COPAY_3M            12.2
         PRE_ICL_OONP_COPAY_OS            12.2
         PRE_ICL_MO_COPAY_1M              12.2
         PRE_ICL_MO_COPAY_3M              12.2
         PRE_ICL_MO_COPAY_OS              12.2
         PRE_ICL_MOPP_COPAY_1M            12.2
         PRE_ICL_MOPP_COPAY_3M            12.2
         PRE_ICL_MOPP_COPAY_OS            12.2
         PRE_ICL_MONPP_COPAY_1M           12.2
         PRE_ICL_MONPP_COPAY_3M           12.2
         PRE_ICL_MONPP_COPAY_OS           12.2
         PRE_ICL_DAYS_INP_1M              5.
         PRE_ICL_DAYS_INP_3M              5.
         PRE_ICL_DAYS_INP_OS              5.
         PRE_ICL_DAYS_INPP_1M             5.
         PRE_ICL_DAYS_INPP_3M             5.
         PRE_ICL_DAYS_INPP_OS             5.
         PRE_ICL_DAYS_INNPP_1M            5.
         PRE_ICL_DAYS_INNPP_3M            5.
         PRE_ICL_DAYS_INNPP_OS            5.
         PRE_ICL_DAYS_OONP_1M             5.
         PRE_ICL_DAYS_OONP_3M             5.
         PRE_ICL_DAYS_OONP_OS             5.
         PRE_ICL_DAYS_MO_1M               5.
         PRE_ICL_DAYS_MO_3M               5.
         PRE_ICL_DAYS_MO_OS               5.
         PRE_ICL_DAYS_MOPP_1M             5.
         PRE_ICL_DAYS_MOPP_3M             5.
         PRE_ICL_DAYS_MOPP_OS             5.
         PRE_ICL_DAYS_MONPP_1M            5.
         PRE_ICL_DAYS_MONPP_3M            5.
         PRE_ICL_DAYS_MONPP_OS            5.
         GAP_TIER_DRUG_TYPE               $6.
         GAP_COSTSHARE_TYPE               $1.
         GAP_INP_COINS_1M                 12.2
         GAP_INP_COINS_3M                 12.2
         GAP_INP_COINS_OS                 12.2
         GAP_INPP_COINS_1M                12.2
         GAP_INPP_COINS_3M                12.2
         GAP_INPP_COINS_OS                12.2
         GAP_INNPP_COINS_1M               12.2
         GAP_INNPP_COINS_3M               12.2
         GAP_INNPP_COINS_OS               12.2
         GAP_OONP_COINS_1M                12.2
         GAP_OONP_COINS_3M                12.2
         GAP_OONP_COINS_OS                12.2
         GAP_MO_COINS_1M                  12.2
         GAP_MO_COINS_3M                  12.2
         GAP_MO_COINS_OS                  12.2
         GAP_MOPP_COINS_1M                12.2
         GAP_MOPP_COINS_3M                12.2
         GAP_MOPP_COINS_OS                12.2
         GAP_MONPP_COINS_1M               12.2
         GAP_MONPP_COINS_3M               12.2
         GAP_MONPP_COINS_OS               12.2
         GAP_INP_COPAY_1M                 12.2
         GAP_INP_COPAY_3M                 12.2
         GAP_INP_COPAY_OS                 12.2
         GAP_INPP_COPAY_1M                12.2
         GAP_INPP_COPAY_3M                12.2
         GAP_INPP_COPAY_OS                12.2
         GAP_INNPP_COPAY_1M               12.2
         GAP_INNPP_COPAY_3M               12.2
         GAP_INNPP_COPAY_OS               12.2
         GAP_OONP_COPAY_1M                12.2
         GAP_OONP_COPAY_3M                12.2
         GAP_OONP_COPAY_OS                12.2
         GAP_MO_COPAY_1M                  12.2
         GAP_MO_COPAY_3M                  12.2
         GAP_MO_COPAY_OS                  12.2
         GAP_MOPP_COPAY_1M                12.2
         GAP_MOPP_COPAY_3M                12.2
         GAP_MOPP_COPAY_OS                12.2
         GAP_MONPP_COPAY_1M               12.2
         GAP_MONPP_COPAY_3M               12.2
         GAP_MONPP_COPAY_OS               12.2
         GAP_DAYS_INP_1M                  5.
         GAP_DAYS_INP_3M                  5.
         GAP_DAYS_INP_OS                  5.
         GAP_DAYS_INPP_1M                 5.
         GAP_DAYS_INPP_3M                 5.
         GAP_DAYS_INPP_OS                 5.
         GAP_DAYS_INNPP_1M                5.
         GAP_DAYS_INNPP_3M                5.
         GAP_DAYS_INNPP_OS                5.
         GAP_DAYS_OONP_1M                 5.
         GAP_DAYS_OONP_3M                 5.
         GAP_DAYS_OONP_OS                 5.
         GAP_DAYS_MO_1M                   5.
         GAP_DAYS_MO_3M                   5.
         GAP_DAYS_MO_OS                   5.
         GAP_DAYS_MOPP_1M                 5.
         GAP_DAYS_MOPP_3M                 5.
         GAP_DAYS_MOPP_OS                 5.
         GAP_DAYS_MONPP_1M                5.
         GAP_DAYS_MONPP_3M                5.
         GAP_DAYS_MONPP_OS                5.
         POST_OOPT_TIER_DRUG_TYPE         $6.
         POST_OOPT_COSTSHARE_TYPE         $1.
         POST_OOPT_COINS_PCT              12.2
         POST_OOPT_COPAY_AMT              12.2;

  label  CONTRACT_ID                      = "Contract ID"
         PLAN_ID                          = "Plan ID"
         TIER_ID                          = "Tier Number"
         GAP_TIER                         = "Indicates whether tier is covered in the gap"
         SPECIALTY_TIER                   = "Indicates whether tier is a specialty tier"
         PRE_ICL_TIER_DRUG_TYPE           = "Pre-ICL Tier Drug Type"
         PRE_ICL_COSTSHARE_TYPE           = "Pre-ICL Costshare Type"
         PRE_ICL_INP_COINS_1M             = "Pre-ICL Coinsurance In-Network Pharmacy - one month supply"
         PRE_ICL_INP_COINS_3M             = "Pre-ICL Coinsurance In-Network Pharmacy - three month supply"
         PRE_ICL_INP_COINS_OS             = "Pre-ICL Coinsurance In-Network Pharmacy - other day supply"
         PRE_ICL_INPP_COINS_1M            = "Pre-ICL Coinsurance In-Network Preferred Pharmacy - one month supply"
         PRE_ICL_INPP_COINS_3M            = "Pre-ICL Coinsurance In-Network Preferred Pharmacy - three month supply"
         PRE_ICL_INPP_COINS_OS            = "Pre-ICL Coinsurance In-Network Preferred Pharmacy - other day supply"
         PRE_ICL_INNPP_COINS_1M           = "Pre-ICL Coinsurance In-Network Non-Preferred Pharmacy - one month supply"
         PRE_ICL_INNPP_COINS_3M           = "Pre-ICL Coinsurance In-Network Non-Preferred Pharmacy - three month supply"
         PRE_ICL_INNPP_COINS_OS           = "Pre-ICL Coinsurance In-Network Non-Preferred Pharmacy - other day supply"
         PRE_ICL_OONP_COINS_1M            = "Pre-ICL Coinsurance Out-of-Network Pharmacy - one month supply"
         PRE_ICL_OONP_COINS_3M            = "Pre-ICL Coinsurance Out-of-Network Pharmacy - three month supply"
         PRE_ICL_OONP_COINS_OS            = "Pre-ICL Coinsurance Out-of-Network Pharmacy - other day supply"
         PRE_ICL_MO_COINS_1M              = "Pre-ICL Coinsurance Mail Order Pharmacy - one month supply"
         PRE_ICL_MO_COINS_3M              = "Pre-ICL Coinsurance Mail Order Pharmacy - three month supply"
         PRE_ICL_MO_COINS_OS              = "Pre-ICL Coinsurance Mail Order Pharmacy - other day supply"
         PRE_ICL_MOPP_COINS_1M            = "Pre-ICL Coinsurance Mail Order Preferred Pharmacy - one month supply"
         PRE_ICL_MOPP_COINS_3M            = "Pre-ICL Coinsurance Mail Order Preferred Pharmacy - three month supply"
         PRE_ICL_MOPP_COINS_OS            = "Pre-ICL Coinsurance Mail Order Preferred Pharmacy - other day supply"
         PRE_ICL_MONPP_COINS_1M           = "Pre-ICL Coinsurance Mail Order Non-Preferred Pharmacy - one month supply"
         PRE_ICL_MONPP_COINS_3M           = "Pre-ICL Coinsurance Mail Order Non-Preferred Pharmacy - three month supply"
         PRE_ICL_MONPP_COINS_OS           = "Pre-ICL Coinsurance Mail Order Non-Preferred Pharmacy - other day supply"
         PRE_ICL_INP_COPAY_1M             = "Pre-ICL Copay In-Network Pharmacy - one month supply"
         PRE_ICL_INP_COPAY_3M             = "Pre-ICL Copay In-Network Pharmacy - three month supply"
         PRE_ICL_INP_COPAY_OS             = "Pre-ICL Copay In-Network Pharmacy - other day supply"
         PRE_ICL_INPP_COPAY_1M            = "Pre-ICL Copay In-Network Preferred Pharmacy - one month supply"
         PRE_ICL_INPP_COPAY_3M            = "Pre-ICL Copay In-Network Preferred Pharmacy - three month supply"
         PRE_ICL_INPP_COPAY_OS            = "Pre-ICL Copay In-Network Preferred Pharmacy - other day supply"
         PRE_ICL_INNPP_COPAY_1M           = "Pre-ICL Copay In-Network Non-Preferred Pharmacy - one month supply"
         PRE_ICL_INNPP_COPAY_3M           = "Pre-ICL Copay In-Network Non-Preferred Pharmacy - three month supply"
         PRE_ICL_INNPP_COPAY_OS           = "Pre-ICL Copay In-Network Non-Preferred Pharmacy - other day supply"
         PRE_ICL_OONP_COPAY_1M            = "Pre-ICL Copay Out-of-Network Pharmacy - one month supply"
         PRE_ICL_OONP_COPAY_3M            = "Pre-ICL Copay Out-of-Network Pharmacy - three month supply"
         PRE_ICL_OONP_COPAY_OS            = "Pre-ICL Copay Out-of-Network Pharmacy - other day supply"
         PRE_ICL_MO_COPAY_1M              = "Pre-ICL Copay Mail Order Pharmacy - one month supply"
         PRE_ICL_MO_COPAY_3M              = "Pre-ICL Copay Mail Order Pharmacy - three month supply"
         PRE_ICL_MO_COPAY_OS              = "Pre-ICL Copay Mail Order Pharmacy - other day supply"
         PRE_ICL_MOPP_COPAY_1M            = "Pre-ICL Copay Mail Order Preferred Pharmacy - one month supply"
         PRE_ICL_MOPP_COPAY_3M            = "Pre-ICL Copay Mail Order Preferred Pharmacy - three month supply"
         PRE_ICL_MOPP_COPAY_OS            = "Pre-ICL Copay Mail Order Preferred Pharmacy - other day supply"
         PRE_ICL_MONPP_COPAY_1M           = "Pre-ICL Copay Mail Order Non-Preferred Pharmacy - one month supply"
         PRE_ICL_MONPP_COPAY_3M           = "Pre-ICL Copay Mail Order Non-Preferred Pharmacy - three month supply"
         PRE_ICL_MONPP_COPAY_OS           = "Pre-ICL Copay Mail Order Non-Preferred Pharmacy - other day supply"
         PRE_ICL_DAYS_INP_1M              = "Pre-ICL In-Network Pharmacy - number of days in one month supply"
         PRE_ICL_DAYS_INP_3M              = "Pre-ICL In-Network Pharmacy - number of days in three month supply"
         PRE_ICL_DAYS_INP_OS              = "Pre-ICL In-Network Pharmacy - number of days in other day supply"
         PRE_ICL_DAYS_INPP_1M             = "Pre-ICL In-Network Preferred Pharmacy - number of days in one month supply"
         PRE_ICL_DAYS_INPP_3M             = "Pre-ICL In-Network Preferred Pharmacy - number of days in three month supply"
         PRE_ICL_DAYS_INPP_OS             = "Pre-ICL In-Network Preferred Pharmacy - number of days in other day supply"
         PRE_ICL_DAYS_INNPP_1M            = "Pre-ICL In-Network Non-Preferred Pharmacy - number of days in one month supply"
         PRE_ICL_DAYS_INNPP_3M            = "Pre-ICL In-Network Non-Preferred Pharmacy - number of days in three month supply"
         PRE_ICL_DAYS_INNPP_OS            = "Pre-ICL In-Network Non-Preferred Pharmacy - number of days in other day supply"
         PRE_ICL_DAYS_OONP_1M             = "Pre-ICL Out-of-Network Pharmacy - number of days in one month supply"
         PRE_ICL_DAYS_OONP_3M             = "Pre-ICL Out-of-Network Pharmacy - number of days in three month supply"
         PRE_ICL_DAYS_OONP_OS             = "Pre-ICL Out-of-Network Pharmacy - number of days in other day supply"
         PRE_ICL_DAYS_MO_1M               = "Pre-ICL Mail Order Pharmacy - number of days in one month supply"
         PRE_ICL_DAYS_MO_3M               = "Pre-ICL Mail Order Pharmacy - number of days in three month supply"
         PRE_ICL_DAYS_MO_OS               = "Pre-ICL Mail Order Pharmacy - number of days in other day supply"
         PRE_ICL_DAYS_MOPP_1M             = "Pre-ICL Mail Order Preferred Pharmacy - number of days in one month supply"
         PRE_ICL_DAYS_MOPP_3M             = "Pre-ICL Mail Order Preferred Pharmacy - number of days in three month supply"
         PRE_ICL_DAYS_MOPP_OS             = "Pre-ICL Mail Order Preferred Pharmacy - number of days in other day supply"
         PRE_ICL_DAYS_MONPP_1M            = "Pre-ICL Mail Order Non-Preferred Pharmacy - number of days in one month supply"
         PRE_ICL_DAYS_MONPP_3M            = "Pre-ICL Mail Order Non-Preferred Pharmacy - number of days in three month supply"
         PRE_ICL_DAYS_MONPP_OS            = "Pre-ICL Mail Order Non-Preferred Pharmacy - number of days in other day supply"
         GAP_TIER_DRUG_TYPE               = "Gap Tier Drug Type"
         GAP_COSTSHARE_TYPE               = "Gap Cost Share Type"
         GAP_INP_COINS_1M                 = "Gap Coinsurance In-Network Pharmacy - one month supply"
         GAP_INP_COINS_3M                 = "Gap Coinsurance In-Network Pharmacy - three month supply"
         GAP_INP_COINS_OS                 = "Gap Coinsurance In-Network Pharmacy - other day supply"
         GAP_INPP_COINS_1M                = "Gap Coinsurance In-Network Preferred Pharmacy - one month supply"
         GAP_INPP_COINS_3M                = "Gap Coinsurance In-Network Preferred Pharmacy - three month supply"
         GAP_INPP_COINS_OS                = "Gap Coinsurance In-Network Preferred Pharmacy - other day supply"
         GAP_INNPP_COINS_1M               = "Gap Coinsurance In-Network Non-Preferred Pharmacy - one month supply"
         GAP_INNPP_COINS_3M               = "Gap Coinsurance In-Network Non-Preferred Pharmacy - three month supply"
         GAP_INNPP_COINS_OS               = "Gap Coinsurance In-Network Non-Preferred Pharmacy - other day supply"
         GAP_OONP_COINS_1M                = "Gap Coinsurance Out-of-Network Pharmacy - one month supply"
         GAP_OONP_COINS_3M                = "Gap Coinsurance Out-of-Network Pharmacy - three month supply"
         GAP_OONP_COINS_OS                = "Gap Coinsurance Out-of-Network Pharmacy - other day supply"
         GAP_MO_COINS_1M                  = "Gap Coinsurance Mail Order Pharmacy - one month supply"
         GAP_MO_COINS_3M                  = "Gap Coinsurance Mail Order Pharmacy - three month supply"
         GAP_MO_COINS_OS                  = "Gap Coinsurance Mail Order Pharmacy - other day supply"
         GAP_MOPP_COINS_1M                = "Gap Coinsurance Mail Order Preferred Pharmacy - one month supply"
         GAP_MOPP_COINS_3M                = "Gap Coinsurance Mail Order Preferred Pharmacy - three month supply"
         GAP_MOPP_COINS_OS                = "Gap Coinsurance Mail Order Preferred Pharmacy - other day supply"
         GAP_MONPP_COINS_1M               = "Gap Coinsurance Mail Order Non-Preferred Pharmacy - one month supply"
         GAP_MONPP_COINS_3M               = "Gap Coinsurance Mail Order Non-Preferred Pharmacy - three month supply"
         GAP_MONPP_COINS_OS               = "Gap Coinsurance Mail Order Non-Preferred Pharmacy - other day supply"
         GAP_INP_COPAY_1M                 = "Gap Copay In-Network Pharmacy - one month supply"
         GAP_INP_COPAY_3M                 = "Gap Copay In-Network Pharmacy - three month supply"
         GAP_INP_COPAY_OS                 = "Gap Copay In-Network Pharmacy - other day supply"
         GAP_INPP_COPAY_1M                = "Gap Copay In-Network Preferred Pharmacy - one month supply"
         GAP_INPP_COPAY_3M                = "Gap Copay In-Network Preferred Pharmacy - three month supply"
         GAP_INPP_COPAY_OS                = "Gap Copay In-Network Preferred Pharmacy - other day supply"
         GAP_INNPP_COPAY_1M               = "Gap Copay In-Network Non-Preferred Pharmacy - one month supply"
         GAP_INNPP_COPAY_3M               = "Gap Copay In-Network Non-Preferred Pharmacy - three month supply"
         GAP_INNPP_COPAY_OS               = "Gap Copay In-Network Non-Preferred Pharmacy - other day supply"
         GAP_OONP_COPAY_1M                = "Gap Copay Out-of-Network Pharmacy - one month supply"
         GAP_OONP_COPAY_3M                = "Gap Copay Out-of-Network Pharmacy - three month supply"
         GAP_OONP_COPAY_OS                = "Gap Copay Out-of-Network Pharmacy - other day supply"
         GAP_MO_COPAY_1M                  = "Gap Copay Mail Order Pharmacy - one month supply"
         GAP_MO_COPAY_3M                  = "Gap Copay Mail Order Pharmacy - three month supply"
         GAP_MO_COPAY_OS                  = "Gap Copay Mail Order Pharmacy - other day supply"
         GAP_MOPP_COPAY_1M                = "Gap Copay Mail Order Preferred Pharmacy - one month supply"
         GAP_MOPP_COPAY_3M                = "Gap Copay Mail Order Preferred Pharmacy - three month supply"
         GAP_MOPP_COPAY_OS                = "Gap Copay Mail Order Preferred Pharmacy - other day supply"
         GAP_MONPP_COPAY_1M               = "Gap Copay Mail Order Non-Preferred Pharmacy - one month supply"
         GAP_MONPP_COPAY_3M               = "Gap Copay Mail Order Non-Preferred Pharmacy - three month supply"
         GAP_MONPP_COPAY_OS               = "Gap Copay Mail Order Non-Preferred Pharmacy - other day supply"
         GAP_DAYS_INP_1M                  = "Gap In-Network Pharmacy - number of days in one month supply"
         GAP_DAYS_INP_3M                  = "Gap In-Network Pharmacy - number of days in three month supply"
         GAP_DAYS_INP_OS                  = "Gap In-Network Pharmacy - number of days in other day supply"
         GAP_DAYS_INPP_1M                 = "Gap In-Network Preferred Pharmacy - number of days in one month supply"
         GAP_DAYS_INPP_3M                 = "Gap In-Network Preferred Pharmacy - number of days in three month supply"
         GAP_DAYS_INPP_OS                 = "Gap In-Network Preferred Pharmacy - number of days in other day supply"
         GAP_DAYS_INNPP_1M                = "Gap In-Network Non-Preferred Pharmacy - number of days in one month supply"
         GAP_DAYS_INNPP_3M                = "Gap In-Network Non-Preferred Pharmacy - number of days in three month supply"
         GAP_DAYS_INNPP_OS                = "Gap In-Network Non-Preferred Pharmacy - number of days in other day supply"
         GAP_DAYS_OONP_1M                 = "Gap Out-of-Network Pharmacy - number of days in one month supply"
         GAP_DAYS_OONP_3M                 = "Gap Out-of-Network Pharmacy - number of days in three month supply"
         GAP_DAYS_OONP_OS                 = "Gap Out-of-Network Pharmacy - number of days in other day supply"
         GAP_DAYS_MO_1M                   = "Gap Mail Order Pharmacy - number of days in one month supply"
         GAP_DAYS_MO_3M                   = "Gap Mail Order Pharmacy - number of days in three month supply"
         GAP_DAYS_MO_OS                   = "Gap Mail Order Pharmacy - number of days in other day supply"
         GAP_DAYS_MOPP_1M                 = "Gap Mail Order Preferred Pharmacy - number of days in one month supply"
         GAP_DAYS_MOPP_3M                 = "Gap Mail Order Preferred Pharmacy - number of days in three month supply"
         GAP_DAYS_MOPP_OS                 = "Gap Mail Order Preferred Pharmacy - number of days in other day supply"
         GAP_DAYS_MONPP_1M                = "Gap Mail Order Non-Preferred Pharmacy - number of days in one month supply"
         GAP_DAYS_MONPP_3M                = "Gap Mail Order Non-Preferred Pharmacy - number of days in three month supply"
         GAP_DAYS_MONPP_OS                = "Gap Mail Order Non-Preferred Pharmacy - number of days in other day supply"
         POST_OOPT_TIER_DRUG_TYPE         = "Post-Out-of-pocket threshold tier drug type"
         POST_OOPT_COSTSHARE_TYPE         = "Post-Out-of-pocket threshold costshare type"
         POST_OOPT_COINS_PCT              = "Post-Out-of-pocket threshold Coinsurance"
         POST_OOPT_COPAY_AMT              = "Post-Out-of-pocket threshold Copay";

  infile in missover truncover;

  input @0001  CONTRACT_ID                      $5.
        @0006  PLAN_ID                          $3.
        @0009  TIER_ID                          $2.
        @0011  GAP_TIER                         $1.
        @0012  SPECIALTY_TIER                   $3.
        @0015  PRE_ICL_TIER_DRUG_TYPE           $6.
        @0021  PRE_ICL_COSTSHARE_TYPE           $1.
        @0022  PRE_ICL_INP_COINS_1M             12.2
        @0034  PRE_ICL_INP_COINS_3M             12.2
        @0046  PRE_ICL_INP_COINS_OS             12.2
        @0058  PRE_ICL_INPP_COINS_1M            12.2
        @0070  PRE_ICL_INPP_COINS_3M            12.2
        @0082  PRE_ICL_INPP_COINS_OS            12.2
        @0094  PRE_ICL_INNPP_COINS_1M           12.2
        @0106  PRE_ICL_INNPP_COINS_3M           12.2
        @0118  PRE_ICL_INNPP_COINS_OS           12.2
        @0130  PRE_ICL_OONP_COINS_1M            12.2
        @0142  PRE_ICL_OONP_COINS_3M            12.2
        @0154  PRE_ICL_OONP_COINS_OS            12.2
        @0166  PRE_ICL_MO_COINS_1M              12.2
        @0178  PRE_ICL_MO_COINS_3M              12.2
        @0190  PRE_ICL_MO_COINS_OS              12.2
        @0202  PRE_ICL_MOPP_COINS_1M            12.2
        @0214  PRE_ICL_MOPP_COINS_3M            12.2
        @0226  PRE_ICL_MOPP_COINS_OS            12.2
        @0238  PRE_ICL_MONPP_COINS_1M           12.2
        @0250  PRE_ICL_MONPP_COINS_3M           12.2
        @0262  PRE_ICL_MONPP_COINS_OS           12.2
        @0274  PRE_ICL_INP_COPAY_1M             12.2
        @0286  PRE_ICL_INP_COPAY_3M             12.2
        @0298  PRE_ICL_INP_COPAY_OS             12.2
        @0310  PRE_ICL_INPP_COPAY_1M            12.2
        @0322  PRE_ICL_INPP_COPAY_3M            12.2
        @0334  PRE_ICL_INPP_COPAY_OS            12.2
        @0346  PRE_ICL_INNPP_COPAY_1M           12.2
        @0358  PRE_ICL_INNPP_COPAY_3M           12.2
        @0370  PRE_ICL_INNPP_COPAY_OS           12.2
        @0382  PRE_ICL_OONP_COPAY_1M            12.2
        @0394  PRE_ICL_OONP_COPAY_3M            12.2
        @0406  PRE_ICL_OONP_COPAY_OS            12.2
        @0418  PRE_ICL_MO_COPAY_1M              12.2
        @0430  PRE_ICL_MO_COPAY_3M              12.2
        @0442  PRE_ICL_MO_COPAY_OS              12.2
        @0454  PRE_ICL_MOPP_COPAY_1M            12.2
        @0466  PRE_ICL_MOPP_COPAY_3M            12.2
        @0478  PRE_ICL_MOPP_COPAY_OS            12.2
        @0490  PRE_ICL_MONPP_COPAY_1M           12.2
        @0502  PRE_ICL_MONPP_COPAY_3M           12.2
        @0514  PRE_ICL_MONPP_COPAY_OS           12.2
        @0526  PRE_ICL_DAYS_INP_1M              5.
        @0531  PRE_ICL_DAYS_INP_3M              5.
        @0536  PRE_ICL_DAYS_INP_OS              5.
        @0541  PRE_ICL_DAYS_INPP_1M             5.
        @0546  PRE_ICL_DAYS_INPP_3M             5.
        @0551  PRE_ICL_DAYS_INPP_OS             5.
        @0556  PRE_ICL_DAYS_INNPP_1M            5.
        @0561  PRE_ICL_DAYS_INNPP_3M            5.
        @0566  PRE_ICL_DAYS_INNPP_OS            5.
        @0571  PRE_ICL_DAYS_OONP_1M             5.
        @0576  PRE_ICL_DAYS_OONP_3M             5.
        @0581  PRE_ICL_DAYS_OONP_OS             5.
        @0586  PRE_ICL_DAYS_MO_1M               5.
        @0591  PRE_ICL_DAYS_MO_3M               5.
        @0596  PRE_ICL_DAYS_MO_OS               5.
        @0601  PRE_ICL_DAYS_MOPP_1M             5.
        @0606  PRE_ICL_DAYS_MOPP_3M             5.
        @0611  PRE_ICL_DAYS_MOPP_OS             5.
        @0616  PRE_ICL_DAYS_MONPP_1M            5.
        @0621  PRE_ICL_DAYS_MONPP_3M            5.
        @0626  PRE_ICL_DAYS_MONPP_OS            5.
        @0631  GAP_TIER_DRUG_TYPE               $6.
        @0637  GAP_COSTSHARE_TYPE               $1.
        @0638  GAP_INP_COINS_1M                 12.2
        @0650  GAP_INP_COINS_3M                 12.2
        @0662  GAP_INP_COINS_OS                 12.2
        @0674  GAP_INPP_COINS_1M                12.2
        @0686  GAP_INPP_COINS_3M                12.2
        @0698  GAP_INPP_COINS_OS                12.2
        @0710  GAP_INNPP_COINS_1M               12.2
        @0722  GAP_INNPP_COINS_3M               12.2
        @0734  GAP_INNPP_COINS_OS               12.2
        @0746  GAP_OONP_COINS_1M                12.2
        @0758  GAP_OONP_COINS_3M                12.2
        @0770  GAP_OONP_COINS_OS                12.2
        @0782  GAP_MO_COINS_1M                  12.2
        @0794  GAP_MO_COINS_3M                  12.2
        @0806  GAP_MO_COINS_OS                  12.2
        @0818  GAP_MOPP_COINS_1M                12.2
        @0830  GAP_MOPP_COINS_3M                12.2
        @0842  GAP_MOPP_COINS_OS                12.2
        @0854  GAP_MONPP_COINS_1M               12.2
        @0866  GAP_MONPP_COINS_3M               12.2
        @0878  GAP_MONPP_COINS_OS               12.2
        @0890  GAP_INP_COPAY_1M                 12.2
        @0902  GAP_INP_COPAY_3M                 12.2
        @0914  GAP_INP_COPAY_OS                 12.2
        @0926  GAP_INPP_COPAY_1M                12.2
        @0938  GAP_INPP_COPAY_3M                12.2
        @0950  GAP_INPP_COPAY_OS                12.2
        @0962  GAP_INNPP_COPAY_1M               12.2
        @0974  GAP_INNPP_COPAY_3M               12.2
        @0986  GAP_INNPP_COPAY_OS               12.2
        @0998  GAP_OONP_COPAY_1M                12.2
        @1010  GAP_OONP_COPAY_3M                12.2
        @1022  GAP_OONP_COPAY_OS                12.2
        @1034  GAP_MO_COPAY_1M                  12.2
        @1046  GAP_MO_COPAY_3M                  12.2
        @1058  GAP_MO_COPAY_OS                  12.2
        @1070  GAP_MOPP_COPAY_1M                12.2
        @1082  GAP_MOPP_COPAY_3M                12.2
        @1094  GAP_MOPP_COPAY_OS                12.2
        @1106  GAP_MONPP_COPAY_1M               12.2
        @1118  GAP_MONPP_COPAY_3M               12.2
        @1130  GAP_MONPP_COPAY_OS               12.2
        @1142  GAP_DAYS_INP_1M                  5.
        @1147  GAP_DAYS_INP_3M                  5.
        @1152  GAP_DAYS_INP_OS                  5.
        @1157  GAP_DAYS_INPP_1M                 5.
        @1162  GAP_DAYS_INPP_3M                 5.
        @1167  GAP_DAYS_INPP_OS                 5.
        @1172  GAP_DAYS_INNPP_1M                5.
        @1177  GAP_DAYS_INNPP_3M                5.
        @1182  GAP_DAYS_INNPP_OS                5.
        @1187  GAP_DAYS_OONP_1M                 5.
        @1192  GAP_DAYS_OONP_3M                 5.
        @1197  GAP_DAYS_OONP_OS                 5.
        @1202  GAP_DAYS_MO_1M                   5.
        @1207  GAP_DAYS_MO_3M                   5.
        @1212  GAP_DAYS_MO_OS                   5.
        @1217  GAP_DAYS_MOPP_1M                 5.
        @1222  GAP_DAYS_MOPP_3M                 5.
        @1227  GAP_DAYS_MOPP_OS                 5.
        @1232  GAP_DAYS_MONPP_1M                5.
        @1237  GAP_DAYS_MONPP_3M                5.
        @1242  GAP_DAYS_MONPP_OS                5.
        @1247  POST_OOPT_TIER_DRUG_TYPE         $6.
        @1253  POST_OOPT_COSTSHARE_TYPE         $1.
        @1254  POST_OOPT_COINS_PCT              12.2
        @1266  POST_OOPT_COPAY_AMT              12.2;
run;

title 'Part D Tier 2007';
proc contents data=out.TIER_2007 varnum;
proc print data=out.TIER_2007(obs=5);
  title2 'Sample Listing - First 5 Rows';
run;
proc means data=out.TIER_2007;
  title2 'Simple Means';
run;

proc freq data=out.TIER_2007;
  title2 'Freqs';
  table GAP_COSTSHARE_TYPE
        GAP_TIER
        POST_OOPT_COSTSHARE_TYPE
        PRE_ICL_COSTSHARE_TYPE
        TIER_ID/missing;
run;

* End of Program *;
