* SAS Read-In Program
*
* Name: tier_2008_readin.sas
*
* Purpose: Read-In the delimited flat file TIER_2008.
*
* Delimiter: Fixed Column
*
* Date: 26DEC14   Time: 22:25
*
* Programmer: Adam Hendricks, Adam.Hendricks@gdit.com, 515-645-3015
*
*;

%let dirpath = .; * <--  Directory Path for Input Flat File in FILENAME Statement *;

filename in  "%trim(&dirpath)/tier_2008.dat" lrecl=1284;

libname  out '.'; * <--  Directory Path for Output Library in LIBNAME Statement   *;

* Start *;
data out.TIER_2008;
  length CONTRACT_ID                      $5
         PLAN_ID                          $3
         TIER_ID                          $2
         GAP_TIER                         $1
         GAP_TIER_PARTIAL                 $1
         SPECIALTY_TIER                   $1
         PRE_ICL_TIER_DRUG_TYPE           $6
         PRE_ICL_COSTSHARE_TYPE           $1
         PRE_ICL_INP_COINS_1M             8
         PRE_ICL_INP_COINS_3M             8
         PRE_ICL_INP_COINS_OS             8
         PRE_ICL_INPP_COINS_1M            8
         PRE_ICL_INPP_COINS_3M            8
         PRE_ICL_INPP_COINS_OS            8
         PRE_ICL_INNPP_COINS_1M           8
         PRE_ICL_INNPP_COINS_3M           8
         PRE_ICL_INNPP_COINS_OS           8
         PRE_ICL_OONP_COINS_1M            8
         PRE_ICL_OONP_COINS_OS            8
         PRE_ICL_MO_COINS_1M              8
         PRE_ICL_MO_COINS_3M              8
         PRE_ICL_MO_COINS_OS              8
         PRE_ICL_MOPP_COINS_1M            8
         PRE_ICL_MOPP_COINS_3M            8
         PRE_ICL_MOPP_COINS_OS            8
         PRE_ICL_MONPP_COINS_1M           8
         PRE_ICL_MONPP_COINS_3M           8
         PRE_ICL_MONPP_COINS_OS           8
         PRE_ICL_LTCP_COINS_1M            8
         PRE_ICL_INP_COPAY_1M             8
         PRE_ICL_INP_COPAY_3M             8
         PRE_ICL_INP_COPAY_OS             8
         PRE_ICL_INPP_COPAY_1M            8
         PRE_ICL_INPP_COPAY_3M            8
         PRE_ICL_INPP_COPAY_OS            8
         PRE_ICL_INNPP_COPAY_1M           8
         PRE_ICL_INNPP_COPAY_3M           8
         PRE_ICL_INNPP_COPAY_OS           8
         PRE_ICL_OONP_COPAY_1M            8
         PRE_ICL_OONP_COPAY_OS            8
         PRE_ICL_MO_COPAY_1M              8
         PRE_ICL_MO_COPAY_3M              8
         PRE_ICL_MO_COPAY_OS              8
         PRE_ICL_MOPP_COPAY_1M            8
         PRE_ICL_MOPP_COPAY_3M            8
         PRE_ICL_MOPP_COPAY_OS            8
         PRE_ICL_MONPP_COPAY_1M           8
         PRE_ICL_MONPP_COPAY_3M           8
         PRE_ICL_MONPP_COPAY_OS           8
         PRE_ICL_LTCP_COPAY_1M            8
         PRE_ICL_DAYS_INP_1M              8
         PRE_ICL_DAYS_INP_3M              8
         PRE_ICL_DAYS_INP_OS              8
         PRE_ICL_DAYS_INPP_1M             8
         PRE_ICL_DAYS_INPP_3M             8
         PRE_ICL_DAYS_INPP_OS             8
         PRE_ICL_DAYS_INNPP_1M            8
         PRE_ICL_DAYS_INNPP_3M            8
         PRE_ICL_DAYS_INNPP_OS            8
         PRE_ICL_DAYS_OONP_1M             8
         PRE_ICL_DAYS_OONP_OS             8
         PRE_ICL_DAYS_MO_1M               8
         PRE_ICL_DAYS_MO_3M               8
         PRE_ICL_DAYS_MO_OS               8
         PRE_ICL_DAYS_MOPP_1M             8
         PRE_ICL_DAYS_MOPP_3M             8
         PRE_ICL_DAYS_MOPP_OS             8
         PRE_ICL_DAYS_MONPP_1M            8
         PRE_ICL_DAYS_MONPP_3M            8
         PRE_ICL_DAYS_MONPP_OS            8
         PRE_ICL_DAYS_LTCP_1M             8
         GAP_TIER_DRUG_TYPE               $6
         GAP_TIER_PARTIAL_TYPE            $8
         GAP_COSTSHARE_TYPE               $1
         GAP_INP_COINS_1M                 8
         GAP_INP_COINS_3M                 8
         GAP_INP_COINS_OS                 8
         GAP_INPP_COINS_1M                8
         GAP_INPP_COINS_3M                8
         GAP_INPP_COINS_OS                8
         GAP_INNPP_COINS_1M               8
         GAP_INNPP_COINS_3M               8
         GAP_INNPP_COINS_OS               8
         GAP_OONP_COINS_1M                8
         GAP_OONP_COINS_OS                8
         GAP_MO_COINS_1M                  8
         GAP_MO_COINS_3M                  8
         GAP_MO_COINS_OS                  8
         GAP_MOPP_COINS_1M                8
         GAP_MOPP_COINS_3M                8
         GAP_MOPP_COINS_OS                8
         GAP_MONPP_COINS_1M               8
         GAP_MONPP_COINS_3M               8
         GAP_MONPP_COINS_OS               8
         GAP_LTCP_COINS_1M                8
         GAP_INP_COPAY_1M                 8
         GAP_INP_COPAY_3M                 8
         GAP_INP_COPAY_OS                 8
         GAP_INPP_COPAY_1M                8
         GAP_INPP_COPAY_3M                8
         GAP_INPP_COPAY_OS                8
         GAP_INNPP_COPAY_1M               8
         GAP_INNPP_COPAY_3M               8
         GAP_INNPP_COPAY_OS               8
         GAP_OONP_COPAY_1M                8
         GAP_OONP_COPAY_OS                8
         GAP_MO_COPAY_1M                  8
         GAP_MO_COPAY_3M                  8
         GAP_MO_COPAY_OS                  8
         GAP_MOPP_COPAY_1M                8
         GAP_MOPP_COPAY_3M                8
         GAP_MOPP_COPAY_OS                8
         GAP_MONPP_COPAY_1M               8
         GAP_MONPP_COPAY_3M               8
         GAP_MONPP_COPAY_OS               8
         GAP_LTCP_COPAY_1M                8
         GAP_DAYS_INP_1M                  8
         GAP_DAYS_INP_3M                  8
         GAP_DAYS_INP_OS                  8
         GAP_DAYS_INPP_1M                 8
         GAP_DAYS_INPP_3M                 8
         GAP_DAYS_INPP_OS                 8
         GAP_DAYS_INNPP_1M                8
         GAP_DAYS_INNPP_3M                8
         GAP_DAYS_INNPP_OS                8
         GAP_DAYS_OONP_1M                 8
         GAP_DAYS_OONP_OS                 8
         GAP_DAYS_MO_1M                   8
         GAP_DAYS_MO_3M                   8
         GAP_DAYS_MO_OS                   8
         GAP_DAYS_MOPP_1M                 8
         GAP_DAYS_MOPP_3M                 8
         GAP_DAYS_MOPP_OS                 8
         GAP_DAYS_MONPP_1M                8
         GAP_DAYS_MONPP_3M                8
         GAP_DAYS_MONPP_OS                8
         GAP_DAYS_LTCP_1M                 8
         POST_OOPT_TIER_DRUG_TYPE         $6
         POST_OOPT_COSTSHARE_TYPE         $1
         POST_OOPT_COINS_PCT              8
         POST_OOPT_COPAY_AMT              8;

  format CONTRACT_ID                      $5.
         PLAN_ID                          $3.
         TIER_ID                          $2.
         GAP_TIER                         $1.
         GAP_TIER_PARTIAL                 $1.
         SPECIALTY_TIER                   $1.
         PRE_ICL_TIER_DRUG_TYPE           $6.
         PRE_ICL_COSTSHARE_TYPE           $1.
         PRE_ICL_INP_COINS_1M             12.2
         PRE_ICL_INP_COINS_3M             12.2
         PRE_ICL_INP_COINS_OS             12.2
         PRE_ICL_INPP_COINS_1M            12.2
         PRE_ICL_INPP_COINS_3M            12.2
         PRE_ICL_INPP_COINS_OS            12.2
         PRE_ICL_INNPP_COINS_1M           12.2
         PRE_ICL_INNPP_COINS_3M           12.2
         PRE_ICL_INNPP_COINS_OS           12.2
         PRE_ICL_OONP_COINS_1M            12.2
         PRE_ICL_OONP_COINS_OS            12.2
         PRE_ICL_MO_COINS_1M              12.2
         PRE_ICL_MO_COINS_3M              12.2
         PRE_ICL_MO_COINS_OS              12.2
         PRE_ICL_MOPP_COINS_1M            12.2
         PRE_ICL_MOPP_COINS_3M            12.2
         PRE_ICL_MOPP_COINS_OS            12.2
         PRE_ICL_MONPP_COINS_1M           12.2
         PRE_ICL_MONPP_COINS_3M           12.2
         PRE_ICL_MONPP_COINS_OS           12.2
         PRE_ICL_LTCP_COINS_1M            12.2
         PRE_ICL_INP_COPAY_1M             12.2
         PRE_ICL_INP_COPAY_3M             12.2
         PRE_ICL_INP_COPAY_OS             12.2
         PRE_ICL_INPP_COPAY_1M            12.2
         PRE_ICL_INPP_COPAY_3M            12.2
         PRE_ICL_INPP_COPAY_OS            12.2
         PRE_ICL_INNPP_COPAY_1M           12.2
         PRE_ICL_INNPP_COPAY_3M           12.2
         PRE_ICL_INNPP_COPAY_OS           12.2
         PRE_ICL_OONP_COPAY_1M            12.2
         PRE_ICL_OONP_COPAY_OS            12.2
         PRE_ICL_MO_COPAY_1M              12.2
         PRE_ICL_MO_COPAY_3M              12.2
         PRE_ICL_MO_COPAY_OS              12.2
         PRE_ICL_MOPP_COPAY_1M            12.2
         PRE_ICL_MOPP_COPAY_3M            12.2
         PRE_ICL_MOPP_COPAY_OS            12.2
         PRE_ICL_MONPP_COPAY_1M           12.2
         PRE_ICL_MONPP_COPAY_3M           12.2
         PRE_ICL_MONPP_COPAY_OS           12.2
         PRE_ICL_LTCP_COPAY_1M            12.2
         PRE_ICL_DAYS_INP_1M              5.
         PRE_ICL_DAYS_INP_3M              5.
         PRE_ICL_DAYS_INP_OS              5.
         PRE_ICL_DAYS_INPP_1M             5.
         PRE_ICL_DAYS_INPP_3M             5.
         PRE_ICL_DAYS_INPP_OS             5.
         PRE_ICL_DAYS_INNPP_1M            5.
         PRE_ICL_DAYS_INNPP_3M            5.
         PRE_ICL_DAYS_INNPP_OS            5.
         PRE_ICL_DAYS_OONP_1M             5.
         PRE_ICL_DAYS_OONP_OS             5.
         PRE_ICL_DAYS_MO_1M               5.
         PRE_ICL_DAYS_MO_3M               5.
         PRE_ICL_DAYS_MO_OS               5.
         PRE_ICL_DAYS_MOPP_1M             5.
         PRE_ICL_DAYS_MOPP_3M             5.
         PRE_ICL_DAYS_MOPP_OS             5.
         PRE_ICL_DAYS_MONPP_1M            5.
         PRE_ICL_DAYS_MONPP_3M            5.
         PRE_ICL_DAYS_MONPP_OS            5.
         PRE_ICL_DAYS_LTCP_1M             5.
         GAP_TIER_DRUG_TYPE               $6.
         GAP_TIER_PARTIAL_TYPE            $8.
         GAP_COSTSHARE_TYPE               $1.
         GAP_INP_COINS_1M                 12.2
         GAP_INP_COINS_3M                 12.2
         GAP_INP_COINS_OS                 12.2
         GAP_INPP_COINS_1M                12.2
         GAP_INPP_COINS_3M                12.2
         GAP_INPP_COINS_OS                12.2
         GAP_INNPP_COINS_1M               12.2
         GAP_INNPP_COINS_3M               12.2
         GAP_INNPP_COINS_OS               12.2
         GAP_OONP_COINS_1M                12.2
         GAP_OONP_COINS_OS                12.2
         GAP_MO_COINS_1M                  12.2
         GAP_MO_COINS_3M                  12.2
         GAP_MO_COINS_OS                  12.2
         GAP_MOPP_COINS_1M                12.2
         GAP_MOPP_COINS_3M                12.2
         GAP_MOPP_COINS_OS                12.2
         GAP_MONPP_COINS_1M               12.2
         GAP_MONPP_COINS_3M               12.2
         GAP_MONPP_COINS_OS               12.2
         GAP_LTCP_COINS_1M                12.2
         GAP_INP_COPAY_1M                 12.2
         GAP_INP_COPAY_3M                 12.2
         GAP_INP_COPAY_OS                 12.2
         GAP_INPP_COPAY_1M                12.2
         GAP_INPP_COPAY_3M                12.2
         GAP_INPP_COPAY_OS                12.2
         GAP_INNPP_COPAY_1M               12.2
         GAP_INNPP_COPAY_3M               12.2
         GAP_INNPP_COPAY_OS               12.2
         GAP_OONP_COPAY_1M                12.2
         GAP_OONP_COPAY_OS                12.2
         GAP_MO_COPAY_1M                  12.2
         GAP_MO_COPAY_3M                  12.2
         GAP_MO_COPAY_OS                  12.2
         GAP_MOPP_COPAY_1M                12.2
         GAP_MOPP_COPAY_3M                12.2
         GAP_MOPP_COPAY_OS                12.2
         GAP_MONPP_COPAY_1M               12.2
         GAP_MONPP_COPAY_3M               12.2
         GAP_MONPP_COPAY_OS               12.2
         GAP_LTCP_COPAY_1M                12.2
         GAP_DAYS_INP_1M                  5.
         GAP_DAYS_INP_3M                  5.
         GAP_DAYS_INP_OS                  5.
         GAP_DAYS_INPP_1M                 5.
         GAP_DAYS_INPP_3M                 5.
         GAP_DAYS_INPP_OS                 5.
         GAP_DAYS_INNPP_1M                5.
         GAP_DAYS_INNPP_3M                5.
         GAP_DAYS_INNPP_OS                5.
         GAP_DAYS_OONP_1M                 5.
         GAP_DAYS_OONP_OS                 5.
         GAP_DAYS_MO_1M                   5.
         GAP_DAYS_MO_3M                   5.
         GAP_DAYS_MO_OS                   5.
         GAP_DAYS_MOPP_1M                 5.
         GAP_DAYS_MOPP_3M                 5.
         GAP_DAYS_MOPP_OS                 5.
         GAP_DAYS_MONPP_1M                5.
         GAP_DAYS_MONPP_3M                5.
         GAP_DAYS_MONPP_OS                5.
         GAP_DAYS_LTCP_1M                 5.
         POST_OOPT_TIER_DRUG_TYPE         $6.
         POST_OOPT_COSTSHARE_TYPE         $1.
         POST_OOPT_COINS_PCT              12.2
         POST_OOPT_COPAY_AMT              12.2;

  label  CONTRACT_ID                      = "Contract ID"
         PLAN_ID                          = "Plan ID"
         TIER_ID                          = "Tier Number"
         GAP_TIER                         = "Indicates whether tier is covered in the gap"
         GAP_TIER_PARTIAL                 = "Indicates whether tier is partially covered in the gap"
         SPECIALTY_TIER                   = "Indicates whether tier is a specialty tier"
         PRE_ICL_TIER_DRUG_TYPE           = "Pre-ICL Tier Drug Type"
         PRE_ICL_COSTSHARE_TYPE           = "Pre-ICL Costshare Type"
         PRE_ICL_INP_COINS_1M             = "Pre-ICL Coinsurance In-Network Pharmacy - one month supply"
         PRE_ICL_INP_COINS_3M             = "Pre-ICL Coinsurance In-Network Pharmacy - three month supply"
         PRE_ICL_INP_COINS_OS             = "Pre-ICL Coinsurance In-Network Pharmacy - other day supply"
         PRE_ICL_INPP_COINS_1M            = "Pre-ICL Coinsurance In-Network Preferred Pharmacy - one month supply"
         PRE_ICL_INPP_COINS_3M            = "Pre-ICL Coinsurance In-Network Preferred Pharmacy - three month supply"
         PRE_ICL_INPP_COINS_OS            = "Pre-ICL Coinsurance In-Network Preferred Pharmacy - other day supply"
         PRE_ICL_INNPP_COINS_1M           = "Pre-ICL Coinsurance In-Network Non-Preferred Pharmacy - one month supply"
         PRE_ICL_INNPP_COINS_3M           = "Pre-ICL Coinsurance In-Network Non-Preferred Pharmacy - three month supply"
         PRE_ICL_INNPP_COINS_OS           = "Pre-ICL Coinsurance In-Network Non-Preferred Pharmacy - other day supply"
         PRE_ICL_OONP_COINS_1M            = "Pre-ICL Coinsurance Out-of-Network Pharmacy - one month supply"
         PRE_ICL_OONP_COINS_OS            = "Pre-ICL Coinsurance Out-of-Network Pharmacy - other day supply"
         PRE_ICL_MO_COINS_1M              = "Pre-ICL Coinsurance Mail Order Pharmacy - one month supply"
         PRE_ICL_MO_COINS_3M              = "Pre-ICL Coinsurance Mail Order Pharmacy - three month supply"
         PRE_ICL_MO_COINS_OS              = "Pre-ICL Coinsurance Mail Order Pharmacy - other day supply"
         PRE_ICL_MOPP_COINS_1M            = "Pre-ICL Coinsurance Mail Order Preferred Pharmacy - one month supply"
         PRE_ICL_MOPP_COINS_3M            = "Pre-ICL Coinsurance Mail Order Preferred Pharmacy - three month supply"
         PRE_ICL_MOPP_COINS_OS            = "Pre-ICL Coinsurance Mail Order Preferred Pharmacy - other day supply"
         PRE_ICL_MONPP_COINS_1M           = "Pre-ICL Coinsurance Mail Order Non-Preferred Pharmacy - one month supply"
         PRE_ICL_MONPP_COINS_3M           = "Pre-ICL Coinsurance Mail Order Non-Preferred Pharmacy - three month supply"
         PRE_ICL_MONPP_COINS_OS           = "Pre-ICL Coinsurance Mail Order Non-Preferred Pharmacy - other day supply"
         PRE_ICL_LTCP_COINS_1M            = "Pre-ICL Coinsurance Long Term Care Pharmacy - one month supply"
         PRE_ICL_INP_COPAY_1M             = "Pre-ICL Copay In-Network Pharmacy - one month supply"
         PRE_ICL_INP_COPAY_3M             = "Pre-ICL Copay In-Network Pharmacy - three month supply"
         PRE_ICL_INP_COPAY_OS             = "Pre-ICL Copay In-Network Pharmacy - other day supply"
         PRE_ICL_INPP_COPAY_1M            = "Pre-ICL Copay In-Network Preferred Pharmacy - one month supply"
         PRE_ICL_INPP_COPAY_3M            = "Pre-ICL Copay In-Network Preferred Pharmacy - three month supply"
         PRE_ICL_INPP_COPAY_OS            = "Pre-ICL Copay In-Network Preferred Pharmacy - other day supply"
         PRE_ICL_INNPP_COPAY_1M           = "Pre-ICL Copay In-Network Non-Preferred Pharmacy - one month supply"
         PRE_ICL_INNPP_COPAY_3M           = "Pre-ICL Copay In-Network Non-Preferred Pharmacy - three month supply"
         PRE_ICL_INNPP_COPAY_OS           = "Pre-ICL Copay In-Network Non-Preferred Pharmacy - other day supply"
         PRE_ICL_OONP_COPAY_1M            = "Pre-ICL Copay Out-of-Network Pharmacy - one month supply"
         PRE_ICL_OONP_COPAY_OS            = "Pre-ICL Copay Out-of-Network Pharmacy - other day supply"
         PRE_ICL_MO_COPAY_1M              = "Pre-ICL Copay Mail Order Pharmacy - one month supply"
         PRE_ICL_MO_COPAY_3M              = "Pre-ICL Copay Mail Order Pharmacy - three month supply"
         PRE_ICL_MO_COPAY_OS              = "Pre-ICL Copay Mail Order Pharmacy - other day supply"
         PRE_ICL_MOPP_COPAY_1M            = "Pre-ICL Copay Mail Order Preferred Pharmacy - one month supply"
         PRE_ICL_MOPP_COPAY_3M            = "Pre-ICL Copay Mail Order Preferred Pharmacy - three month supply"
         PRE_ICL_MOPP_COPAY_OS            = "Pre-ICL Copay Mail Order Preferred Pharmacy - other day supply"
         PRE_ICL_MONPP_COPAY_1M           = "Pre-ICL Copay Mail Order Non-Preferred Pharmacy - one month supply"
         PRE_ICL_MONPP_COPAY_3M           = "Pre-ICL Copay Mail Order Non-Preferred Pharmacy - three month supply"
         PRE_ICL_MONPP_COPAY_OS           = "Pre-ICL Copay Mail Order Non-Preferred Pharmacy - other day supply"
         PRE_ICL_LTCP_COPAY_1M            = "Pre-ICL Copay Long Term Care Pharmacy - one month supply"
         PRE_ICL_DAYS_INP_1M              = "Pre-ICL In-Network Pharmacy - number of days in one month supply"
         PRE_ICL_DAYS_INP_3M              = "Pre-ICL In-Network Pharmacy - number of days in three month supply"
         PRE_ICL_DAYS_INP_OS              = "Pre-ICL In-Network Pharmacy - number of days in other day supply"
         PRE_ICL_DAYS_INPP_1M             = "Pre-ICL In-Network Preferred Pharmacy - number of days in one month supply"
         PRE_ICL_DAYS_INPP_3M             = "Pre-ICL In-Network Preferred Pharmacy - number of days in three month supply"
         PRE_ICL_DAYS_INPP_OS             = "Pre-ICL In-Network Preferred Pharmacy - number of days in other day supply"
         PRE_ICL_DAYS_INNPP_1M            = "Pre-ICL In-Network Non-Preferred Pharmacy - number of days in one month supply"
         PRE_ICL_DAYS_INNPP_3M            = "Pre-ICL In-Network Non-Preferred Pharmacy - number of days in three month supply"
         PRE_ICL_DAYS_INNPP_OS            = "Pre-ICL In-Network Non-Preferred Pharmacy - number of days in other day supply"
         PRE_ICL_DAYS_OONP_1M             = "Pre-ICL Out-of-Network Pharmacy - number of days in one month supply"
         PRE_ICL_DAYS_OONP_OS             = "Pre-ICL Out-of-Network Pharmacy - number of days in other day supply"
         PRE_ICL_DAYS_MO_1M               = "Pre-ICL Mail Order Pharmacy - number of days in one month supply"
         PRE_ICL_DAYS_MO_3M               = "Pre-ICL Mail Order Pharmacy - number of days in three month supply"
         PRE_ICL_DAYS_MO_OS               = "Pre-ICL Mail Order Pharmacy - number of days in other day supply"
         PRE_ICL_DAYS_MOPP_1M             = "Pre-ICL Mail Order Preferred Pharmacy - number of days in one month supply"
         PRE_ICL_DAYS_MOPP_3M             = "Pre-ICL Mail Order Preferred Pharmacy - number of days in three month supply"
         PRE_ICL_DAYS_MOPP_OS             = "Pre-ICL Mail Order Preferred Pharmacy - number of days in other day supply"
         PRE_ICL_DAYS_MONPP_1M            = "Pre-ICL Mail Order Non-Preferred Pharmacy - number of days in one month supply"
         PRE_ICL_DAYS_MONPP_3M            = "Pre-ICL Mail Order Non-Preferred Pharmacy - number of days in three month supply"
         PRE_ICL_DAYS_MONPP_OS            = "Pre-ICL Mail Order Non-Preferred Pharmacy - number of days in other day supply"
         PRE_ICL_DAYS_LTCP_1M             = "Pre-ICL Long Term Care Pharmacy - number of days in one month supply"
         GAP_TIER_DRUG_TYPE               = "Gap Tier Drug Type"
         GAP_TIER_PARTIAL_TYPE            = "Type of partial gap coverage"
         GAP_COSTSHARE_TYPE               = "Gap Cost Share Type"
         GAP_INP_COINS_1M                 = "Gap Coinsurance In-Network Pharmacy - one month supply"
         GAP_INP_COINS_3M                 = "Gap Coinsurance In-Network Pharmacy - three month supply"
         GAP_INP_COINS_OS                 = "Gap Coinsurance In-Network Pharmacy - other day supply"
         GAP_INPP_COINS_1M                = "Gap Coinsurance In-Network Preferred Pharmacy - one month supply"
         GAP_INPP_COINS_3M                = "Gap Coinsurance In-Network Preferred Pharmacy - three month supply"
         GAP_INPP_COINS_OS                = "Gap Coinsurance In-Network Preferred Pharmacy - other day supply"
         GAP_INNPP_COINS_1M               = "Gap Coinsurance In-Network Non-Preferred Pharmacy - one month supply"
         GAP_INNPP_COINS_3M               = "Gap Coinsurance In-Network Non-Preferred Pharmacy - three month supply"
         GAP_INNPP_COINS_OS               = "Gap Coinsurance In-Network Non-Preferred Pharmacy - other day supply"
         GAP_OONP_COINS_1M                = "Gap Coinsurance Out-of-Network Pharmacy - one month supply"
         GAP_OONP_COINS_OS                = "Gap Coinsurance Out-of-Network Pharmacy - other day supply"
         GAP_MO_COINS_1M                  = "Gap Coinsurance Mail Order Pharmacy - one month supply"
         GAP_MO_COINS_3M                  = "Gap Coinsurance Mail Order Pharmacy - three month supply"
         GAP_MO_COINS_OS                  = "Gap Coinsurance Mail Order Pharmacy - other day supply"
         GAP_MOPP_COINS_1M                = "Gap Coinsurance Mail Order Preferred Pharmacy - one month supply"
         GAP_MOPP_COINS_3M                = "Gap Coinsurance Mail Order Preferred Pharmacy - three month supply"
         GAP_MOPP_COINS_OS                = "Gap Coinsurance Mail Order Preferred Pharmacy - other day supply"
         GAP_MONPP_COINS_1M               = "Gap Coinsurance Mail Order Non-Preferred Pharmacy - one month supply"
         GAP_MONPP_COINS_3M               = "Gap Coinsurance Mail Order Non-Preferred Pharmacy - three month supply"
         GAP_MONPP_COINS_OS               = "Gap Coinsurance Mail Order Non-Preferred Pharmacy - other day supply"
         GAP_LTCP_COINS_1M                = "Gap Coinsurance Long Term Care Pharmacy - one month supply"
         GAP_INP_COPAY_1M                 = "Gap Copay In-Network Pharmacy - one month supply"
         GAP_INP_COPAY_3M                 = "Gap Copay In-Network Pharmacy - three month supply"
         GAP_INP_COPAY_OS                 = "Gap Copay In-Network Pharmacy - other day supply"
         GAP_INPP_COPAY_1M                = "Gap Copay In-Network Preferred Pharmacy - one month supply"
         GAP_INPP_COPAY_3M                = "Gap Copay In-Network Preferred Pharmacy - three month supply"
         GAP_INPP_COPAY_OS                = "Gap Copay In-Network Preferred Pharmacy - other day supply"
         GAP_INNPP_COPAY_1M               = "Gap Copay In-Network Non-Preferred Pharmacy - one month supply"
         GAP_INNPP_COPAY_3M               = "Gap Copay In-Network Non-Preferred Pharmacy - three month supply"
         GAP_INNPP_COPAY_OS               = "Gap Copay In-Network Non-Preferred Pharmacy - other day supply"
         GAP_OONP_COPAY_1M                = "Gap Copay Out-of-Network Pharmacy - one month supply"
         GAP_OONP_COPAY_OS                = "Gap Copay Out-of-Network Pharmacy - other day supply"
         GAP_MO_COPAY_1M                  = "Gap Copay Mail Order Pharmacy - one month supply"
         GAP_MO_COPAY_3M                  = "Gap Copay Mail Order Pharmacy - three month supply"
         GAP_MO_COPAY_OS                  = "Gap Copay Mail Order Pharmacy - other day supply"
         GAP_MOPP_COPAY_1M                = "Gap Copay Mail Order Preferred Pharmacy - one month supply"
         GAP_MOPP_COPAY_3M                = "Gap Copay Mail Order Preferred Pharmacy - three month supply"
         GAP_MOPP_COPAY_OS                = "Gap Copay Mail Order Preferred Pharmacy - other day supply"
         GAP_MONPP_COPAY_1M               = "Gap Copay Mail Order Non-Preferred Pharmacy - one month supply"
         GAP_MONPP_COPAY_3M               = "Gap Copay Mail Order Non-Preferred Pharmacy - three month supply"
         GAP_MONPP_COPAY_OS               = "Gap Copay Mail Order Non-Preferred Pharmacy - other day supply"
         GAP_LTCP_COPAY_1M                = "Gap Copay Long Term Care Pharmacy - one month supply"
         GAP_DAYS_INP_1M                  = "Gap In-Network Pharmacy - number of days in one month supply"
         GAP_DAYS_INP_3M                  = "Gap In-Network Pharmacy - number of days in three month supply"
         GAP_DAYS_INP_OS                  = "Gap In-Network Pharmacy - number of days in other day supply"
         GAP_DAYS_INPP_1M                 = "Gap In-Network Preferred Pharmacy - number of days in one month supply"
         GAP_DAYS_INPP_3M                 = "Gap In-Network Preferred Pharmacy - number of days in three month supply"
         GAP_DAYS_INPP_OS                 = "Gap In-Network Preferred Pharmacy - number of days in other day supply"
         GAP_DAYS_INNPP_1M                = "Gap In-Network Non-Preferred Pharmacy - number of days in one month supply"
         GAP_DAYS_INNPP_3M                = "Gap In-Network Non-Preferred Pharmacy - number of days in three month supply"
         GAP_DAYS_INNPP_OS                = "Gap In-Network Non-Preferred Pharmacy - number of days in other day supply"
         GAP_DAYS_OONP_1M                 = "Gap Out-of-Network Pharmacy - number of days in one month supply"
         GAP_DAYS_OONP_OS                 = "Gap Out-of-Network Pharmacy - number of days in other day supply"
         GAP_DAYS_MO_1M                   = "Gap Mail Order Pharmacy - number of days in one month supply"
         GAP_DAYS_MO_3M                   = "Gap Mail Order Pharmacy - number of days in three month supply"
         GAP_DAYS_MO_OS                   = "Gap Mail Order Pharmacy - number of days in other day supply"
         GAP_DAYS_MOPP_1M                 = "Gap Mail Order Preferred Pharmacy - number of days in one month supply"
         GAP_DAYS_MOPP_3M                 = "Gap Mail Order Preferred Pharmacy - number of days in three month supply"
         GAP_DAYS_MOPP_OS                 = "Gap Mail Order Preferred Pharmacy - number of days in other day supply"
         GAP_DAYS_MONPP_1M                = "Gap Mail Order Non-Preferred Pharmacy - number of days in one month supply"
         GAP_DAYS_MONPP_3M                = "Gap Mail Order Non-Preferred Pharmacy - number of days in three month supply"
         GAP_DAYS_MONPP_OS                = "Gap Mail Order Non-Preferred Pharmacy - number of days in other day supply"
         GAP_DAYS_LTCP_1M                 = "Gap Long Term Care Pharmacy - number of days in one month supply"
         POST_OOPT_TIER_DRUG_TYPE         = "Post-Out-of-pocket threshold tier drug type"
         POST_OOPT_COSTSHARE_TYPE         = "Post-Out-of-pocket threshold costshare type"
         POST_OOPT_COINS_PCT              = "Post-Out-of-pocket threshold Coinsurance"
         POST_OOPT_COPAY_AMT              = "Post-Out-of-pocket threshold Copay";

  infile in missover truncover;

  input @0001  CONTRACT_ID                      $5.
        @0006  PLAN_ID                          $3.
        @0009  TIER_ID                          $2.
        @0011  GAP_TIER                         $1.
        @0012  GAP_TIER_PARTIAL                 $1.
        @0013  SPECIALTY_TIER                   $1.
        @0014  PRE_ICL_TIER_DRUG_TYPE           $6.
        @0020  PRE_ICL_COSTSHARE_TYPE           $1.
        @0021  PRE_ICL_INP_COINS_1M             12.2
        @0033  PRE_ICL_INP_COINS_3M             12.2
        @0045  PRE_ICL_INP_COINS_OS             12.2
        @0057  PRE_ICL_INPP_COINS_1M            12.2
        @0069  PRE_ICL_INPP_COINS_3M            12.2
        @0081  PRE_ICL_INPP_COINS_OS            12.2
        @0093  PRE_ICL_INNPP_COINS_1M           12.2
        @0105  PRE_ICL_INNPP_COINS_3M           12.2
        @0117  PRE_ICL_INNPP_COINS_OS           12.2
        @0129  PRE_ICL_OONP_COINS_1M            12.2
        @0141  PRE_ICL_OONP_COINS_OS            12.2
        @0153  PRE_ICL_MO_COINS_1M              12.2
        @0165  PRE_ICL_MO_COINS_3M              12.2
        @0177  PRE_ICL_MO_COINS_OS              12.2
        @0189  PRE_ICL_MOPP_COINS_1M            12.2
        @0201  PRE_ICL_MOPP_COINS_3M            12.2
        @0213  PRE_ICL_MOPP_COINS_OS            12.2
        @0225  PRE_ICL_MONPP_COINS_1M           12.2
        @0237  PRE_ICL_MONPP_COINS_3M           12.2
        @0249  PRE_ICL_MONPP_COINS_OS           12.2
        @0261  PRE_ICL_LTCP_COINS_1M            12.2
        @0273  PRE_ICL_INP_COPAY_1M             12.2
        @0285  PRE_ICL_INP_COPAY_3M             12.2
        @0297  PRE_ICL_INP_COPAY_OS             12.2
        @0309  PRE_ICL_INPP_COPAY_1M            12.2
        @0321  PRE_ICL_INPP_COPAY_3M            12.2
        @0333  PRE_ICL_INPP_COPAY_OS            12.2
        @0345  PRE_ICL_INNPP_COPAY_1M           12.2
        @0357  PRE_ICL_INNPP_COPAY_3M           12.2
        @0369  PRE_ICL_INNPP_COPAY_OS           12.2
        @0381  PRE_ICL_OONP_COPAY_1M            12.2
        @0393  PRE_ICL_OONP_COPAY_OS            12.2
        @0405  PRE_ICL_MO_COPAY_1M              12.2
        @0417  PRE_ICL_MO_COPAY_3M              12.2
        @0429  PRE_ICL_MO_COPAY_OS              12.2
        @0441  PRE_ICL_MOPP_COPAY_1M            12.2
        @0453  PRE_ICL_MOPP_COPAY_3M            12.2
        @0465  PRE_ICL_MOPP_COPAY_OS            12.2
        @0477  PRE_ICL_MONPP_COPAY_1M           12.2
        @0489  PRE_ICL_MONPP_COPAY_3M           12.2
        @0501  PRE_ICL_MONPP_COPAY_OS           12.2
        @0513  PRE_ICL_LTCP_COPAY_1M            12.2
        @0525  PRE_ICL_DAYS_INP_1M              5.
        @0530  PRE_ICL_DAYS_INP_3M              5.
        @0535  PRE_ICL_DAYS_INP_OS              5.
        @0540  PRE_ICL_DAYS_INPP_1M             5.
        @0545  PRE_ICL_DAYS_INPP_3M             5.
        @0550  PRE_ICL_DAYS_INPP_OS             5.
        @0555  PRE_ICL_DAYS_INNPP_1M            5.
        @0560  PRE_ICL_DAYS_INNPP_3M            5.
        @0565  PRE_ICL_DAYS_INNPP_OS            5.
        @0570  PRE_ICL_DAYS_OONP_1M             5.
        @0575  PRE_ICL_DAYS_OONP_OS             5.
        @0580  PRE_ICL_DAYS_MO_1M               5.
        @0585  PRE_ICL_DAYS_MO_3M               5.
        @0590  PRE_ICL_DAYS_MO_OS               5.
        @0595  PRE_ICL_DAYS_MOPP_1M             5.
        @0600  PRE_ICL_DAYS_MOPP_3M             5.
        @0605  PRE_ICL_DAYS_MOPP_OS             5.
        @0610  PRE_ICL_DAYS_MONPP_1M            5.
        @0615  PRE_ICL_DAYS_MONPP_3M            5.
        @0620  PRE_ICL_DAYS_MONPP_OS            5.
        @0625  PRE_ICL_DAYS_LTCP_1M             5.
        @0630  GAP_TIER_DRUG_TYPE               $6.
        @0636  GAP_TIER_PARTIAL_TYPE            $8.
        @0644  GAP_COSTSHARE_TYPE               $1.
        @0645  GAP_INP_COINS_1M                 12.2
        @0657  GAP_INP_COINS_3M                 12.2
        @0669  GAP_INP_COINS_OS                 12.2
        @0681  GAP_INPP_COINS_1M                12.2
        @0693  GAP_INPP_COINS_3M                12.2
        @0705  GAP_INPP_COINS_OS                12.2
        @0717  GAP_INNPP_COINS_1M               12.2
        @0729  GAP_INNPP_COINS_3M               12.2
        @0741  GAP_INNPP_COINS_OS               12.2
        @0753  GAP_OONP_COINS_1M                12.2
        @0765  GAP_OONP_COINS_OS                12.2
        @0777  GAP_MO_COINS_1M                  12.2
        @0789  GAP_MO_COINS_3M                  12.2
        @0801  GAP_MO_COINS_OS                  12.2
        @0813  GAP_MOPP_COINS_1M                12.2
        @0825  GAP_MOPP_COINS_3M                12.2
        @0837  GAP_MOPP_COINS_OS                12.2
        @0849  GAP_MONPP_COINS_1M               12.2
        @0861  GAP_MONPP_COINS_3M               12.2
        @0873  GAP_MONPP_COINS_OS               12.2
        @0885  GAP_LTCP_COINS_1M                12.2
        @0897  GAP_INP_COPAY_1M                 12.2
        @0909  GAP_INP_COPAY_3M                 12.2
        @0921  GAP_INP_COPAY_OS                 12.2
        @0933  GAP_INPP_COPAY_1M                12.2
        @0945  GAP_INPP_COPAY_3M                12.2
        @0957  GAP_INPP_COPAY_OS                12.2
        @0969  GAP_INNPP_COPAY_1M               12.2
        @0981  GAP_INNPP_COPAY_3M               12.2
        @0993  GAP_INNPP_COPAY_OS               12.2
        @1005  GAP_OONP_COPAY_1M                12.2
        @1017  GAP_OONP_COPAY_OS                12.2
        @1029  GAP_MO_COPAY_1M                  12.2
        @1041  GAP_MO_COPAY_3M                  12.2
        @1053  GAP_MO_COPAY_OS                  12.2
        @1065  GAP_MOPP_COPAY_1M                12.2
        @1077  GAP_MOPP_COPAY_3M                12.2
        @1089  GAP_MOPP_COPAY_OS                12.2
        @1101  GAP_MONPP_COPAY_1M               12.2
        @1113  GAP_MONPP_COPAY_3M               12.2
        @1125  GAP_MONPP_COPAY_OS               12.2
        @1137  GAP_LTCP_COPAY_1M                12.2
        @1149  GAP_DAYS_INP_1M                  5.
        @1154  GAP_DAYS_INP_3M                  5.
        @1159  GAP_DAYS_INP_OS                  5.
        @1164  GAP_DAYS_INPP_1M                 5.
        @1169  GAP_DAYS_INPP_3M                 5.
        @1174  GAP_DAYS_INPP_OS                 5.
        @1179  GAP_DAYS_INNPP_1M                5.
        @1184  GAP_DAYS_INNPP_3M                5.
        @1189  GAP_DAYS_INNPP_OS                5.
        @1194  GAP_DAYS_OONP_1M                 5.
        @1199  GAP_DAYS_OONP_OS                 5.
        @1204  GAP_DAYS_MO_1M                   5.
        @1209  GAP_DAYS_MO_3M                   5.
        @1214  GAP_DAYS_MO_OS                   5.
        @1219  GAP_DAYS_MOPP_1M                 5.
        @1224  GAP_DAYS_MOPP_3M                 5.
        @1229  GAP_DAYS_MOPP_OS                 5.
        @1234  GAP_DAYS_MONPP_1M                5.
        @1239  GAP_DAYS_MONPP_3M                5.
        @1244  GAP_DAYS_MONPP_OS                5.
        @1249  GAP_DAYS_LTCP_1M                 5.
        @1254  POST_OOPT_TIER_DRUG_TYPE         $6.
        @1260  POST_OOPT_COSTSHARE_TYPE         $1.
        @1261  POST_OOPT_COINS_PCT              12.2
        @1273  POST_OOPT_COPAY_AMT              12.2;
run;

title 'Part D Tier 2008';
proc contents data=out.TIER_2008 varnum;
proc print data=out.TIER_2008(obs=5);
  title2 'Sample Listing - First 5 Rows';
run;
proc means data=out.TIER_2008;
  title2 'Simple Means';
run;

proc freq data=out.TIER_2008;
  title2 'Freqs';
  table GAP_COSTSHARE_TYPE
        GAP_TIER
        GAP_TIER_PARTIAL
        POST_OOPT_COSTSHARE_TYPE
        PRE_ICL_COSTSHARE_TYPE
        SPECIALTY_TIER
        TIER_ID/missing;
run;

* End of Program *;
