* SAS Read-In Program
*
* Name: tier_2013_readin.sas
*
* Purpose: Read-In the delimited flat file TIER_2013.
*
* Delimiter: Fixed Column
*
* Date: 17DEC14   Time: 13:48
*
* Programmer: Adam Hendricks, Adam.Hendricks@gdit.com, 515-645-3015
*
*;

%let dirpath = .; * <--  Directory Path for Input Flat File in FILENAME Statement *;

filename in  "%trim(&dirpath)/tier_2013.dat" lrecl=1620;

libname  out '.'; * <--  Directory Path for Output Library in LIBNAME Statement   *;

* Start *;
data out.TIER_2013;
  length CONTRACT_ID                      $5
         PLAN_ID                          $3
         TIER_ID                          $2
         GAP_TIER                         $1
         GAP_TIER_PARTIAL                 $1
         EXCLUDED_TIER_GAP                $1
         EXCLUDED_TIER_PRE_ICL            $1
         SPECIALTY_TIER                   $1
         PRE_ICL_TIER_DRUG_TYPE           $6
         PRE_ICL_COSTSHARE_TYPE           $1
         PRE_ICL_INP_COINS_1M             8
         PRE_ICL_INP_COINS_2M             8
         PRE_ICL_INP_COINS_3M             8
         PRE_ICL_INP_COINS_AVG_1M         8
         PRE_ICL_INPP_COINS_1M            8
         PRE_ICL_INPP_COINS_2M            8
         PRE_ICL_INPP_COINS_3M            8
         PRE_ICL_INPP_COINS_AVG_1M        8
         PRE_ICL_INNPP_COINS_1M           8
         PRE_ICL_INNPP_COINS_2M           8
         PRE_ICL_INNPP_COINS_3M           8
         PRE_ICL_INNPP_COINS_AVG_1M       8
         PRE_ICL_OONP_COINS_1M            8
         PRE_ICL_OONP_COINS_OS            8
         PRE_ICL_MO_COINS_1M              8
         PRE_ICL_MO_COINS_2M              8
         PRE_ICL_MO_COINS_3M              8
         PRE_ICL_MOPP_COINS_1M            8
         PRE_ICL_MOPP_COINS_2M            8
         PRE_ICL_MOPP_COINS_3M            8
         PRE_ICL_MONPP_COINS_1M           8
         PRE_ICL_MONPP_COINS_2M           8
         PRE_ICL_MONPP_COINS_3M           8
         PRE_ICL_LTCP_COINS_B_1M          8
         PRE_ICL_LTCP_COINS_G_1M          8
         PRE_ICL_INP_COPAY_1M             8
         PRE_ICL_INP_COPAY_2M             8
         PRE_ICL_INP_COPAY_3M             8
         PRE_ICL_INP_COPAY_DAILY          8
         PRE_ICL_INPP_COPAY_1M            8
         PRE_ICL_INPP_COPAY_2M            8
         PRE_ICL_INPP_COPAY_3M            8
         PRE_ICL_INPP_COPAY_DAILY         8
         PRE_ICL_INNPP_COPAY_1M           8
         PRE_ICL_INNPP_COPAY_2M           8
         PRE_ICL_INNPP_COPAY_3M           8
         PRE_ICL_INNPP_COPAY_DAILY        8
         PRE_ICL_OONP_COPAY_1M            8
         PRE_ICL_OONP_COPAY_OS            8
         PRE_ICL_MO_COPAY_1M              8
         PRE_ICL_MO_COPAY_2M              8
         PRE_ICL_MO_COPAY_3M              8
         PRE_ICL_MO_COPAY_DAILY           8
         PRE_ICL_MOPP_COPAY_1M            8
         PRE_ICL_MOPP_COPAY_2M            8
         PRE_ICL_MOPP_COPAY_3M            8
         PRE_ICL_MOPP_COPAY_DAILY         8
         PRE_ICL_MONPP_COPAY_1M           8
         PRE_ICL_MONPP_COPAY_2M           8
         PRE_ICL_MONPP_COPAY_3M           8
         PRE_ICL_MONPP_COPAY_DAILY        8
         PRE_ICL_LTCP_COPAY_B_1M          8
         PRE_ICL_LTCP_COPAY_B_DAILY       8
         PRE_ICL_LTCP_COPAY_G_1M          8
         PRE_ICL_LTCP_COPAY_G_DAILY       8
         PRE_ICL_DAYS_INP_1M              8
         PRE_ICL_DAYS_INP_2M              8
         PRE_ICL_DAYS_INP_3M              8
         PRE_ICL_DAYS_INPP_1M             8
         PRE_ICL_DAYS_INPP_2M             8
         PRE_ICL_DAYS_INPP_3M             8
         PRE_ICL_DAYS_INNPP_1M            8
         PRE_ICL_DAYS_INNPP_2M            8
         PRE_ICL_DAYS_INNPP_3M            8
         PRE_ICL_DAYS_OONP_1M             8
         PRE_ICL_DAYS_OONP_OS             8
         PRE_ICL_DAYS_MO_1M               8
         PRE_ICL_DAYS_MO_2M               8
         PRE_ICL_DAYS_MO_3M               8
         PRE_ICL_DAYS_MOPP_1M             8
         PRE_ICL_DAYS_MOPP_2M             8
         PRE_ICL_DAYS_MOPP_3M             8
         PRE_ICL_DAYS_MONPP_1M            8
         PRE_ICL_DAYS_MONPP_2M            8
         PRE_ICL_DAYS_MONPP_3M            8
         PRE_ICL_DAYS_LTCP_B_1M           8
         PRE_ICL_DAYS_LTCP_B_OS           8
         PRE_ICL_DAYS_LTCP_G_1M           8
         PRE_ICL_DAYS_LTCP_G_OS           8
         GAP_TIER_DRUG_TYPE               $6
         GAP_COSTSHARE_TYPE               $1
         GAP_INP_COINS_1M                 8
         GAP_INP_COINS_2M                 8
         GAP_INP_COINS_3M                 8
         GAP_INP_COINS_AVG_1M             8
         GAP_INPP_COINS_1M                8
         GAP_INPP_COINS_2M                8
         GAP_INPP_COINS_3M                8
         GAP_INPP_COINS_AVG_1M            8
         GAP_INNPP_COINS_1M               8
         GAP_INNPP_COINS_2M               8
         GAP_INNPP_COINS_3M               8
         GAP_INNPP_COINS_AVG_1M           8
         GAP_OONP_COINS_1M                8
         GAP_OONP_COINS_OS                8
         GAP_MO_COINS_1M                  8
         GAP_MO_COINS_2M                  8
         GAP_MO_COINS_3M                  8
         GAP_MOPP_COINS_1M                8
         GAP_MOPP_COINS_2M                8
         GAP_MOPP_COINS_3M                8
         GAP_MONPP_COINS_1M               8
         GAP_MONPP_COINS_2M               8
         GAP_MONPP_COINS_3M               8
         GAP_LTCP_COINS_B_1M              8
         GAP_LTCP_COINS_G_1M              8
         GAP_INP_COPAY_1M                 8
         GAP_INP_COPAY_2M                 8
         GAP_INP_COPAY_3M                 8
         GAP_INP_COPAY_DAILY              8
         GAP_INPP_COPAY_1M                8
         GAP_INPP_COPAY_2M                8
         GAP_INPP_COPAY_3M                8
         GAP_INPP_COPAY_DAILY             8
         GAP_INNPP_COPAY_1M               8
         GAP_INNPP_COPAY_2M               8
         GAP_INNPP_COPAY_3M               8
         GAP_INNPP_COPAY_DAILY            8
         GAP_OONP_COPAY_1M                8
         GAP_OONP_COPAY_OS                8
         GAP_MO_COPAY_1M                  8
         GAP_MO_COPAY_2M                  8
         GAP_MO_COPAY_3M                  8
         GAP_MO_COPAY_DAILY               8
         GAP_MOPP_COPAY_1M                8
         GAP_MOPP_COPAY_2M                8
         GAP_MOPP_COPAY_3M                8
         GAP_MOPP_COPAY_DAILY             8
         GAP_MONPP_COPAY_1M               8
         GAP_MONPP_COPAY_2M               8
         GAP_MONPP_COPAY_3M               8
         GAP_MONPP_COPAY_DAILY            8
         GAP_LTCP_COPAY_B_1M              8
         GAP_LTCP_COPAY_B_DAILY           8
         GAP_LTCP_COPAY_G_1M              8
         GAP_LTCP_COPAY_G_DAILY           8
         GAP_DAYS_INP_1M                  8
         GAP_DAYS_INP_2M                  8
         GAP_DAYS_INP_3M                  8
         GAP_DAYS_INPP_1M                 8
         GAP_DAYS_INPP_2M                 8
         GAP_DAYS_INPP_3M                 8
         GAP_DAYS_INNPP_1M                8
         GAP_DAYS_INNPP_2M                8
         GAP_DAYS_INNPP_3M                8
         GAP_DAYS_OONP_1M                 8
         GAP_DAYS_OONP_OS                 8
         GAP_DAYS_MO_1M                   8
         GAP_DAYS_MO_2M                   8
         GAP_DAYS_MO_3M                   8
         GAP_DAYS_MOPP_1M                 8
         GAP_DAYS_MOPP_2M                 8
         GAP_DAYS_MOPP_3M                 8
         GAP_DAYS_MONPP_1M                8
         GAP_DAYS_MONPP_2M                8
         GAP_DAYS_MONPP_3M                8
         GAP_DAYS_LTCP_B_1M               8
         GAP_DAYS_LTCP_B_OS               8
         GAP_DAYS_LTCP_G_1M               8
         GAP_DAYS_LTCP_G_OS               8
         POST_OOPT_TIER_DRUG_TYPE         $6
         POST_OOPT_COSTSHARE_TYPE         $1
         POST_OOPT_COINS_PCT              8
         POST_OOPT_COPAY_AMT              8;

  format CONTRACT_ID                      $5.
         PLAN_ID                          $3.
         TIER_ID                          $2.
         GAP_TIER                         $1.
         GAP_TIER_PARTIAL                 $1.
         EXCLUDED_TIER_GAP                $1.
         EXCLUDED_TIER_PRE_ICL            $1.
         SPECIALTY_TIER                   $1.
         PRE_ICL_TIER_DRUG_TYPE           $6.
         PRE_ICL_COSTSHARE_TYPE           $1.
         PRE_ICL_INP_COINS_1M             12.2
         PRE_ICL_INP_COINS_2M             12.2
         PRE_ICL_INP_COINS_3M             12.2
         PRE_ICL_INP_COINS_AVG_1M         12.2
         PRE_ICL_INPP_COINS_1M            12.2
         PRE_ICL_INPP_COINS_2M            12.2
         PRE_ICL_INPP_COINS_3M            12.2
         PRE_ICL_INPP_COINS_AVG_1M        12.2
         PRE_ICL_INNPP_COINS_1M           12.2
         PRE_ICL_INNPP_COINS_2M           12.2
         PRE_ICL_INNPP_COINS_3M           12.2
         PRE_ICL_INNPP_COINS_AVG_1M       12.2
         PRE_ICL_OONP_COINS_1M            12.2
         PRE_ICL_OONP_COINS_OS            12.2
         PRE_ICL_MO_COINS_1M              12.2
         PRE_ICL_MO_COINS_2M              12.2
         PRE_ICL_MO_COINS_3M              12.2
         PRE_ICL_MOPP_COINS_1M            12.2
         PRE_ICL_MOPP_COINS_2M            12.2
         PRE_ICL_MOPP_COINS_3M            12.2
         PRE_ICL_MONPP_COINS_1M           12.2
         PRE_ICL_MONPP_COINS_2M           12.2
         PRE_ICL_MONPP_COINS_3M           12.2
         PRE_ICL_LTCP_COINS_B_1M          12.2
         PRE_ICL_LTCP_COINS_G_1M          12.2
         PRE_ICL_INP_COPAY_1M             12.2
         PRE_ICL_INP_COPAY_2M             12.2
         PRE_ICL_INP_COPAY_3M             12.2
         PRE_ICL_INP_COPAY_DAILY          12.2
         PRE_ICL_INPP_COPAY_1M            12.2
         PRE_ICL_INPP_COPAY_2M            12.2
         PRE_ICL_INPP_COPAY_3M            12.2
         PRE_ICL_INPP_COPAY_DAILY         12.2
         PRE_ICL_INNPP_COPAY_1M           12.2
         PRE_ICL_INNPP_COPAY_2M           12.2
         PRE_ICL_INNPP_COPAY_3M           12.2
         PRE_ICL_INNPP_COPAY_DAILY        12.2
         PRE_ICL_OONP_COPAY_1M            12.2
         PRE_ICL_OONP_COPAY_OS            12.2
         PRE_ICL_MO_COPAY_1M              12.2
         PRE_ICL_MO_COPAY_2M              12.2
         PRE_ICL_MO_COPAY_3M              12.2
         PRE_ICL_MO_COPAY_DAILY           12.2
         PRE_ICL_MOPP_COPAY_1M            12.2
         PRE_ICL_MOPP_COPAY_2M            12.2
         PRE_ICL_MOPP_COPAY_3M            12.2
         PRE_ICL_MOPP_COPAY_DAILY         12.2
         PRE_ICL_MONPP_COPAY_1M           12.2
         PRE_ICL_MONPP_COPAY_2M           12.2
         PRE_ICL_MONPP_COPAY_3M           12.2
         PRE_ICL_MONPP_COPAY_DAILY        12.2
         PRE_ICL_LTCP_COPAY_B_1M          12.2
         PRE_ICL_LTCP_COPAY_B_DAILY       12.2
         PRE_ICL_LTCP_COPAY_G_1M          12.2
         PRE_ICL_LTCP_COPAY_G_DAILY       12.2
         PRE_ICL_DAYS_INP_1M              5.
         PRE_ICL_DAYS_INP_2M              5.
         PRE_ICL_DAYS_INP_3M              5.
         PRE_ICL_DAYS_INPP_1M             5.
         PRE_ICL_DAYS_INPP_2M             5.
         PRE_ICL_DAYS_INPP_3M             5.
         PRE_ICL_DAYS_INNPP_1M            5.
         PRE_ICL_DAYS_INNPP_2M            5.
         PRE_ICL_DAYS_INNPP_3M            5.
         PRE_ICL_DAYS_OONP_1M             5.
         PRE_ICL_DAYS_OONP_OS             5.
         PRE_ICL_DAYS_MO_1M               5.
         PRE_ICL_DAYS_MO_2M               5.
         PRE_ICL_DAYS_MO_3M               5.
         PRE_ICL_DAYS_MOPP_1M             5.
         PRE_ICL_DAYS_MOPP_2M             5.
         PRE_ICL_DAYS_MOPP_3M             5.
         PRE_ICL_DAYS_MONPP_1M            5.
         PRE_ICL_DAYS_MONPP_2M            5.
         PRE_ICL_DAYS_MONPP_3M            5.
         PRE_ICL_DAYS_LTCP_B_1M           5.
         PRE_ICL_DAYS_LTCP_B_OS           5.
         PRE_ICL_DAYS_LTCP_G_1M           5.
         PRE_ICL_DAYS_LTCP_G_OS           5.
         GAP_TIER_DRUG_TYPE               $6.
         GAP_COSTSHARE_TYPE               $1.
         GAP_INP_COINS_1M                 12.2
         GAP_INP_COINS_2M                 12.2
         GAP_INP_COINS_3M                 12.2
         GAP_INP_COINS_AVG_1M             12.2
         GAP_INPP_COINS_1M                12.2
         GAP_INPP_COINS_2M                12.2
         GAP_INPP_COINS_3M                12.2
         GAP_INPP_COINS_AVG_1M            12.2
         GAP_INNPP_COINS_1M               12.2
         GAP_INNPP_COINS_2M               12.2
         GAP_INNPP_COINS_3M               12.2
         GAP_INNPP_COINS_AVG_1M           12.2
         GAP_OONP_COINS_1M                12.2
         GAP_OONP_COINS_OS                12.2
         GAP_MO_COINS_1M                  12.2
         GAP_MO_COINS_2M                  12.2
         GAP_MO_COINS_3M                  12.2
         GAP_MOPP_COINS_1M                12.2
         GAP_MOPP_COINS_2M                12.2
         GAP_MOPP_COINS_3M                12.2
         GAP_MONPP_COINS_1M               12.2
         GAP_MONPP_COINS_2M               12.2
         GAP_MONPP_COINS_3M               12.2
         GAP_LTCP_COINS_B_1M              12.2
         GAP_LTCP_COINS_G_1M              12.2
         GAP_INP_COPAY_1M                 12.2
         GAP_INP_COPAY_2M                 12.2
         GAP_INP_COPAY_3M                 12.2
         GAP_INP_COPAY_DAILY              12.2
         GAP_INPP_COPAY_1M                12.2
         GAP_INPP_COPAY_2M                12.2
         GAP_INPP_COPAY_3M                12.2
         GAP_INPP_COPAY_DAILY             12.2
         GAP_INNPP_COPAY_1M               12.2
         GAP_INNPP_COPAY_2M               12.2
         GAP_INNPP_COPAY_3M               12.2
         GAP_INNPP_COPAY_DAILY            12.2
         GAP_OONP_COPAY_1M                12.2
         GAP_OONP_COPAY_OS                12.2
         GAP_MO_COPAY_1M                  12.2
         GAP_MO_COPAY_2M                  12.2
         GAP_MO_COPAY_3M                  12.2
         GAP_MO_COPAY_DAILY               12.2
         GAP_MOPP_COPAY_1M                12.2
         GAP_MOPP_COPAY_2M                12.2
         GAP_MOPP_COPAY_3M                12.2
         GAP_MOPP_COPAY_DAILY             12.2
         GAP_MONPP_COPAY_1M               12.2
         GAP_MONPP_COPAY_2M               12.2
         GAP_MONPP_COPAY_3M               12.2
         GAP_MONPP_COPAY_DAILY            12.2
         GAP_LTCP_COPAY_B_1M              12.2
         GAP_LTCP_COPAY_B_DAILY           12.2
         GAP_LTCP_COPAY_G_1M              12.2
         GAP_LTCP_COPAY_G_DAILY           12.2
         GAP_DAYS_INP_1M                  5.
         GAP_DAYS_INP_2M                  5.
         GAP_DAYS_INP_3M                  5.
         GAP_DAYS_INPP_1M                 5.
         GAP_DAYS_INPP_2M                 5.
         GAP_DAYS_INPP_3M                 5.
         GAP_DAYS_INNPP_1M                5.
         GAP_DAYS_INNPP_2M                5.
         GAP_DAYS_INNPP_3M                5.
         GAP_DAYS_OONP_1M                 5.
         GAP_DAYS_OONP_OS                 5.
         GAP_DAYS_MO_1M                   5.
         GAP_DAYS_MO_2M                   5.
         GAP_DAYS_MO_3M                   5.
         GAP_DAYS_MOPP_1M                 5.
         GAP_DAYS_MOPP_2M                 5.
         GAP_DAYS_MOPP_3M                 5.
         GAP_DAYS_MONPP_1M                5.
         GAP_DAYS_MONPP_2M                5.
         GAP_DAYS_MONPP_3M                5.
         GAP_DAYS_LTCP_B_1M               5.
         GAP_DAYS_LTCP_B_OS               5.
         GAP_DAYS_LTCP_G_1M               5.
         GAP_DAYS_LTCP_G_OS               5.
         POST_OOPT_TIER_DRUG_TYPE         $6.
         POST_OOPT_COSTSHARE_TYPE         $1.
         POST_OOPT_COINS_PCT              12.2
         POST_OOPT_COPAY_AMT              12.2;

  label  CONTRACT_ID                      = "Contract ID"
         PLAN_ID                          = "Plan ID"
         TIER_ID                          = "Tier Number"
         GAP_TIER                         = "Indicates whether tier is covered in the gap"
         GAP_TIER_PARTIAL                 = "Indicates whether tier is partially covered in the gap"
         EXCLUDED_TIER_GAP                = "Indicates whether excluded drugs are covered on this tier in the gap phase"
         EXCLUDED_TIER_PRE_ICL            = "Indicates whether excluded drugs are covered on this tier in the Pre ICL phase"
         SPECIALTY_TIER                   = "Indicates whether tier is a specialty tier"
         PRE_ICL_TIER_DRUG_TYPE           = "Pre-ICL Tier Drug Type"
         PRE_ICL_COSTSHARE_TYPE           = "Pre-ICL Costshare Type"
         PRE_ICL_INP_COINS_1M             = "Pre-ICL Coinsurance In-Network Pharmacy - one month supply"
         PRE_ICL_INP_COINS_2M             = "Pre-ICL Coinsurance In-Network Pharmacy - two month supply"
         PRE_ICL_INP_COINS_3M             = "Pre-ICL Coinsurance In-Network Pharmacy - three month supply"
         PRE_ICL_INP_COINS_AVG_1M         = "Pre-ICL Average Expected Cost Sharing - INP Coinsurance 1M"
         PRE_ICL_INPP_COINS_1M            = "Pre-ICL Coinsurance In-Network Preferred Pharmacy - one month supply"
         PRE_ICL_INPP_COINS_2M            = "Pre-ICL Coinsurance In-Network Preferred Pharmacy - two month supply"
         PRE_ICL_INPP_COINS_3M            = "Pre-ICL Coinsurance In-Network Preferred Pharmacy - three month supply"
         PRE_ICL_INPP_COINS_AVG_1M        = "Pre-ICL Average Expected Cost Sharing - INPP Coinsurance 1M"
         PRE_ICL_INNPP_COINS_1M           = "Pre-ICL Coinsurance In-Network Non-Preferred Pharmacy - one month supply"
         PRE_ICL_INNPP_COINS_2M           = "Pre-ICL Coinsurance In-Network Non-Preferred Pharmacy - two month supply"
         PRE_ICL_INNPP_COINS_3M           = "Pre-ICL Coinsurance In-Network Non-Preferred Pharmacy - three month supply"
         PRE_ICL_INNPP_COINS_AVG_1M       = "Pre-ICL Average Expected Cost Sharing - INNPP Coinsurance 1M"
         PRE_ICL_OONP_COINS_1M            = "Pre-ICL Coinsurance Out-of-Network Pharmacy - one month supply"
         PRE_ICL_OONP_COINS_OS            = "Pre-ICL Coinsurance Out-of-Network Pharmacy - other day supply"
         PRE_ICL_MO_COINS_1M              = "Pre-ICL Coinsurance Mail Order Pharmacy - one month supply"
         PRE_ICL_MO_COINS_2M              = "Pre-ICL Coinsurance Mail Order Pharmacy - two month supply"
         PRE_ICL_MO_COINS_3M              = "Pre-ICL Coinsurance Mail Order Pharmacy - three month supply"
         PRE_ICL_MOPP_COINS_1M            = "Pre-ICL Coinsurance Mail Order Preferred Pharmacy - one month supply"
         PRE_ICL_MOPP_COINS_2M            = "Pre-ICL Coinsurance Mail Order Preferred Pharmacy - two month supply"
         PRE_ICL_MOPP_COINS_3M            = "Pre-ICL Coinsurance Mail Order Preferred Pharmacy - three month supply"
         PRE_ICL_MONPP_COINS_1M           = "Pre-ICL Coinsurance Mail Order Non-Preferred Pharmacy - one month supply"
         PRE_ICL_MONPP_COINS_2M           = "Pre-ICL Coinsurance Mail Order Non-Preferred Pharmacy - two month supply"
         PRE_ICL_MONPP_COINS_3M           = "Pre-ICL Coinsurance Mail Order Non-Preferred Pharmacy - three month supply"
         PRE_ICL_LTCP_COINS_B_1M          = "Pre-ICL Coinsurance Long Term Care Pharmacy - one month supply for a Brand"
         PRE_ICL_LTCP_COINS_G_1M          = "Pre-ICL Coinsurance Long Term Care Pharmacy - one month supply for a Generic"
         PRE_ICL_INP_COPAY_1M             = "Pre-ICL Copay In-Network Pharmacy - one month supply"
         PRE_ICL_INP_COPAY_2M             = "Pre-ICL Copay In-Network Pharmacy - two month supply"
         PRE_ICL_INP_COPAY_3M             = "Pre-ICL Copay In-Network Pharmacy - three month supply"
         PRE_ICL_INP_COPAY_DAILY          = "Pre-ICL Copay In-Network Pharmacy - one day supply"
         PRE_ICL_INPP_COPAY_1M            = "Pre-ICL Copay In-Network Preferred Pharmacy - one month supply"
         PRE_ICL_INPP_COPAY_2M            = "Pre-ICL Copay In-Network Preferred Pharmacy - two month supply"
         PRE_ICL_INPP_COPAY_3M            = "Pre-ICL Copay In-Network Preferred Pharmacy - three month supply"
         PRE_ICL_INPP_COPAY_DAILY         = "Pre-ICL Copay In-Network Preferred Pharmacy - one day supply"
         PRE_ICL_INNPP_COPAY_1M           = "Pre-ICL Copay In-Network Non-Preferred Pharmacy - one month supply"
         PRE_ICL_INNPP_COPAY_2M           = "Pre-ICL Copay In-Network Non-Preferred Pharmacy - two month supply"
         PRE_ICL_INNPP_COPAY_3M           = "Pre-ICL Copay In-Network Non-Preferred Pharmacy - three month supply"
         PRE_ICL_INNPP_COPAY_DAILY        = "Pre-ICL Copay In-Network Non-Preferred Pharmacy - one day supply"
         PRE_ICL_OONP_COPAY_1M            = "Pre-ICL Copay Out-of-Network Pharmacy - one month supply"
         PRE_ICL_OONP_COPAY_OS            = "Pre-ICL Copay Out-of-Network Pharmacy - other day supply"
         PRE_ICL_MO_COPAY_1M              = "Pre-ICL Copay Mail Order Pharmacy - one month supply"
         PRE_ICL_MO_COPAY_2M              = "Pre-ICL Copay Mail Order Pharmacy - two month supply"
         PRE_ICL_MO_COPAY_3M              = "Pre-ICL Copay Mail Order Pharmacy - three month supply"
         PRE_ICL_MO_COPAY_DAILY           = "Pre-ICL Copay Mail Order Pharmacy - one day supply"
         PRE_ICL_MOPP_COPAY_1M            = "Pre-ICL Copay Mail Order Preferred Pharmacy - one month supply"
         PRE_ICL_MOPP_COPAY_2M            = "Pre-ICL Copay Mail Order Preferred Pharmacy - two month supply"
         PRE_ICL_MOPP_COPAY_3M            = "Pre-ICL Copay Mail Order Preferred Pharmacy - three month supply"
         PRE_ICL_MOPP_COPAY_DAILY         = "Pre-ICL Copay Mail Order Preferred Pharmacy - one day supply"
         PRE_ICL_MONPP_COPAY_1M           = "Pre-ICL Copay Mail Order Non-Preferred Pharmacy - one month supply"
         PRE_ICL_MONPP_COPAY_2M           = "Pre-ICL Copay Mail Order Non-Preferred Pharmacy - two month supply"
         PRE_ICL_MONPP_COPAY_3M           = "Pre-ICL Copay Mail Order Non-Preferred Pharmacy - three month supply"
         PRE_ICL_MONPP_COPAY_DAILY        = "Pre-ICL Copay Mail Order Non-Preferred Pharmacy - one day supply"
         PRE_ICL_LTCP_COPAY_B_1M          = "Pre_ICL Copay Long Term Care Pharmacy - one month supply for a Brand"
         PRE_ICL_LTCP_COPAY_B_DAILY       = "Pre_ICL Copay Long Term Care Pharmacy - one day supply for a Brand"
         PRE_ICL_LTCP_COPAY_G_1M          = "Pre_ICL Copay Long Term Care Pharmacy - one month supply for a Generic"
         PRE_ICL_LTCP_COPAY_G_DAILY       = "Pre_ICL Copay Long Term Care Pharmacy - one day supply for a Generic"
         PRE_ICL_DAYS_INP_1M              = "Pre-ICL In-Network Pharmacy - number of days in one month supply"
         PRE_ICL_DAYS_INP_2M              = "Pre-ICL In-Network Pharmacy - number of days in two month supply"
         PRE_ICL_DAYS_INP_3M              = "Pre-ICL In-Network Pharmacy - number of days in three month supply"
         PRE_ICL_DAYS_INPP_1M             = "Pre-ICL In-Network Preferred Pharmacy - number of days in one month supply"
         PRE_ICL_DAYS_INPP_2M             = "Pre-ICL In-Network Preferred Pharmacy - number of days in two month supply"
         PRE_ICL_DAYS_INPP_3M             = "Pre-ICL In-Network Preferred Pharmacy - number of days in three month supply"
         PRE_ICL_DAYS_INNPP_1M            = "Pre-ICL In-Network Non-Preferred Pharmacy - number of days in one month supply"
         PRE_ICL_DAYS_INNPP_2M            = "Pre-ICL In-Network Non-Preferred Pharmacy - number of days in two month supply"
         PRE_ICL_DAYS_INNPP_3M            = "Pre-ICL In-Network Non-Preferred Pharmacy - number of days in three month supply"
         PRE_ICL_DAYS_OONP_1M             = "Pre-ICL Out-of-Network Pharmacy - number of days in one month supply"
         PRE_ICL_DAYS_OONP_OS             = "Pre-ICL Out-of-Network Pharmacy - number of days in other day supply"
         PRE_ICL_DAYS_MO_1M               = "Pre-ICL Mail Order Pharmacy - number of days in one month supply"
         PRE_ICL_DAYS_MO_2M               = "Pre-ICL Mail Order Pharmacy - number of days in two month supply"
         PRE_ICL_DAYS_MO_3M               = "Pre-ICL Mail Order Pharmacy - number of days in three month supply"
         PRE_ICL_DAYS_MOPP_1M             = "Pre-ICL Mail Order Preferred Pharmacy - number of days in one month supply"
         PRE_ICL_DAYS_MOPP_2M             = "Pre-ICL Mail Order Preferred Pharmacy - number of days in two month supply"
         PRE_ICL_DAYS_MOPP_3M             = "Pre-ICL Mail Order Preferred Pharmacy - number of days in three month supply"
         PRE_ICL_DAYS_MONPP_1M            = "Pre-ICL Mail Order Non-Preferred Pharmacy - number of days in one month supply"
         PRE_ICL_DAYS_MONPP_2M            = "Pre-ICL Mail Order Non-Preferred Pharmacy - number of days in two month supply"
         PRE_ICL_DAYS_MONPP_3M            = "Pre-ICL Mail Order Non-Preferred Pharmacy - number of days in three month supply"
         PRE_ICL_DAYS_LTCP_B_1M           = "Pre-ICL Long Term Care Pharmacy - number of days in a one month supply for a Brand"
         PRE_ICL_DAYS_LTCP_B_OS           = "Pre-ICL Long Term Care Pharmacy - number of days in an other day supply for a Brand"
         PRE_ICL_DAYS_LTCP_G_1M           = "Pre-ICL Long Term Care Pharmacy - number of days in a one month supply for a Generic"
         PRE_ICL_DAYS_LTCP_G_OS           = "Pre-ICL Long Term Care Pharmacy - number of days in an other day supply for a Generic"
         GAP_TIER_DRUG_TYPE               = "Gap Tier Drug Type"
         GAP_COSTSHARE_TYPE               = "Gap Cost Share Type"
         GAP_INP_COINS_1M                 = "Gap Coinsurance In-Network Pharmacy - one month supply"
         GAP_INP_COINS_2M                 = "Gap Coinsurance In-Network Pharmacy - two month supply"
         GAP_INP_COINS_3M                 = "Gap Coinsurance In-Network Pharmacy - three month supply"
         GAP_INP_COINS_AVG_1M             = "Gap Average Expected Cost Sharing - INP Coinsurance 1M"
         GAP_INPP_COINS_1M                = "Gap Coinsurance In-Network Preferred Pharmacy - one month supply"
         GAP_INPP_COINS_2M                = "Gap Coinsurance In-Network Preferred Pharmacy - two month supply"
         GAP_INPP_COINS_3M                = "Gap Coinsurance In-Network Preferred Pharmacy - three month supply"
         GAP_INPP_COINS_AVG_1M            = "Gap Average Expected Cost Sharing - INPP Coinsurance 1M"
         GAP_INNPP_COINS_1M               = "Gap Coinsurance In-Network Non-Preferred Pharmacy - one month supply"
         GAP_INNPP_COINS_2M               = "Gap Coinsurance In-Network Non-Preferred Pharmacy - two month supply"
         GAP_INNPP_COINS_3M               = "Gap Coinsurance In-Network Non-Preferred Pharmacy - three month supply"
         GAP_INNPP_COINS_AVG_1M           = "Gap Average Expected Cost Sharing - INNPP Coinsurance 1M"
         GAP_OONP_COINS_1M                = "Gap Coinsurance Out-of-Network Pharmacy - one month supply"
         GAP_OONP_COINS_OS                = "Gap Coinsurance Out-of-Network Pharmacy - other day supply"
         GAP_MO_COINS_1M                  = "Gap Coinsurance Mail Order Pharmacy - one month supply"
         GAP_MO_COINS_2M                  = "Gap Coinsurance Mail Order Pharmacy - two month supply"
         GAP_MO_COINS_3M                  = "Gap Coinsurance Mail Order Pharmacy - three month supply"
         GAP_MOPP_COINS_1M                = "Gap Coinsurance Mail Order Preferred Pharmacy - one month supply"
         GAP_MOPP_COINS_2M                = "Gap Coinsurance Mail Order Preferred Pharmacy - two month supply"
         GAP_MOPP_COINS_3M                = "Gap Coinsurance Mail Order Preferred Pharmacy - three month supply"
         GAP_MONPP_COINS_1M               = "Gap Coinsurance Mail Order Non-Preferred Pharmacy - one month supply"
         GAP_MONPP_COINS_2M               = "Gap Coinsurance Mail Order Non-Preferred Pharmacy - two month supply"
         GAP_MONPP_COINS_3M               = "Gap Coinsurance Mail Order Non-Preferred Pharmacy - three month supply"
         GAP_LTCP_COINS_B_1M              = "Gap Coinsurance Long Term Care Pharmacy - one month supply for a Brand"
         GAP_LTCP_COINS_G_1M              = "Gap Coinsurance Long Term Care Pharmacy - one month supply for a Generic"
         GAP_INP_COPAY_1M                 = "Gap Copay In-Network Pharmacy - one month supply"
         GAP_INP_COPAY_2M                 = "Gap Copay In-Network Pharmacy - two month supply"
         GAP_INP_COPAY_3M                 = "Gap Copay In-Network Pharmacy - three month supply"
         GAP_INP_COPAY_DAILY              = "Gap Copay In-Network Pharmacy - one day supply"
         GAP_INPP_COPAY_1M                = "Gap Copay In-Network Preferred Pharmacy - one month supply"
         GAP_INPP_COPAY_2M                = "Gap Copay In-Network Preferred Pharmacy - two month supply"
         GAP_INPP_COPAY_3M                = "Gap Copay In-Network Preferred Pharmacy - three month supply"
         GAP_INPP_COPAY_DAILY             = "Gap Copay In-Network Preferred Pharmacy - one day supply"
         GAP_INNPP_COPAY_1M               = "Gap Copay In-Network Non-Preferred Pharmacy - one month supply"
         GAP_INNPP_COPAY_2M               = "Gap Copay In-Network Non-Preferred Pharmacy - two month supply"
         GAP_INNPP_COPAY_3M               = "Gap Copay In-Network Non-Preferred Pharmacy - three month supply"
         GAP_INNPP_COPAY_DAILY            = "Gap Copay In-Network Non-Preferred Pharmacy - one day supply"
         GAP_OONP_COPAY_1M                = "Gap Copay Out-of-Network Pharmacy - one month supply"
         GAP_OONP_COPAY_OS                = "Gap Copay Out-of-Network Pharmacy - other day supply"
         GAP_MO_COPAY_1M                  = "Gap Copay Mail Order Pharmacy - one month supply"
         GAP_MO_COPAY_2M                  = "Gap Copay Mail Order Pharmacy - two month supply"
         GAP_MO_COPAY_3M                  = "Gap Copay Mail Order Pharmacy - three month supply"
         GAP_MO_COPAY_DAILY               = "Gap Copay Mail Order Pharmacy - one day supply"
         GAP_MOPP_COPAY_1M                = "Gap Copay Mail Order Preferred Pharmacy - one month supply"
         GAP_MOPP_COPAY_2M                = "Gap Copay Mail Order Preferred Pharmacy - two month supply"
         GAP_MOPP_COPAY_3M                = "Gap Copay Mail Order Preferred Pharmacy - three month supply"
         GAP_MOPP_COPAY_DAILY             = "Gap Copay Mail Order Preferred Pharmacy - one day supply"
         GAP_MONPP_COPAY_1M               = "Gap Copay Mail Order Non-Preferred Pharmacy - one month supply"
         GAP_MONPP_COPAY_2M               = "Gap Copay Mail Order Non-Preferred Pharmacy - two month supply"
         GAP_MONPP_COPAY_3M               = "Gap Copay Mail Order Non-Preferred Pharmacy - three month supply"
         GAP_MONPP_COPAY_DAILY            = "Gap Copay Mail Order Non-Preferred Pharmacy - one day supply"
         GAP_LTCP_COPAY_B_1M              = "Gap Copay Long Term Care Pharmacy - one month supply for a Brand"
         GAP_LTCP_COPAY_B_DAILY           = "Gap Copay Long Term Care Pharmacy - one day supply for a Brand"
         GAP_LTCP_COPAY_G_1M              = "Gap Copay Long Term Care Pharmacy - one month supply for a Generic"
         GAP_LTCP_COPAY_G_DAILY           = "Gap Copay Long Term Care Pharmacy - one day supply for a Generic"
         GAP_DAYS_INP_1M                  = "Gap In-Network Pharmacy - number of days in one month supply"
         GAP_DAYS_INP_2M                  = "Gap In-Network Pharmacy - number of days in two month supply"
         GAP_DAYS_INP_3M                  = "Gap In-Network Pharmacy - number of days in three month supply"
         GAP_DAYS_INPP_1M                 = "Gap In-Network Preferred Pharmacy - number of days in one month supply"
         GAP_DAYS_INPP_2M                 = "Gap In-Network Preferred Pharmacy - number of days in two month supply"
         GAP_DAYS_INPP_3M                 = "Gap In-Network Preferred Pharmacy - number of days in three month supply"
         GAP_DAYS_INNPP_1M                = "Gap In-Network Non-Preferred Pharmacy - number of days in one month supply"
         GAP_DAYS_INNPP_2M                = "Gap In-Network Non-Preferred Pharmacy - number of days in two month supply"
         GAP_DAYS_INNPP_3M                = "Gap In-Network Non-Preferred Pharmacy - number of days in three month supply"
         GAP_DAYS_OONP_1M                 = "Gap Out-of-Network Pharmacy - number of days in one month supply"
         GAP_DAYS_OONP_OS                 = "Gap Out-of-Network Pharmacy - number of days in other day supply"
         GAP_DAYS_MO_1M                   = "Gap Mail Order Pharmacy - number of days in one month supply"
         GAP_DAYS_MO_2M                   = "Gap Mail Order Pharmacy - number of days in two month supply"
         GAP_DAYS_MO_3M                   = "Gap Mail Order Pharmacy - number of days in three month supply"
         GAP_DAYS_MOPP_1M                 = "Gap Mail Order Preferred Pharmacy - number of days in one month supply"
         GAP_DAYS_MOPP_2M                 = "Gap Mail Order Preferred Pharmacy - number of days in two month supply"
         GAP_DAYS_MOPP_3M                 = "Gap Mail Order Preferred Pharmacy - number of days in three month supply"
         GAP_DAYS_MONPP_1M                = "Gap Mail Order Non-Preferred Pharmacy - number of days in one month supply"
         GAP_DAYS_MONPP_2M                = "Gap Mail Order Non-Preferred Pharmacy - number of days in two month supply"
         GAP_DAYS_MONPP_3M                = "Gap Mail Order Non-Preferred Pharmacy - number of days in three month supply"
         GAP_DAYS_LTCP_B_1M               = "Gap Long Term Care Pharmacy - number of days in a one month supply for a Brand"
         GAP_DAYS_LTCP_B_OS               = "Gap Long Term Care Pharmacy - number of days in an other day supply for a Brand"
         GAP_DAYS_LTCP_G_1M               = "Gap Long Term Care Pharmacy - number of days in a one month supply for a Generic"
         GAP_DAYS_LTCP_G_OS               = "Gap Long Term Care Pharmacy - number of days in an other day supply for a Generic"
         POST_OOPT_TIER_DRUG_TYPE         = "Post-Out-of-pocket threshold tier drug type"
         POST_OOPT_COSTSHARE_TYPE         = "Post-Out-of-pocket threshold costshare type"
         POST_OOPT_COINS_PCT              = "Post-Out-of-pocket threshold Coinsurance"
         POST_OOPT_COPAY_AMT              = "Post-Out-of-pocket threshold Copay";

  infile in missover truncover;

  input @0001  CONTRACT_ID                      $5.
        @0006  PLAN_ID                          $3.
        @0009  TIER_ID                          $2.
        @0011  GAP_TIER                         $1.
        @0012  GAP_TIER_PARTIAL                 $1.
        @0013  EXCLUDED_TIER_GAP                $1.
        @0014  EXCLUDED_TIER_PRE_ICL            $1.
        @0015  SPECIALTY_TIER                   $1.
        @0016  PRE_ICL_TIER_DRUG_TYPE           $6.
        @0022  PRE_ICL_COSTSHARE_TYPE           $1.
        @0023  PRE_ICL_INP_COINS_1M             12.2
        @0035  PRE_ICL_INP_COINS_2M             12.2
        @0047  PRE_ICL_INP_COINS_3M             12.2
        @0059  PRE_ICL_INP_COINS_AVG_1M         12.2
        @0071  PRE_ICL_INPP_COINS_1M            12.2
        @0083  PRE_ICL_INPP_COINS_2M            12.2
        @0095  PRE_ICL_INPP_COINS_3M            12.2
        @0107  PRE_ICL_INPP_COINS_AVG_1M        12.2
        @0119  PRE_ICL_INNPP_COINS_1M           12.2
        @0131  PRE_ICL_INNPP_COINS_2M           12.2
        @0143  PRE_ICL_INNPP_COINS_3M           12.2
        @0155  PRE_ICL_INNPP_COINS_AVG_1M       12.2
        @0167  PRE_ICL_OONP_COINS_1M            12.2
        @0179  PRE_ICL_OONP_COINS_OS            12.2
        @0191  PRE_ICL_MO_COINS_1M              12.2
        @0203  PRE_ICL_MO_COINS_2M              12.2
        @0215  PRE_ICL_MO_COINS_3M              12.2
        @0227  PRE_ICL_MOPP_COINS_1M            12.2
        @0239  PRE_ICL_MOPP_COINS_2M            12.2
        @0251  PRE_ICL_MOPP_COINS_3M            12.2
        @0263  PRE_ICL_MONPP_COINS_1M           12.2
        @0275  PRE_ICL_MONPP_COINS_2M           12.2
        @0287  PRE_ICL_MONPP_COINS_3M           12.2
        @0299  PRE_ICL_LTCP_COINS_B_1M          12.2
        @0311  PRE_ICL_LTCP_COINS_G_1M          12.2
        @0323  PRE_ICL_INP_COPAY_1M             12.2
        @0335  PRE_ICL_INP_COPAY_2M             12.2
        @0347  PRE_ICL_INP_COPAY_3M             12.2
        @0359  PRE_ICL_INP_COPAY_DAILY          12.2
        @0371  PRE_ICL_INPP_COPAY_1M            12.2
        @0383  PRE_ICL_INPP_COPAY_2M            12.2
        @0395  PRE_ICL_INPP_COPAY_3M            12.2
        @0407  PRE_ICL_INPP_COPAY_DAILY         12.2
        @0419  PRE_ICL_INNPP_COPAY_1M           12.2
        @0431  PRE_ICL_INNPP_COPAY_2M           12.2
        @0443  PRE_ICL_INNPP_COPAY_3M           12.2
        @0455  PRE_ICL_INNPP_COPAY_DAILY        12.2
        @0467  PRE_ICL_OONP_COPAY_1M            12.2
        @0479  PRE_ICL_OONP_COPAY_OS            12.2
        @0491  PRE_ICL_MO_COPAY_1M              12.2
        @0503  PRE_ICL_MO_COPAY_2M              12.2
        @0515  PRE_ICL_MO_COPAY_3M              12.2
        @0527  PRE_ICL_MO_COPAY_DAILY           12.2
        @0539  PRE_ICL_MOPP_COPAY_1M            12.2
        @0551  PRE_ICL_MOPP_COPAY_2M            12.2
        @0563  PRE_ICL_MOPP_COPAY_3M            12.2
        @0575  PRE_ICL_MOPP_COPAY_DAILY         12.2
        @0587  PRE_ICL_MONPP_COPAY_1M           12.2
        @0599  PRE_ICL_MONPP_COPAY_2M           12.2
        @0611  PRE_ICL_MONPP_COPAY_3M           12.2
        @0623  PRE_ICL_MONPP_COPAY_DAILY        12.2
        @0635  PRE_ICL_LTCP_COPAY_B_1M          12.2
        @0647  PRE_ICL_LTCP_COPAY_B_DAILY       12.2
        @0659  PRE_ICL_LTCP_COPAY_G_1M          12.2
        @0671  PRE_ICL_LTCP_COPAY_G_DAILY       12.2
        @0683  PRE_ICL_DAYS_INP_1M              5.
        @0688  PRE_ICL_DAYS_INP_2M              5.
        @0693  PRE_ICL_DAYS_INP_3M              5.
        @0698  PRE_ICL_DAYS_INPP_1M             5.
        @0703  PRE_ICL_DAYS_INPP_2M             5.
        @0708  PRE_ICL_DAYS_INPP_3M             5.
        @0713  PRE_ICL_DAYS_INNPP_1M            5.
        @0718  PRE_ICL_DAYS_INNPP_2M            5.
        @0723  PRE_ICL_DAYS_INNPP_3M            5.
        @0728  PRE_ICL_DAYS_OONP_1M             5.
        @0733  PRE_ICL_DAYS_OONP_OS             5.
        @0738  PRE_ICL_DAYS_MO_1M               5.
        @0743  PRE_ICL_DAYS_MO_2M               5.
        @0748  PRE_ICL_DAYS_MO_3M               5.
        @0753  PRE_ICL_DAYS_MOPP_1M             5.
        @0758  PRE_ICL_DAYS_MOPP_2M             5.
        @0763  PRE_ICL_DAYS_MOPP_3M             5.
        @0768  PRE_ICL_DAYS_MONPP_1M            5.
        @0773  PRE_ICL_DAYS_MONPP_2M            5.
        @0778  PRE_ICL_DAYS_MONPP_3M            5.
        @0783  PRE_ICL_DAYS_LTCP_B_1M           5.
        @0788  PRE_ICL_DAYS_LTCP_B_OS           5.
        @0793  PRE_ICL_DAYS_LTCP_G_1M           5.
        @0798  PRE_ICL_DAYS_LTCP_G_OS           5.
        @0803  GAP_TIER_DRUG_TYPE               $6.
        @0809  GAP_COSTSHARE_TYPE               $1.
        @0810  GAP_INP_COINS_1M                 12.2
        @0822  GAP_INP_COINS_2M                 12.2
        @0834  GAP_INP_COINS_3M                 12.2
        @0846  GAP_INP_COINS_AVG_1M             12.2
        @0858  GAP_INPP_COINS_1M                12.2
        @0870  GAP_INPP_COINS_2M                12.2
        @0882  GAP_INPP_COINS_3M                12.2
        @0894  GAP_INPP_COINS_AVG_1M            12.2
        @0906  GAP_INNPP_COINS_1M               12.2
        @0918  GAP_INNPP_COINS_2M               12.2
        @0930  GAP_INNPP_COINS_3M               12.2
        @0942  GAP_INNPP_COINS_AVG_1M           12.2
        @0954  GAP_OONP_COINS_1M                12.2
        @0966  GAP_OONP_COINS_OS                12.2
        @0978  GAP_MO_COINS_1M                  12.2
        @0990  GAP_MO_COINS_2M                  12.2
        @1002  GAP_MO_COINS_3M                  12.2
        @1014  GAP_MOPP_COINS_1M                12.2
        @1026  GAP_MOPP_COINS_2M                12.2
        @1038  GAP_MOPP_COINS_3M                12.2
        @1050  GAP_MONPP_COINS_1M               12.2
        @1062  GAP_MONPP_COINS_2M               12.2
        @1074  GAP_MONPP_COINS_3M               12.2
        @1086  GAP_LTCP_COINS_B_1M              12.2
        @1098  GAP_LTCP_COINS_G_1M              12.2
        @1110  GAP_INP_COPAY_1M                 12.2
        @1122  GAP_INP_COPAY_2M                 12.2
        @1134  GAP_INP_COPAY_3M                 12.2
        @1146  GAP_INP_COPAY_DAILY              12.2
        @1158  GAP_INPP_COPAY_1M                12.2
        @1170  GAP_INPP_COPAY_2M                12.2
        @1182  GAP_INPP_COPAY_3M                12.2
        @1194  GAP_INPP_COPAY_DAILY             12.2
        @1206  GAP_INNPP_COPAY_1M               12.2
        @1218  GAP_INNPP_COPAY_2M               12.2
        @1230  GAP_INNPP_COPAY_3M               12.2
        @1242  GAP_INNPP_COPAY_DAILY            12.2
        @1254  GAP_OONP_COPAY_1M                12.2
        @1266  GAP_OONP_COPAY_OS                12.2
        @1278  GAP_MO_COPAY_1M                  12.2
        @1290  GAP_MO_COPAY_2M                  12.2
        @1302  GAP_MO_COPAY_3M                  12.2
        @1314  GAP_MO_COPAY_DAILY               12.2
        @1326  GAP_MOPP_COPAY_1M                12.2
        @1338  GAP_MOPP_COPAY_2M                12.2
        @1350  GAP_MOPP_COPAY_3M                12.2
        @1362  GAP_MOPP_COPAY_DAILY             12.2
        @1374  GAP_MONPP_COPAY_1M               12.2
        @1386  GAP_MONPP_COPAY_2M               12.2
        @1398  GAP_MONPP_COPAY_3M               12.2
        @1410  GAP_MONPP_COPAY_DAILY            12.2
        @1422  GAP_LTCP_COPAY_B_1M              12.2
        @1434  GAP_LTCP_COPAY_B_DAILY           12.2
        @1446  GAP_LTCP_COPAY_G_1M              12.2
        @1458  GAP_LTCP_COPAY_G_DAILY           12.2
        @1470  GAP_DAYS_INP_1M                  5.
        @1475  GAP_DAYS_INP_2M                  5.
        @1480  GAP_DAYS_INP_3M                  5.
        @1485  GAP_DAYS_INPP_1M                 5.
        @1490  GAP_DAYS_INPP_2M                 5.
        @1495  GAP_DAYS_INPP_3M                 5.
        @1500  GAP_DAYS_INNPP_1M                5.
        @1505  GAP_DAYS_INNPP_2M                5.
        @1510  GAP_DAYS_INNPP_3M                5.
        @1515  GAP_DAYS_OONP_1M                 5.
        @1520  GAP_DAYS_OONP_OS                 5.
        @1525  GAP_DAYS_MO_1M                   5.
        @1530  GAP_DAYS_MO_2M                   5.
        @1535  GAP_DAYS_MO_3M                   5.
        @1540  GAP_DAYS_MOPP_1M                 5.
        @1545  GAP_DAYS_MOPP_2M                 5.
        @1550  GAP_DAYS_MOPP_3M                 5.
        @1555  GAP_DAYS_MONPP_1M                5.
        @1560  GAP_DAYS_MONPP_2M                5.
        @1565  GAP_DAYS_MONPP_3M                5.
        @1570  GAP_DAYS_LTCP_B_1M               5.
        @1575  GAP_DAYS_LTCP_B_OS               5.
        @1580  GAP_DAYS_LTCP_G_1M               5.
        @1585  GAP_DAYS_LTCP_G_OS               5.
        @1590  POST_OOPT_TIER_DRUG_TYPE         $6.
        @1596  POST_OOPT_COSTSHARE_TYPE         $1.
        @1597  POST_OOPT_COINS_PCT              12.2
        @1609  POST_OOPT_COPAY_AMT              12.2;
run;

title 'Part D Tier Characteristics 2013';
proc contents data=out.TIER_2013 varnum;
proc print data=out.TIER_2013(obs=5);
  title2 'Sample Listing - First 5 Rows';
run;
proc means data=out.TIER_2013;
  title2 'Simple Means';
run;

proc freq data=out.TIER_2013;
  title2 'Freqs';
  table EXCLUDED_TIER_GAP
        EXCLUDED_TIER_PRE_ICL
        GAP_COSTSHARE_TYPE
        GAP_TIER
        GAP_TIER_PARTIAL
        POST_OOPT_COSTSHARE_TYPE
        PRE_ICL_COSTSHARE_TYPE
        SPECIALTY_TIER
        TIER_ID/missing;
run;

* End of Program *;
