* SAS Read-In Program
*
* Name: tier_2020_readin.sas
*
* Purpose: Read-In the delimited flat file TIER_2020.
*
* Delimiter: Fixed Column
*
* Date: 14SEP21   Time: 13:37
*
* Help: cmsdata@gdit.com, 1-866-766-1915
*
*;

filename in  'tier_2020.dat'  lrecl=32768;
libname  ccw '.';

data ccw.TIER_2020;
  length CONTRACT_ID                      $5
         PLAN_ID                          $3
         TIER_ID                          $2
         GAP_TIER                         $1
         GAP_TIER_PARTIAL                 $1
         EXCLUDED_TIER_GAP                $1
         EXCLUDED_TIER_PRE_ICL            $1
         SPECIALTY_TIER                   $1
         PRE_ICL_TIER_DRUG_TYPE           $2
         PRE_ICL_COSTSHARE_TYPE           $1
         PRE_ICL_INP_COINS_1M             8
         PRE_ICL_INP_COINS_2M             8
         PRE_ICL_INP_COINS_3M             8
         PRE_ICL_INP_COINS_AVG_1M         8
         PRE_ICL_INPP_COINS_1M            8
         PRE_ICL_INPP_COINS_2M            8
         PRE_ICL_INPP_COINS_3M            8
         PRE_ICL_INPP_COINS_AVG_1M        8
         PRE_ICL_INNPP_COINS_1M           8
         PRE_ICL_INNPP_COINS_2M           8
         PRE_ICL_INNPP_COINS_3M           8
         PRE_ICL_INNPP_COINS_AVG_1M       8
         PRE_ICL_OONP_COINS_1M            8
         PRE_ICL_OONP_COINS_OS            8
         PRE_ICL_MO_COINS_1M              8
         PRE_ICL_MO_COINS_2M              8
         PRE_ICL_MO_COINS_3M              8
         PRE_ICL_MOPP_COINS_1M            8
         PRE_ICL_MOPP_COINS_2M            8
         PRE_ICL_MOPP_COINS_3M            8
         PRE_ICL_MONPP_COINS_1M           8
         PRE_ICL_MONPP_COINS_2M           8
         PRE_ICL_MONPP_COINS_3M           8
         PRE_ICL_LTCP_COINS_1M            8
         PRE_ICL_INP_COPAY_1M             8
         PRE_ICL_INP_COPAY_2M             8
         PRE_ICL_INP_COPAY_3M             8
         PRE_ICL_INP_COPAY_DAILY          8
         PRE_ICL_INPP_COPAY_1M            8
         PRE_ICL_INPP_COPAY_2M            8
         PRE_ICL_INPP_COPAY_3M            8
         PRE_ICL_INPP_COPAY_DAILY         8
         PRE_ICL_INNPP_COPAY_1M           8
         PRE_ICL_INNPP_COPAY_2M           8
         PRE_ICL_INNPP_COPAY_3M           8
         PRE_ICL_INNPP_COPAY_DAILY        8
         PRE_ICL_OONP_COPAY_1M            8
         PRE_ICL_OONP_COPAY_OS            8
         PRE_ICL_MO_COPAY_1M              8
         PRE_ICL_MO_COPAY_2M              8
         PRE_ICL_MO_COPAY_3M              8
         PRE_ICL_MO_COPAY_DAILY           8
         PRE_ICL_MOPP_COPAY_1M            8
         PRE_ICL_MOPP_COPAY_2M            8
         PRE_ICL_MOPP_COPAY_3M            8
         PRE_ICL_MOPP_COPAY_DAILY         8
         PRE_ICL_MONPP_COPAY_1M           8
         PRE_ICL_MONPP_COPAY_2M           8
         PRE_ICL_MONPP_COPAY_3M           8
         PRE_ICL_MONPP_COPAY_DAILY        8
         PRE_ICL_LTCP_COPAY_1M            8
         PRE_ICL_LTCP_COPAY_DAILY         8
         PRE_ICL_DAYS_INP_1M              8
         PRE_ICL_DAYS_INP_2M              8
         PRE_ICL_DAYS_INP_3M              8
         PRE_ICL_DAYS_INPP_1M             8
         PRE_ICL_DAYS_INPP_2M             8
         PRE_ICL_DAYS_INPP_3M             8
         PRE_ICL_DAYS_INNPP_1M            8
         PRE_ICL_DAYS_INNPP_2M            8
         PRE_ICL_DAYS_INNPP_3M            8
         PRE_ICL_DAYS_OONP_1M             8
         PRE_ICL_DAYS_OONP_OS             8
         PRE_ICL_DAYS_MO_1M               8
         PRE_ICL_DAYS_MO_2M               8
         PRE_ICL_DAYS_MO_3M               8
         PRE_ICL_DAYS_MOPP_1M             8
         PRE_ICL_DAYS_MOPP_2M             8
         PRE_ICL_DAYS_MOPP_3M             8
         PRE_ICL_DAYS_MONPP_1M            8
         PRE_ICL_DAYS_MONPP_2M            8
         PRE_ICL_DAYS_MONPP_3M            8
         PRE_ICL_DAYS_LTCP_1M             8
         GAP_TIER_DRUG_TYPE               $2
         GAP_COSTSHARE_TYPE               $1
         GAP_INP_COINS_1M                 8
         GAP_INP_COINS_2M                 8
         GAP_INP_COINS_3M                 8
         GAP_INP_COINS_AVG_1M             8
         GAP_INPP_COINS_1M                8
         GAP_INPP_COINS_2M                8
         GAP_INPP_COINS_3M                8
         GAP_INPP_COINS_AVG_1M            8
         GAP_INNPP_COINS_1M               8
         GAP_INNPP_COINS_2M               8
         GAP_INNPP_COINS_3M               8
         GAP_INNPP_COINS_AVG_1M           8
         GAP_OONP_COINS_1M                8
         GAP_OONP_COINS_OS                8
         GAP_MO_COINS_1M                  8
         GAP_MO_COINS_2M                  8
         GAP_MO_COINS_3M                  8
         GAP_MOPP_COINS_1M                8
         GAP_MOPP_COINS_2M                8
         GAP_MOPP_COINS_3M                8
         GAP_MONPP_COINS_1M               8
         GAP_MONPP_COINS_2M               8
         GAP_MONPP_COINS_3M               8
         GAP_LTCP_COINS_1M                8
         GAP_INP_COPAY_1M                 8
         GAP_INP_COPAY_2M                 8
         GAP_INP_COPAY_3M                 8
         GAP_INP_COPAY_DAILY              8
         GAP_INPP_COPAY_1M                8
         GAP_INPP_COPAY_2M                8
         GAP_INPP_COPAY_3M                8
         GAP_INPP_COPAY_DAILY             8
         GAP_INNPP_COPAY_1M               8
         GAP_INNPP_COPAY_2M               8
         GAP_INNPP_COPAY_3M               8
         GAP_INNPP_COPAY_DAILY            8
         GAP_OONP_COPAY_1M                8
         GAP_OONP_COPAY_OS                8
         GAP_MO_COPAY_1M                  8
         GAP_MO_COPAY_2M                  8
         GAP_MO_COPAY_3M                  8
         GAP_MO_COPAY_DAILY               8
         GAP_MOPP_COPAY_1M                8
         GAP_MOPP_COPAY_2M                8
         GAP_MOPP_COPAY_3M                8
         GAP_MOPP_COPAY_DAILY             8
         GAP_MONPP_COPAY_1M               8
         GAP_MONPP_COPAY_2M               8
         GAP_MONPP_COPAY_3M               8
         GAP_MONPP_COPAY_DAILY            8
         GAP_LTCP_COPAY_1M                8
         GAP_LTCP_COPAY_DAILY             8
         GAP_DAYS_INP_1M                  8
         GAP_DAYS_INP_2M                  8
         GAP_DAYS_INP_3M                  8
         GAP_DAYS_INPP_1M                 8
         GAP_DAYS_INPP_2M                 8
         GAP_DAYS_INPP_3M                 8
         GAP_DAYS_INNPP_1M                8
         GAP_DAYS_INNPP_2M                8
         GAP_DAYS_INNPP_3M                8
         GAP_DAYS_OONP_1M                 8
         GAP_DAYS_OONP_OS                 8
         GAP_DAYS_MO_1M                   8
         GAP_DAYS_MO_2M                   8
         GAP_DAYS_MO_3M                   8
         GAP_DAYS_MOPP_1M                 8
         GAP_DAYS_MOPP_2M                 8
         GAP_DAYS_MOPP_3M                 8
         GAP_DAYS_MONPP_1M                8
         GAP_DAYS_MONPP_2M                8
         GAP_DAYS_MONPP_3M                8
         GAP_DAYS_LTCP_1M                 8
         POST_OOPT_TIER_DRUG_TYPE         $2
         POST_OOPT_COSTSHARE_TYPE         $1
         POST_OOPT_COINS_PCT              8
         POST_OOPT_COPAY_AMT              8;

  format PRE_ICL_INP_COINS_1M             12.2
         PRE_ICL_INP_COINS_2M             12.2
         PRE_ICL_INP_COINS_3M             12.2
         PRE_ICL_INP_COINS_AVG_1M         12.2
         PRE_ICL_INPP_COINS_1M            12.2
         PRE_ICL_INPP_COINS_2M            12.2
         PRE_ICL_INPP_COINS_3M            12.2
         PRE_ICL_INPP_COINS_AVG_1M        12.2
         PRE_ICL_INNPP_COINS_1M           12.2
         PRE_ICL_INNPP_COINS_2M           12.2
         PRE_ICL_INNPP_COINS_3M           12.2
         PRE_ICL_INNPP_COINS_AVG_1M       12.2
         PRE_ICL_OONP_COINS_1M            12.2
         PRE_ICL_OONP_COINS_OS            12.2
         PRE_ICL_MO_COINS_1M              12.2
         PRE_ICL_MO_COINS_2M              12.2
         PRE_ICL_MO_COINS_3M              12.2
         PRE_ICL_MOPP_COINS_1M            12.2
         PRE_ICL_MOPP_COINS_2M            12.2
         PRE_ICL_MOPP_COINS_3M            12.2
         PRE_ICL_MONPP_COINS_1M           12.2
         PRE_ICL_MONPP_COINS_2M           12.2
         PRE_ICL_MONPP_COINS_3M           12.2
         PRE_ICL_LTCP_COINS_1M            12.2
         PRE_ICL_INP_COPAY_1M             12.2
         PRE_ICL_INP_COPAY_2M             12.2
         PRE_ICL_INP_COPAY_3M             12.2
         PRE_ICL_INP_COPAY_DAILY          12.2
         PRE_ICL_INPP_COPAY_1M            12.2
         PRE_ICL_INPP_COPAY_2M            12.2
         PRE_ICL_INPP_COPAY_3M            12.2
         PRE_ICL_INPP_COPAY_DAILY         12.2
         PRE_ICL_INNPP_COPAY_1M           12.2
         PRE_ICL_INNPP_COPAY_2M           12.2
         PRE_ICL_INNPP_COPAY_3M           12.2
         PRE_ICL_INNPP_COPAY_DAILY        12.2
         PRE_ICL_OONP_COPAY_1M            12.2
         PRE_ICL_OONP_COPAY_OS            12.2
         PRE_ICL_MO_COPAY_1M              12.2
         PRE_ICL_MO_COPAY_2M              12.2
         PRE_ICL_MO_COPAY_3M              12.2
         PRE_ICL_MO_COPAY_DAILY           12.2
         PRE_ICL_MOPP_COPAY_1M            12.2
         PRE_ICL_MOPP_COPAY_2M            12.2
         PRE_ICL_MOPP_COPAY_3M            12.2
         PRE_ICL_MOPP_COPAY_DAILY         12.2
         PRE_ICL_MONPP_COPAY_1M           12.2
         PRE_ICL_MONPP_COPAY_2M           12.2
         PRE_ICL_MONPP_COPAY_3M           12.2
         PRE_ICL_MONPP_COPAY_DAILY        12.2
         PRE_ICL_LTCP_COPAY_1M            12.2
         PRE_ICL_LTCP_COPAY_DAILY         12.2
         PRE_ICL_DAYS_INP_1M              5.
         PRE_ICL_DAYS_INP_2M              5.
         PRE_ICL_DAYS_INP_3M              5.
         PRE_ICL_DAYS_INPP_1M             5.
         PRE_ICL_DAYS_INPP_2M             5.
         PRE_ICL_DAYS_INPP_3M             5.
         PRE_ICL_DAYS_INNPP_1M            5.
         PRE_ICL_DAYS_INNPP_2M            5.
         PRE_ICL_DAYS_INNPP_3M            5.
         PRE_ICL_DAYS_OONP_1M             5.
         PRE_ICL_DAYS_OONP_OS             5.
         PRE_ICL_DAYS_MO_1M               5.
         PRE_ICL_DAYS_MO_2M               5.
         PRE_ICL_DAYS_MO_3M               5.
         PRE_ICL_DAYS_MOPP_1M             5.
         PRE_ICL_DAYS_MOPP_2M             5.
         PRE_ICL_DAYS_MOPP_3M             5.
         PRE_ICL_DAYS_MONPP_1M            5.
         PRE_ICL_DAYS_MONPP_2M            5.
         PRE_ICL_DAYS_MONPP_3M            5.
         PRE_ICL_DAYS_LTCP_1M             5.
         GAP_INP_COINS_1M                 12.2
         GAP_INP_COINS_2M                 12.2
         GAP_INP_COINS_3M                 12.2
         GAP_INP_COINS_AVG_1M             12.2
         GAP_INPP_COINS_1M                12.2
         GAP_INPP_COINS_2M                12.2
         GAP_INPP_COINS_3M                12.2
         GAP_INPP_COINS_AVG_1M            12.2
         GAP_INNPP_COINS_1M               12.2
         GAP_INNPP_COINS_2M               12.2
         GAP_INNPP_COINS_3M               12.2
         GAP_INNPP_COINS_AVG_1M           12.2
         GAP_OONP_COINS_1M                12.2
         GAP_OONP_COINS_OS                12.2
         GAP_MO_COINS_1M                  12.2
         GAP_MO_COINS_2M                  12.2
         GAP_MO_COINS_3M                  12.2
         GAP_MOPP_COINS_1M                12.2
         GAP_MOPP_COINS_2M                12.2
         GAP_MOPP_COINS_3M                12.2
         GAP_MONPP_COINS_1M               12.2
         GAP_MONPP_COINS_2M               12.2
         GAP_MONPP_COINS_3M               12.2
         GAP_LTCP_COINS_1M                12.2
         GAP_INP_COPAY_1M                 12.2
         GAP_INP_COPAY_2M                 12.2
         GAP_INP_COPAY_3M                 12.2
         GAP_INP_COPAY_DAILY              12.2
         GAP_INPP_COPAY_1M                12.2
         GAP_INPP_COPAY_2M                12.2
         GAP_INPP_COPAY_3M                12.2
         GAP_INPP_COPAY_DAILY             12.2
         GAP_INNPP_COPAY_1M               12.2
         GAP_INNPP_COPAY_2M               12.2
         GAP_INNPP_COPAY_3M               12.2
         GAP_INNPP_COPAY_DAILY            12.2
         GAP_OONP_COPAY_1M                12.2
         GAP_OONP_COPAY_OS                12.2
         GAP_MO_COPAY_1M                  12.2
         GAP_MO_COPAY_2M                  12.2
         GAP_MO_COPAY_3M                  12.2
         GAP_MO_COPAY_DAILY               12.2
         GAP_MOPP_COPAY_1M                12.2
         GAP_MOPP_COPAY_2M                12.2
         GAP_MOPP_COPAY_3M                12.2
         GAP_MOPP_COPAY_DAILY             12.2
         GAP_MONPP_COPAY_1M               12.2
         GAP_MONPP_COPAY_2M               12.2
         GAP_MONPP_COPAY_3M               12.2
         GAP_MONPP_COPAY_DAILY            12.2
         GAP_LTCP_COPAY_1M                12.2
         GAP_LTCP_COPAY_DAILY             12.2
         GAP_DAYS_INP_1M                  5.
         GAP_DAYS_INP_2M                  5.
         GAP_DAYS_INP_3M                  5.
         GAP_DAYS_INPP_1M                 5.
         GAP_DAYS_INPP_2M                 5.
         GAP_DAYS_INPP_3M                 5.
         GAP_DAYS_INNPP_1M                5.
         GAP_DAYS_INNPP_2M                5.
         GAP_DAYS_INNPP_3M                5.
         GAP_DAYS_OONP_1M                 5.
         GAP_DAYS_OONP_OS                 5.
         GAP_DAYS_MO_1M                   5.
         GAP_DAYS_MO_2M                   5.
         GAP_DAYS_MO_3M                   5.
         GAP_DAYS_MOPP_1M                 5.
         GAP_DAYS_MOPP_2M                 5.
         GAP_DAYS_MOPP_3M                 5.
         GAP_DAYS_MONPP_1M                5.
         GAP_DAYS_MONPP_2M                5.
         GAP_DAYS_MONPP_3M                5.
         GAP_DAYS_LTCP_1M                 5.
         POST_OOPT_COINS_PCT              12.2
         POST_OOPT_COPAY_AMT              12.2;

  label  CONTRACT_ID                      = "Contract ID"
         PLAN_ID                          = "Plan ID"
         TIER_ID                          = "Tier Number"
         GAP_TIER                         = "Indicates whether tier is covered in the gap"
         GAP_TIER_PARTIAL                 = "Indicates whether tier is partially covered in the gap"
         EXCLUDED_TIER_GAP                = "Indicates whether excluded drugs are covered on this tier in the gap phase"
         EXCLUDED_TIER_PRE_ICL            = "Indicates whether excluded drugs are covered on this tier in the Pre ICL phase"
         SPECIALTY_TIER                   = "Indicates whether tier is a specialty tier"
         PRE_ICL_TIER_DRUG_TYPE           = "Pre-ICL Tier Drug Type"
         PRE_ICL_COSTSHARE_TYPE           = "Pre-ICL Costshare Type"
         PRE_ICL_INP_COINS_1M             = "Pre-ICL Coinsurance Standard Retail - one month supply"
         PRE_ICL_INP_COINS_2M             = "Pre-ICL Coinsurance Standard Retail - two month supply"
         PRE_ICL_INP_COINS_3M             = "Pre-ICL Coinsurance Standard Retail - three month supply"
         PRE_ICL_INP_COINS_AVG_1M         = "Pre-ICL Average Expected Cost Sharing - Standard Retail Coinsurance 1M"
         PRE_ICL_INPP_COINS_1M            = "Pre-ICL Coinsurance Split Network Preferred - one month supply"
         PRE_ICL_INPP_COINS_2M            = "Pre-ICL Coinsurance Split Network Preferred - two month supply"
         PRE_ICL_INPP_COINS_3M            = "Pre-ICL Coinsurance Split Network Preferred - three month supply"
         PRE_ICL_INPP_COINS_AVG_1M        = "Pre-ICL Average Expected Cost Sharing - Split Network Preferred Coinsurance 1M"
         PRE_ICL_INNPP_COINS_1M           = "Pre-ICL Coinsurance Split Network Standard Retail - one month supply"
         PRE_ICL_INNPP_COINS_2M           = "Pre-ICL Coinsurance Split Network Standard Retail - two month supply"
         PRE_ICL_INNPP_COINS_3M           = "Pre-ICL Coinsurance Split Network Standard Retail - three month supply"
         PRE_ICL_INNPP_COINS_AVG_1M       = "Pre-ICL Average Expected Cost Sharing - Split Network Standard Retail Coinsurance 1M"
         PRE_ICL_OONP_COINS_1M            = "Pre-ICL Coinsurance Out-of-Network Pharmacy - one month supply"
         PRE_ICL_OONP_COINS_OS            = "Pre-ICL Coinsurance Out-of-Network Pharmacy - other day supply"
         PRE_ICL_MO_COINS_1M              = "Pre-ICL Coinsurance Standard Mail Order - one month supply"
         PRE_ICL_MO_COINS_2M              = "Pre-ICL Coinsurance Standard Mail Order - two month supply"
         PRE_ICL_MO_COINS_3M              = "Pre-ICL Coinsurance Standard Mail Order - three month supply"
         PRE_ICL_MOPP_COINS_1M            = "Pre-ICL Coinsurance Split Network Preferred Mail Order - one month supply"
         PRE_ICL_MOPP_COINS_2M            = "Pre-ICL Coinsurance Split Network Preferred Mail Order - two month supply"
         PRE_ICL_MOPP_COINS_3M            = "Pre-ICL Coinsurance Split Network Preferred Mail Order - three month supply"
         PRE_ICL_MONPP_COINS_1M           = "Pre-ICL Coinsurance Split Network Standard Mail Order - one month supply"
         PRE_ICL_MONPP_COINS_2M           = "Pre-ICL Coinsurance Split Network Standard Mail Order - two month supply"
         PRE_ICL_MONPP_COINS_3M           = "Pre-ICL Coinsurance Split Network Standard Mail Order - three month supply"
         PRE_ICL_LTCP_COINS_1M            = "Pre-ICL Coinsurance Long Term Care Pharmacy - one month supply"
         PRE_ICL_INP_COPAY_1M             = "Pre-ICL Copay Standard Retail - one month supply"
         PRE_ICL_INP_COPAY_2M             = "Pre-ICL Copay Standard Retail - two month supply"
         PRE_ICL_INP_COPAY_3M             = "Pre-ICL Copay Standard Retail - three month supply"
         PRE_ICL_INP_COPAY_DAILY          = "Pre-ICL Copay Standard Retail - one day supply"
         PRE_ICL_INPP_COPAY_1M            = "Pre-ICL Copay Split Network Preferred - one month supply"
         PRE_ICL_INPP_COPAY_2M            = "Pre-ICL Copay Split Network Preferred - two month supply"
         PRE_ICL_INPP_COPAY_3M            = "Pre-ICL Copay Split Network Preferred - three month supply"
         PRE_ICL_INPP_COPAY_DAILY         = "Pre-ICL Copay Split Network Preferred - one day supply"
         PRE_ICL_INNPP_COPAY_1M           = "Pre-ICL Copay Split Network Standard Retail - one month supply"
         PRE_ICL_INNPP_COPAY_2M           = "Pre-ICL Copay Split Network Standard Retail - two month supply"
         PRE_ICL_INNPP_COPAY_3M           = "Pre-ICL Copay Split Network Standard Retail - three month supply"
         PRE_ICL_INNPP_COPAY_DAILY        = "Pre-ICL Copay Split Network Standard Retail - one day supply"
         PRE_ICL_OONP_COPAY_1M            = "Pre-ICL Copay Out-of-Network Pharmacy - one month supply"
         PRE_ICL_OONP_COPAY_OS            = "Pre-ICL Copay Out-of-Network Pharmacy - other day supply"
         PRE_ICL_MO_COPAY_1M              = "Pre-ICL Copay Standard Mail Order - one month supply"
         PRE_ICL_MO_COPAY_2M              = "Pre-ICL Copay Standard Mail Order - two month supply"
         PRE_ICL_MO_COPAY_3M              = "Pre-ICL Copay Standard Mail Order - three month supply"
         PRE_ICL_MO_COPAY_DAILY           = "Pre-ICL Copay Standard Mail Order - one day supply"
         PRE_ICL_MOPP_COPAY_1M            = "Pre-ICL Copay Split Network Preferred Mail Order - one month supply"
         PRE_ICL_MOPP_COPAY_2M            = "Pre-ICL Copay Split Network Preferred Mail Order - two month supply"
         PRE_ICL_MOPP_COPAY_3M            = "Pre-ICL Copay Split Network Preferred Mail Order - three month supply"
         PRE_ICL_MOPP_COPAY_DAILY         = "Pre-ICL Copay Split Network Preferred Mail Order - one day supply"
         PRE_ICL_MONPP_COPAY_1M           = "Pre-ICL Copay Split Network Standard Mail Order - one month supply"
         PRE_ICL_MONPP_COPAY_2M           = "Pre-ICL Copay Split Network Standard Mail Order - two month supply"
         PRE_ICL_MONPP_COPAY_3M           = "Pre-ICL Copay Split Network Standard Mail Order - three month supply"
         PRE_ICL_MONPP_COPAY_DAILY        = "Pre-ICL Copay Split Network Standard Mail Order - one day supply"
         PRE_ICL_LTCP_COPAY_1M            = "Pre_ICL Copay Long Term Care Pharmacy - one month supply"
         PRE_ICL_LTCP_COPAY_DAILY         = "Pre_ICL Copay Long Term Care Pharmacy - one day supply"
         PRE_ICL_DAYS_INP_1M              = "Pre-ICL Standard Retail - number of days in one month supply"
         PRE_ICL_DAYS_INP_2M              = "Pre-ICL Standard Retail - number of days in two month supply"
         PRE_ICL_DAYS_INP_3M              = "Pre-ICL Standard Retail - number of days in three month supply"
         PRE_ICL_DAYS_INPP_1M             = "Pre-ICL Split Network Preferred - number of days in one month supply"
         PRE_ICL_DAYS_INPP_2M             = "Pre-ICL Split Network Preferred - number of days in two month supply"
         PRE_ICL_DAYS_INPP_3M             = "Pre-ICL Split Network Preferred - number of days in three month supply"
         PRE_ICL_DAYS_INNPP_1M            = "Pre-ICL Split Network Standard Retail - number of days in one month supply"
         PRE_ICL_DAYS_INNPP_2M            = "Pre-ICL Split Network Standard Retail - number of days in two month supply"
         PRE_ICL_DAYS_INNPP_3M            = "Pre-ICL Split Network Standard Retail - number of days in three month supply"
         PRE_ICL_DAYS_OONP_1M             = "Pre-ICL Out-of-Network Pharmacy - number of days in one month supply"
         PRE_ICL_DAYS_OONP_OS             = "Pre-ICL Out-of-Network Pharmacy - number of days in other day supply"
         PRE_ICL_DAYS_MO_1M               = "Pre-ICL Standard Mail Order - number of days in one month supply"
         PRE_ICL_DAYS_MO_2M               = "Pre-ICL Standard Mail Order - number of days in two month supply"
         PRE_ICL_DAYS_MO_3M               = "Pre-ICL Standard Mail Order - number of days in three month supply"
         PRE_ICL_DAYS_MOPP_1M             = "Pre-ICL Split Network Preferred Mail Order - number of days in one month supply"
         PRE_ICL_DAYS_MOPP_2M             = "Pre-ICL Split Network Preferred Mail Order - number of days in two month supply"
         PRE_ICL_DAYS_MOPP_3M             = "Pre-ICL Split Network Preferred Mail Order - number of days in three month supply"
         PRE_ICL_DAYS_MONPP_1M            = "Pre-ICL Split Network Standard Mail Order - number of days in one month supply"
         PRE_ICL_DAYS_MONPP_2M            = "Pre-ICL Split Network Standard Mail Order - number of days in two month supply"
         PRE_ICL_DAYS_MONPP_3M            = "Pre-ICL Split Network Standard Mail Order - number of days in three month supply"
         PRE_ICL_DAYS_LTCP_1M             = "Pre-ICL Long Term Care Pharmacy - number of days in a one month supply"
         GAP_TIER_DRUG_TYPE               = "Gap Tier Drug Type"
         GAP_COSTSHARE_TYPE               = "Gap Cost Share Type"
         GAP_INP_COINS_1M                 = "Gap Coinsurance Standard Retail- one month supply"
         GAP_INP_COINS_2M                 = "Gap Coinsurance Standard Retail- two month supply"
         GAP_INP_COINS_3M                 = "Gap Coinsurance Standard Retail- three month supply"
         GAP_INP_COINS_AVG_1M             = "Gap Average Expected Cost Sharing - Standard Retail Coinsurance 1M"
         GAP_INPP_COINS_1M                = "Gap Coinsurance Split Network Preferred - one month supply"
         GAP_INPP_COINS_2M                = "Gap Coinsurance Split Network Preferred - two month supply"
         GAP_INPP_COINS_3M                = "Gap Coinsurance Split Network Preferred - three month supply"
         GAP_INPP_COINS_AVG_1M            = "Gap Average Expected Cost Sharing - Split Network Preferred Coinsurance 1M"
         GAP_INNPP_COINS_1M               = "Gap Coinsurance Split Network Standard Retail - one month supply"
         GAP_INNPP_COINS_2M               = "Gap Coinsurance Split Network Standard Retail - two month supply"
         GAP_INNPP_COINS_3M               = "Gap Coinsurance Split Network Standard Retail - three month supply"
         GAP_INNPP_COINS_AVG_1M           = "Gap Average Expected Cost Sharing - Split Network Standard Retail Coinsurance 1M"
         GAP_OONP_COINS_1M                = "Gap Coinsurance Out-of-Network Pharmacy - one month supply"
         GAP_OONP_COINS_OS                = "Gap Coinsurance Out-of-Network Pharmacy - other day supply"
         GAP_MO_COINS_1M                  = "Gap Coinsurance Standard Mail Order - one month supply"
         GAP_MO_COINS_2M                  = "Gap Coinsurance Standard Mail Order - two month supply"
         GAP_MO_COINS_3M                  = "Gap Coinsurance Standard Mail Order - three month supply"
         GAP_MOPP_COINS_1M                = "Gap Coinsurance Split Network Preferred Mail Order - one month supply"
         GAP_MOPP_COINS_2M                = "Gap Coinsurance Split Network Preferred Mail Order - two month supply"
         GAP_MOPP_COINS_3M                = "Gap Coinsurance Split Network Preferred Mail Order - three month supply"
         GAP_MONPP_COINS_1M               = "Gap Coinsurance Split Network Standard Mail Order - one month supply"
         GAP_MONPP_COINS_2M               = "Gap Coinsurance Split Network Standard Mail Order - two month supply"
         GAP_MONPP_COINS_3M               = "Gap Coinsurance Split Network Standard Mail Order - three month supply"
         GAP_LTCP_COINS_1M                = "Gap Coinsurance Long Term Care Pharmacy - one month supply"
         GAP_INP_COPAY_1M                 = "Gap Copay Standard Retail- one month supply"
         GAP_INP_COPAY_2M                 = "Gap Copay Standard Retail- two month supply"
         GAP_INP_COPAY_3M                 = "Gap Copay Standard Retail- three month supply"
         GAP_INP_COPAY_DAILY              = "Gap Copay Standard Retail- one day supply"
         GAP_INPP_COPAY_1M                = "Gap Copay Split Network Preferred - one month supply"
         GAP_INPP_COPAY_2M                = "Gap Copay Split Network Preferred - two month supply"
         GAP_INPP_COPAY_3M                = "Gap Copay Split Network Preferred - three month supply"
         GAP_INPP_COPAY_DAILY             = "Gap Copay Split Network Preferred - one day supply"
         GAP_INNPP_COPAY_1M               = "Gap Copay Split Network Standard Retail - one month supply"
         GAP_INNPP_COPAY_2M               = "Gap Copay Split Network Standard Retail - two month supply"
         GAP_INNPP_COPAY_3M               = "Gap Copay Split Network Standard Retail - three month supply"
         GAP_INNPP_COPAY_DAILY            = "Gap Copay Split Network Standard Retail - one day supply"
         GAP_OONP_COPAY_1M                = "Gap Copay Out-of-Network Pharmacy - one month supply"
         GAP_OONP_COPAY_OS                = "Gap Copay Out-of-Network Pharmacy - other day supply"
         GAP_MO_COPAY_1M                  = "Gap Copay Standard Mail Order - one month supply"
         GAP_MO_COPAY_2M                  = "Gap Copay Standard Mail Order - two month supply"
         GAP_MO_COPAY_3M                  = "Gap Copay Standard Mail Order - three month supply"
         GAP_MO_COPAY_DAILY               = "Gap Copay Standard Mail Order - one day supply"
         GAP_MOPP_COPAY_1M                = "Gap Copay Split Network Preferred Mail Order - one month supply"
         GAP_MOPP_COPAY_2M                = "Gap Copay Split Network Preferred Mail Order - two month supply"
         GAP_MOPP_COPAY_3M                = "Gap Copay Split Network Preferred Mail Order - three month supply"
         GAP_MOPP_COPAY_DAILY             = "Gap Copay Split Network Preferred Mail Order - one day supply"
         GAP_MONPP_COPAY_1M               = "Gap Copay Split Network Standard Mail Order - one month supply"
         GAP_MONPP_COPAY_2M               = "Gap Copay Split Network Standard Mail Order - two month supply"
         GAP_MONPP_COPAY_3M               = "Gap Copay Split Network Standard Mail Order - three month supply"
         GAP_MONPP_COPAY_DAILY            = "Gap Copay Split Network Standard Mail Order - one day supply"
         GAP_LTCP_COPAY_1M                = "Gap Copay Long Term Care Pharmacy - one month supply"
         GAP_LTCP_COPAY_DAILY             = "Gap Copay Long Term Care Pharmacy - one day supply"
         GAP_DAYS_INP_1M                  = "Gap Standard Retail- number of days in one month supply"
         GAP_DAYS_INP_2M                  = "Gap Standard Retail- number of days in two month supply"
         GAP_DAYS_INP_3M                  = "Gap Standard Retail- number of days in three month supply"
         GAP_DAYS_INPP_1M                 = "Gap Split Network Preferred - number of days in one month supply"
         GAP_DAYS_INPP_2M                 = "Gap Split Network Preferred - number of days in two month supply"
         GAP_DAYS_INPP_3M                 = "Gap Split Network Preferred - number of days in three month supply"
         GAP_DAYS_INNPP_1M                = "Gap Split Network Standard Retail - number of days in one month supply"
         GAP_DAYS_INNPP_2M                = "Gap Split Network Standard Retail - number of days in two month supply"
         GAP_DAYS_INNPP_3M                = "Gap Split Network Standard Retail - number of days in three month supply"
         GAP_DAYS_OONP_1M                 = "Gap Out-of-Network Pharmacy - number of days in one month supply"
         GAP_DAYS_OONP_OS                 = "Gap Out-of-Network Pharmacy - number of days in other day supply"
         GAP_DAYS_MO_1M                   = "Gap Standard Mail Order - number of days in one month supply"
         GAP_DAYS_MO_2M                   = "Gap Standard Mail Order - number of days in two month supply"
         GAP_DAYS_MO_3M                   = "Gap Standard Mail Order - number of days in three month supply"
         GAP_DAYS_MOPP_1M                 = "Gap Split Network Preferred Mail Order - number of days in one month supply"
         GAP_DAYS_MOPP_2M                 = "Gap Split Network Preferred Mail Order - number of days in two month supply"
         GAP_DAYS_MOPP_3M                 = "Gap Split Network Preferred Mail Order - number of days in three month supply"
         GAP_DAYS_MONPP_1M                = "Gap Split Network Standard Mail Order - number of days in one month supply"
         GAP_DAYS_MONPP_2M                = "Gap Split Network Standard Mail Order - number of days in two month supply"
         GAP_DAYS_MONPP_3M                = "Gap Split Network Standard Mail Order - number of days in three month supply"
         GAP_DAYS_LTCP_1M                 = "Gap Long Term Care Pharmacy - number of days in a one month supply"
         POST_OOPT_TIER_DRUG_TYPE         = "Post-Out-of-pocket threshold tier drug type"
         POST_OOPT_COSTSHARE_TYPE         = "Post-Out-of-pocket threshold costshare type"
         POST_OOPT_COINS_PCT              = "Post-Out-of-pocket threshold Coinsurance"
         POST_OOPT_COPAY_AMT              = "Post-Out-of-pocket threshold Copay";

  infile in missover truncover;

  input @0001  CONTRACT_ID                      $5.
        @0006  PLAN_ID                          $3.
        @0009  TIER_ID                          $2.
        @0011  GAP_TIER                         $1.
        @0012  GAP_TIER_PARTIAL                 $1.
        @0013  EXCLUDED_TIER_GAP                $1.
        @0014  EXCLUDED_TIER_PRE_ICL            $1.
        @0015  SPECIALTY_TIER                   $1.
        @0016  PRE_ICL_TIER_DRUG_TYPE           $2.
        @0018  PRE_ICL_COSTSHARE_TYPE           $1.
        @0019  PRE_ICL_INP_COINS_1M             12.2
        @0031  PRE_ICL_INP_COINS_2M             12.2
        @0043  PRE_ICL_INP_COINS_3M             12.2
        @0055  PRE_ICL_INP_COINS_AVG_1M         12.2
        @0067  PRE_ICL_INPP_COINS_1M            12.2
        @0079  PRE_ICL_INPP_COINS_2M            12.2
        @0091  PRE_ICL_INPP_COINS_3M            12.2
        @0103  PRE_ICL_INPP_COINS_AVG_1M        12.2
        @0115  PRE_ICL_INNPP_COINS_1M           12.2
        @0127  PRE_ICL_INNPP_COINS_2M           12.2
        @0139  PRE_ICL_INNPP_COINS_3M           12.2
        @0151  PRE_ICL_INNPP_COINS_AVG_1M       12.2
        @0163  PRE_ICL_OONP_COINS_1M            12.2
        @0175  PRE_ICL_OONP_COINS_OS            12.2
        @0187  PRE_ICL_MO_COINS_1M              12.2
        @0199  PRE_ICL_MO_COINS_2M              12.2
        @0211  PRE_ICL_MO_COINS_3M              12.2
        @0223  PRE_ICL_MOPP_COINS_1M            12.2
        @0235  PRE_ICL_MOPP_COINS_2M            12.2
        @0247  PRE_ICL_MOPP_COINS_3M            12.2
        @0259  PRE_ICL_MONPP_COINS_1M           12.2
        @0271  PRE_ICL_MONPP_COINS_2M           12.2
        @0283  PRE_ICL_MONPP_COINS_3M           12.2
        @0295  PRE_ICL_LTCP_COINS_1M            12.2
        @0307  PRE_ICL_INP_COPAY_1M             12.2
        @0319  PRE_ICL_INP_COPAY_2M             12.2
        @0331  PRE_ICL_INP_COPAY_3M             12.2
        @0343  PRE_ICL_INP_COPAY_DAILY          12.2
        @0355  PRE_ICL_INPP_COPAY_1M            12.2
        @0367  PRE_ICL_INPP_COPAY_2M            12.2
        @0379  PRE_ICL_INPP_COPAY_3M            12.2
        @0391  PRE_ICL_INPP_COPAY_DAILY         12.2
        @0403  PRE_ICL_INNPP_COPAY_1M           12.2
        @0415  PRE_ICL_INNPP_COPAY_2M           12.2
        @0427  PRE_ICL_INNPP_COPAY_3M           12.2
        @0439  PRE_ICL_INNPP_COPAY_DAILY        12.2
        @0451  PRE_ICL_OONP_COPAY_1M            12.2
        @0463  PRE_ICL_OONP_COPAY_OS            12.2
        @0475  PRE_ICL_MO_COPAY_1M              12.2
        @0487  PRE_ICL_MO_COPAY_2M              12.2
        @0499  PRE_ICL_MO_COPAY_3M              12.2
        @0511  PRE_ICL_MO_COPAY_DAILY           12.2
        @0523  PRE_ICL_MOPP_COPAY_1M            12.2
        @0535  PRE_ICL_MOPP_COPAY_2M            12.2
        @0547  PRE_ICL_MOPP_COPAY_3M            12.2
        @0559  PRE_ICL_MOPP_COPAY_DAILY         12.2
        @0571  PRE_ICL_MONPP_COPAY_1M           12.2
        @0583  PRE_ICL_MONPP_COPAY_2M           12.2
        @0595  PRE_ICL_MONPP_COPAY_3M           12.2
        @0607  PRE_ICL_MONPP_COPAY_DAILY        12.2
        @0619  PRE_ICL_LTCP_COPAY_1M            12.2
        @0631  PRE_ICL_LTCP_COPAY_DAILY         12.2
        @0643  PRE_ICL_DAYS_INP_1M              5.
        @0648  PRE_ICL_DAYS_INP_2M              5.
        @0653  PRE_ICL_DAYS_INP_3M              5.
        @0658  PRE_ICL_DAYS_INPP_1M             5.
        @0663  PRE_ICL_DAYS_INPP_2M             5.
        @0668  PRE_ICL_DAYS_INPP_3M             5.
        @0673  PRE_ICL_DAYS_INNPP_1M            5.
        @0678  PRE_ICL_DAYS_INNPP_2M            5.
        @0683  PRE_ICL_DAYS_INNPP_3M            5.
        @0688  PRE_ICL_DAYS_OONP_1M             5.
        @0693  PRE_ICL_DAYS_OONP_OS             5.
        @0698  PRE_ICL_DAYS_MO_1M               5.
        @0703  PRE_ICL_DAYS_MO_2M               5.
        @0708  PRE_ICL_DAYS_MO_3M               5.
        @0713  PRE_ICL_DAYS_MOPP_1M             5.
        @0718  PRE_ICL_DAYS_MOPP_2M             5.
        @0723  PRE_ICL_DAYS_MOPP_3M             5.
        @0728  PRE_ICL_DAYS_MONPP_1M            5.
        @0733  PRE_ICL_DAYS_MONPP_2M            5.
        @0738  PRE_ICL_DAYS_MONPP_3M            5.
        @0743  PRE_ICL_DAYS_LTCP_1M             5.
        @0748  GAP_TIER_DRUG_TYPE               $2.
        @0750  GAP_COSTSHARE_TYPE               $1.
        @0751  GAP_INP_COINS_1M                 12.2
        @0763  GAP_INP_COINS_2M                 12.2
        @0775  GAP_INP_COINS_3M                 12.2
        @0787  GAP_INP_COINS_AVG_1M             12.2
        @0799  GAP_INPP_COINS_1M                12.2
        @0811  GAP_INPP_COINS_2M                12.2
        @0823  GAP_INPP_COINS_3M                12.2
        @0835  GAP_INPP_COINS_AVG_1M            12.2
        @0847  GAP_INNPP_COINS_1M               12.2
        @0859  GAP_INNPP_COINS_2M               12.2
        @0871  GAP_INNPP_COINS_3M               12.2
        @0883  GAP_INNPP_COINS_AVG_1M           12.2
        @0895  GAP_OONP_COINS_1M                12.2
        @0907  GAP_OONP_COINS_OS                12.2
        @0919  GAP_MO_COINS_1M                  12.2
        @0931  GAP_MO_COINS_2M                  12.2
        @0943  GAP_MO_COINS_3M                  12.2
        @0955  GAP_MOPP_COINS_1M                12.2
        @0967  GAP_MOPP_COINS_2M                12.2
        @0979  GAP_MOPP_COINS_3M                12.2
        @0991  GAP_MONPP_COINS_1M               12.2
        @1003  GAP_MONPP_COINS_2M               12.2
        @1015  GAP_MONPP_COINS_3M               12.2
        @1027  GAP_LTCP_COINS_1M                12.2
        @1039  GAP_INP_COPAY_1M                 12.2
        @1051  GAP_INP_COPAY_2M                 12.2
        @1063  GAP_INP_COPAY_3M                 12.2
        @1075  GAP_INP_COPAY_DAILY              12.2
        @1087  GAP_INPP_COPAY_1M                12.2
        @1099  GAP_INPP_COPAY_2M                12.2
        @1111  GAP_INPP_COPAY_3M                12.2
        @1123  GAP_INPP_COPAY_DAILY             12.2
        @1135  GAP_INNPP_COPAY_1M               12.2
        @1147  GAP_INNPP_COPAY_2M               12.2
        @1159  GAP_INNPP_COPAY_3M               12.2
        @1171  GAP_INNPP_COPAY_DAILY            12.2
        @1183  GAP_OONP_COPAY_1M                12.2
        @1195  GAP_OONP_COPAY_OS                12.2
        @1207  GAP_MO_COPAY_1M                  12.2
        @1219  GAP_MO_COPAY_2M                  12.2
        @1231  GAP_MO_COPAY_3M                  12.2
        @1243  GAP_MO_COPAY_DAILY               12.2
        @1255  GAP_MOPP_COPAY_1M                12.2
        @1267  GAP_MOPP_COPAY_2M                12.2
        @1279  GAP_MOPP_COPAY_3M                12.2
        @1291  GAP_MOPP_COPAY_DAILY             12.2
        @1303  GAP_MONPP_COPAY_1M               12.2
        @1315  GAP_MONPP_COPAY_2M               12.2
        @1327  GAP_MONPP_COPAY_3M               12.2
        @1339  GAP_MONPP_COPAY_DAILY            12.2
        @1351  GAP_LTCP_COPAY_1M                12.2
        @1363  GAP_LTCP_COPAY_DAILY             12.2
        @1375  GAP_DAYS_INP_1M                  5.
        @1380  GAP_DAYS_INP_2M                  5.
        @1385  GAP_DAYS_INP_3M                  5.
        @1390  GAP_DAYS_INPP_1M                 5.
        @1395  GAP_DAYS_INPP_2M                 5.
        @1400  GAP_DAYS_INPP_3M                 5.
        @1405  GAP_DAYS_INNPP_1M                5.
        @1410  GAP_DAYS_INNPP_2M                5.
        @1415  GAP_DAYS_INNPP_3M                5.
        @1420  GAP_DAYS_OONP_1M                 5.
        @1425  GAP_DAYS_OONP_OS                 5.
        @1430  GAP_DAYS_MO_1M                   5.
        @1435  GAP_DAYS_MO_2M                   5.
        @1440  GAP_DAYS_MO_3M                   5.
        @1445  GAP_DAYS_MOPP_1M                 5.
        @1450  GAP_DAYS_MOPP_2M                 5.
        @1455  GAP_DAYS_MOPP_3M                 5.
        @1460  GAP_DAYS_MONPP_1M                5.
        @1465  GAP_DAYS_MONPP_2M                5.
        @1470  GAP_DAYS_MONPP_3M                5.
        @1475  GAP_DAYS_LTCP_1M                 5.
        @1480  POST_OOPT_TIER_DRUG_TYPE         $2.
        @1482  POST_OOPT_COSTSHARE_TYPE         $1.
        @1483  POST_OOPT_COINS_PCT              12.2
        @1495  POST_OOPT_COPAY_AMT              12.2;
run;

title 'TIER 2020';
proc contents data=ccw.TIER_2020 varnum;
proc print data=ccw.TIER_2020(obs=5);
  title2 'Sample Listing - First 5 Rows';
run;
proc means data=ccw.TIER_2020;
  title2 'Simple Means';
run;

proc freq data=ccw.TIER_2020;
  title2 'Freqs';
  table EXCLUDED_TIER_GAP
        EXCLUDED_TIER_PRE_ICL
        GAP_COSTSHARE_TYPE
        GAP_TIER
        GAP_TIER_DRUG_TYPE
        GAP_TIER_PARTIAL
        POST_OOPT_COSTSHARE_TYPE
        POST_OOPT_TIER_DRUG_TYPE
        PRE_ICL_COSTSHARE_TYPE
        PRE_ICL_TIER_DRUG_TYPE
        SPECIALTY_TIER
        TIER_ID/missing;
run;

* End of Program *;
