* SAS Read-In Program
*
* Name: formulary_2010_readin.sas
*
* Purpose: Read-In the delimited flat file FORMULARY_2010.
*
* Delimiter: Fixed Column
*
* Date: 10DEC14   Time: 17:25
*
* Programmer: Adam Hendricks, Adam.Hendricks@gdit.com, 515-645-3015
*
*;

%let dirpath = .; * <--  Directory Path for Input Flat File in FILENAME Statement *;

filename in  "%trim(&dirpath)/formulary_2010.dat" lrecl=136;

libname  out '.'; * <--  Directory Path for Output Library in LIBNAME Statement   *;

* Start *;
data out.FORMULARY_2010;
  length FORMULARY_ID                     $8
         FRMLRY_RX_ID                     $8
         TIER_ID                          $2
         STEP                             $2
         QUANTITY_LIMIT_YN                $2
         PRIOR_AUTHORIZATION_YN           $2
         BN                               $30
         GNN                              $30
         STR                              $10
         GCDF                             $2
         GCDF_DESC                        $40;

  format FORMULARY_ID                     $8.
         FRMLRY_RX_ID                     $8.
         TIER_ID                          $2.
         STEP                             $2.
         QUANTITY_LIMIT_YN                $2.
         PRIOR_AUTHORIZATION_YN           $2.
         BN                               $30.
         GNN                              $30.
         STR                              $10.
         GCDF                             $2.
         GCDF_DESC                        $40.;

  label  FORMULARY_ID                     = "Unique ID Assigned to Each Newly Created Formulary"
         FRMLRY_RX_ID                     = "CCW Identifier for a Drug Product Found in a Part D Prescription Drug Plan Formulary"
         TIER_ID                          = "Formulary Tier Number"
         STEP                             = "Step Number within a Step Therapy Group"
         QUANTITY_LIMIT_YN                = "Quantity Limits? (1=Yes)"
         PRIOR_AUTHORIZATION_YN           = "Prior Authorization? (1=Yes)"
         BN                               = "FDB Brand Name"
         GNN                              = "FDB USAN Generic Name - Short Version"
         STR                              = "FDB Drug Strength Description"
         GCDF                             = "FDB Dosage Form Code"
         GCDF_DESC                        = "FDB Dosage Form Code Description";

  infile in missover truncover;

  input @001   FORMULARY_ID                     $8.
        @009   FRMLRY_RX_ID                     $8.
        @017   TIER_ID                          $2.
        @019   STEP                             $2.
        @021   QUANTITY_LIMIT_YN                $2.
        @023   PRIOR_AUTHORIZATION_YN           $2.
        @025   BN                               $30.
        @055   GNN                              $30.
        @085   STR                              $10.
        @095   GCDF                             $2.
        @097   GCDF_DESC                        $40.;
run;

title 'Part D Formulary 2010';
proc contents data=out.FORMULARY_2010 varnum;
proc print data=out.FORMULARY_2010(obs=5);
  title2 'Sample Listing - First 5 Rows';
run;

proc freq data=out.FORMULARY_2010;
  title2 'Freqs';
  table GCDF
        PRIOR_AUTHORIZATION_YN
        QUANTITY_LIMIT_YN
        STEP
        TIER_ID/missing;
run;

* End of Program *;
