* SAS Read-In Program
*
* Name: excl_drugs_2011_readin.sas
*
* Purpose: Read-In the delimited flat file EXCL_DRUGS_2011.
*
* Delimiter: Fixed Column
*
* Date: 10DEC14   Time: 17:27
*
* Programmer: Adam Hendricks, Adam.Hendricks@gdit.com, 515-645-3015
*
*;

%let dirpath = .; * <--  Directory Path for Input Flat File in FILENAME Statement *;

filename in  "%trim(&dirpath)/excl_drugs_2011.dat" lrecl=138;

libname  out '.'; * <--  Directory Path for Output Library in LIBNAME Statement   *;

* Start *;
data out.EXCL_DRUGS_2011;
  length CONTRACT_ID                      $5
         PLAN_ID                          $3
         FORMULARY_ID                     $8
         FRMLRY_RX_ID                     $8
         TIER_ID                          $2
         BN                               $30
         GNN                              $30
         STR                              $10
         GCDF                             $2
         GCDF_DESC                        $40;

  format CONTRACT_ID                      $5.
         PLAN_ID                          $3.
         FORMULARY_ID                     $8.
         FRMLRY_RX_ID                     $8.
         TIER_ID                          $2.
         BN                               $30.
         GNN                              $30.
         STR                              $10.
         GCDF                             $2.
         GCDF_DESC                        $40.;

  label  CONTRACT_ID                      = "Part D Contract ID"
         PLAN_ID                          = "Part D Plan ID"
         FORMULARY_ID                     = "Unique ID Assigned to Each Newly Created Formulary"
         FRMLRY_RX_ID                     = "CCW Identifier for a Drug Product Found in a Part D Prescription Drug Plan Formulary"
         TIER_ID                          = "Cost share tier level associated with the drug"
         BN                               = "FDB Brand Name"
         GNN                              = "FDB USAN Generic Name - Short Version"
         STR                              = "FDB Drug Strength Description"
         GCDF                             = "FDB Dosage Form Code"
         GCDF_DESC                        = "FDB Dosage Form Code Description";

  infile in missover truncover;

  input @001   CONTRACT_ID                      $5.
        @006   PLAN_ID                          $3.
        @009   FORMULARY_ID                     $8.
        @017   FRMLRY_RX_ID                     $8.
        @025   TIER_ID                          $2.
        @027   BN                               $30.
        @057   GNN                              $30.
        @087   STR                              $10.
        @097   GCDF                             $2.
        @099   GCDF_DESC                        $40.;
run;

title 'Part D Excl Drugs 2011';
proc contents data=out.EXCL_DRUGS_2011 varnum;
proc print data=out.EXCL_DRUGS_2011(obs=5);
  title2 'Sample Listing - First 5 Rows';
run;

proc freq data=out.EXCL_DRUGS_2011;
  title2 'Freqs';
  table GCDF TIER_ID/missing;
run;

* End of Program *;
