* SAS Read-In Program
*
* Name: otc_drugs_2011_readin.sas
*
* Purpose: Read-In the delimited flat file OTC_DRUGS_2011.
*
* Delimiter: Fixed Column
*
* Date: 10DEC14   Time: 17:27
*
* Programmer: Adam Hendricks, Adam.Hendricks@gdit.com, 515-645-3015
*
*;

%let dirpath = .; * <--  Directory Path for Input Flat File in FILENAME Statement *;

filename in  "%trim(&dirpath)/otc_drugs_2011.dat" lrecl=128;

libname  out '.'; * <--  Directory Path for Output Library in LIBNAME Statement   *;

* Start *;
data out.OTC_DRUGS_2011;
  length FORMULARY_ID                     $8
         FRMLRY_RX_ID                     $8
         BN                               $30
         GNN                              $30
         STR                              $10
         GCDF                             $2
         GCDF_DESC                        $40;

  format FORMULARY_ID                     $8.
         FRMLRY_RX_ID                     $8.
         BN                               $30.
         GNN                              $30.
         STR                              $10.
         GCDF                             $2.
         GCDF_DESC                        $40.;

  label  FORMULARY_ID                     = "Unique ID Assigned to Each Newly Created Formulary"
         FRMLRY_RX_ID                     = "CCW Identifier for a Drug Product Found in a Part D Prescription Drug Plan Formulary"
         BN                               = "FDB Brand Name"
         GNN                              = "FDB USAN Generic Name - Short Version"
         STR                              = "FDB Drug Strength Description"
         GCDF                             = "FDB Dosage Form Code"
         GCDF_DESC                        = "FDB Dosage Form Code Description";

  infile in missover truncover;

  input @001   FORMULARY_ID                     $8.
        @009   FRMLRY_RX_ID                     $8.
        @017   BN                               $30.
        @047   GNN                              $30.
        @077   STR                              $10.
        @087   GCDF                             $2.
        @089   GCDF_DESC                        $40.;
run;

title 'Part D OTC Drugs 2011';
proc contents data=out.OTC_DRUGS_2011 varnum;
proc print data=out.OTC_DRUGS_2011(obs=5);
  title2 'Sample Listing - First 5 Rows';
run;

proc freq data=out.OTC_DRUGS_2011;
  title2 'Freqs';
  table GCDF/missing;
run;

* End of Program *;
