* SAS Read-In Program
*
* Name: pdss_2021_readin.sas
*
* Purpose: Read-In the delimited flat file PDSS_2021.
*
* Delimiter: Fixed Column
*
* Date: 01SEP22   Time: 18:27
*
* Help: cmsdata@gdit.com, 1-866-766-1915
*
*;

filename in  'pdss_2021.dat'  lrecl=32768;
libname  ccw '.';

data ccw.PDSS_2021;
  length CONTRACT_ID                      $5
         PLAN_ID                          $3
         SEGMENT_ID                       $3
         FRMLRY_RX_ID                     $8
         BN                               $30
         GNN                              $30
         STR                              $10
         GCDF                             $2
         GCDF_DESC                        $40
         TYPE                             $50
         COPAY                            3;

  format CONTRACT_ID                      $5.
         PLAN_ID                          $3.
         SEGMENT_ID                       $3.
         FRMLRY_RX_ID                     $8.
         BN                               $30.
         GNN                              $30.
         STR                              $10.
         GCDF                             $2.
         GCDF_DESC                        $40.
         TYPE                             $50.
         COPAY                            2.;

  label  CONTRACT_ID                      = "Contract ID"
         PLAN_ID                          = "Plan ID"
         SEGMENT_ID                       = "Segment ID"
         FRMLRY_RX_ID                     = "CCW Identifier for a Drug Product Found in a Part D Prescription Drug Plan Formulary"
         BN                               = "FDB Brand Name"
         GNN                              = "FDB USAN Generic Name - Short Version"
         STR                              = "FDB Drug Strength Description"
         GCDF                             = "FDB Dosage Form Code"
         GCDF_DESC                        = "FDB Dosage Form Code Description"
         TYPE                             = "Insulin Type as Defined by the Model"
         COPAY                            = "Copay";

  infile in missover truncover;

  input @001   CONTRACT_ID                      $5.
        @006   PLAN_ID                          $3.
        @009   SEGMENT_ID                       $3.
        @012   FRMLRY_RX_ID                     $8.
        @020   BN                               $30.
        @050   GNN                              $30.
        @080   STR                              $10.
        @090   GCDF                             $2.
        @092   GCDF_DESC                        $40.
        @132   TYPE                             $50.
        @182   COPAY                            2.;
run;

title 'PDSS_2021';
proc contents data=ccw.PDSS_2021 varnum;
proc print data=ccw.PDSS_2021(obs=5);
  title2 'Sample Listing - First 5 Rows';
run;
proc means data=ccw.PDSS_2021;
  title2 'Simple Means';
run;

proc freq data=ccw.PDSS_2021;
  title2 'Freqs';
  table
    COPAY
    GCDF
        /missing;
run;

* End of Program *;
