* SAS Read-In Program
*
* Name: plan_char_2017_readin.sas
*
* Purpose: Read-In the delimited flat file PLAN_CHAR_2017.
*
* Delimiter: Fixed Column
*
* Date: 01OCT18   Time: 18:47
*
* Help: cmsdata@gdit.com, 1-866-766-1915
*
*;

filename in  'plan_char_2017.dat'  lrecl=32768;
libname  ccw '.';

data ccw.PLAN_CHAR_2017;
  length CONTRACT_ID                      $5
         PLAN_ID                          $3
         FORMULARY_ID                     $8
         PTCD_INDICATOR                   $1
         CONTRACT_NAME                    $150
         PLAN_NAME                        $75
         ORGANIZATION_MARKETING_NAME      $150
         PARENT_ORGANIZATION              $50
         EFFECTIVE_DATE                   $10
         ORGANIZATION_TYPE                $2
         PLAN_TYPE                        $2
         DEMO_TYPE                        $1
         SNP_TYPE                         $1
         FIDE_SNP                         $1
         DSNP_ZERODOLLAR                  $1
         DRUG_BENEFIT_TYPE                $1
         EGWP_INDICATOR                   $1
         EGHP_CALENDAR_YEAR_FLAG          $1
         COV_CRITERIA                     $1
         NATIONAL_PDP                     $1
         DEMINIMIS_PD_FLAG                $1
         DED_APPLY                        $1
         DED_AMT                          8
         DED_APPLY_ALL                    $1
         DED_COSTSHARE_TIERS              $6
         DED_COPAY                        8
         DED_COINS                        8
         FREE_FIRST_FILL                  $1
         PRE_ICL_APPLY                    $1
         ICL_APPLY                        $1
         ICL_AMT                          8
         POST_OOPT_APPLY                  $1
         OOPT_AMT                         8
         EXCLUDED_DRUGS                   $1
         REDUCED_COST_SHARE               $1
         REDUCED_DED                      $1
         REDUCED_PREICL_CS                $1
         REDUCED_OOPT_CS                  $1
         INCREASED_ICL                    $1
         OTC_UM_PROGRAM                   $1;

  format CONTRACT_ID                      $5.
         PLAN_ID                          $3.
         FORMULARY_ID                     $8.
         PTCD_INDICATOR                   $1.
         CONTRACT_NAME                    $150.
         PLAN_NAME                        $75.
         ORGANIZATION_MARKETING_NAME      $150.
         PARENT_ORGANIZATION              $50.
         EFFECTIVE_DATE                   $10.
         ORGANIZATION_TYPE                $2.
         PLAN_TYPE                        $2.
         DEMO_TYPE                        $1.
         SNP_TYPE                         $1.
         FIDE_SNP                         $1.
         DSNP_ZERODOLLAR                  $1.
         DRUG_BENEFIT_TYPE                $1.
         EGWP_INDICATOR                   $1.
         EGHP_CALENDAR_YEAR_FLAG          $1.
         COV_CRITERIA                     $1.
         NATIONAL_PDP                     $1.
         DEMINIMIS_PD_FLAG                $1.
         DED_APPLY                        $1.
         DED_AMT                          12.2
         DED_APPLY_ALL                    $1.
         DED_COSTSHARE_TIERS              $6.
         DED_COPAY                        12.2
         DED_COINS                        12.2
         FREE_FIRST_FILL                  $1.
         PRE_ICL_APPLY                    $1.
         ICL_APPLY                        $1.
         ICL_AMT                          12.2
         POST_OOPT_APPLY                  $1.
         OOPT_AMT                         12.2
         EXCLUDED_DRUGS                   $1.
         REDUCED_COST_SHARE               $1.
         REDUCED_DED                      $1.
         REDUCED_PREICL_CS                $1.
         REDUCED_OOPT_CS                  $1.
         INCREASED_ICL                    $1.
         OTC_UM_PROGRAM                   $1.;

  label  CONTRACT_ID                      = "Contract ID"
         PLAN_ID                          = "Plan ID"
         FORMULARY_ID                     = "Formulary Identifier"
         PTCD_INDICATOR                   = "Indicates Whether the Plan is Part C, Part D or Both"
         CONTRACT_NAME                    = "Contract Name"
         PLAN_NAME                        = "Plan Name"
         ORGANIZATION_MARKETING_NAME      = "Organization Marketing Name"
         PARENT_ORGANIZATION              = "Parent Organization"
         EFFECTIVE_DATE                   = "Effective Date"
         ORGANIZATION_TYPE                = "Organization Type"
         PLAN_TYPE                        = "Plan Type"
         DEMO_TYPE                        = "Demo Type"
         SNP_TYPE                         = "SNP Type"
         FIDE_SNP                         = "Fully Integrated Dual Eligible (FIDE) SNP"
         DSNP_ZERODOLLAR                  = "Medicare Zero-Dollar Cost Sharing D-SNP Plan"
         DRUG_BENEFIT_TYPE                = "Drug Benefit Type"
         EGWP_INDICATOR                   = "Employer Plan Indicator"
         EGHP_CALENDAR_YEAR_FLAG          = "EGHP Calendar Year Indicator"
         COV_CRITERIA                     = "Coverage Criteria (A/B or B only)"
         NATIONAL_PDP                     = "Indicates whether the Part D plan belongs to a National PDP sponsor"
         DEMINIMIS_PD_FLAG                = "Part D Plan Deminimis Paid Flag"
         DED_APPLY                        = "How the Part D Plan Deductible is applied"
         DED_AMT                          = "Part D Plan Deductible Amount"
         DED_APPLY_ALL                    = "Type of Cost Sharing in the Part D Plan Deductible Phase"
         DED_COSTSHARE_TIERS              = "Tiers with Cost Sharing in the Part D Plan Deductible Phase"
         DED_COPAY                        = "Part D Plan Deductible Phase Copay Amount"
         DED_COINS                        = "Part D Plan Deductible Phase Coinsurance Percentage"
         FREE_FIRST_FILL                  = "Indicates whether the Part D plan offers a free first fill benefit"
         PRE_ICL_APPLY                    = "How Pre-ICL cost shares are applied in the Part D Plan"
         ICL_APPLY                        = "How ICL is applied in Part D Plans"
         ICL_AMT                          = "Part D Plan ICL Amount"
         POST_OOPT_APPLY                  = "How Post OOP threshold cost shares are applied in the Part D Plan"
         OOPT_AMT                         = "OOP Threshold Amount in the Part D Plan"
         EXCLUDED_DRUGS                   = "Indicates whether the Part D plan covers excluded drugs"
         REDUCED_COST_SHARE               = "Indicates whether the Part D plan has reduced cost sharing below Medicare standard"
         REDUCED_DED                      = "Flag for reduced deductible amount in the Part D plan"
         REDUCED_PREICL_CS                = "Flag for reduced pre-ICL cost sharing amounts in the Part D plan"
         REDUCED_OOPT_CS                  = "Flag for reduced post out-of-pocket threshold cost sharing amounts in the Part D plan"
         INCREASED_ICL                    = "Flag for increased Initial Coverage Limit in the Part D plan"
         OTC_UM_PROGRAM                   = "Part D plan pays for Over-the-Counter medications (OTCs) under the Utilization Management Program";

  infile in missover truncover;

  input @001   CONTRACT_ID                      $5.
        @006   PLAN_ID                          $3.
        @009   FORMULARY_ID                     $8.
        @017   PTCD_INDICATOR                   $1.
        @018   CONTRACT_NAME                    $150.
        @168   PLAN_NAME                        $75.
        @243   ORGANIZATION_MARKETING_NAME      $150.
        @393   PARENT_ORGANIZATION              $50.
        @443   EFFECTIVE_DATE                   $10.
        @453   ORGANIZATION_TYPE                $2.
        @455   PLAN_TYPE                        $2.
        @457   DEMO_TYPE                        $1.
        @458   SNP_TYPE                         $1.
        @459   FIDE_SNP                         $1.
        @460   DSNP_ZERODOLLAR                  $1.
        @461   DRUG_BENEFIT_TYPE                $1.
        @462   EGWP_INDICATOR                   $1.
        @463   EGHP_CALENDAR_YEAR_FLAG          $1.
        @464   COV_CRITERIA                     $1.
        @465   NATIONAL_PDP                     $1.
        @466   DEMINIMIS_PD_FLAG                $1.
        @467   DED_APPLY                        $1.
        @468   DED_AMT                          12.2
        @480   DED_APPLY_ALL                    $1.
        @481   DED_COSTSHARE_TIERS              $6.
        @487   DED_COPAY                        12.2
        @499   DED_COINS                        12.2
        @511   FREE_FIRST_FILL                  $1.
        @512   PRE_ICL_APPLY                    $1.
        @513   ICL_APPLY                        $1.
        @514   ICL_AMT                          12.2
        @526   POST_OOPT_APPLY                  $1.
        @527   OOPT_AMT                         12.2
        @539   EXCLUDED_DRUGS                   $1.
        @540   REDUCED_COST_SHARE               $1.
        @541   REDUCED_DED                      $1.
        @542   REDUCED_PREICL_CS                $1.
        @543   REDUCED_OOPT_CS                  $1.
        @544   INCREASED_ICL                    $1.
        @545   OTC_UM_PROGRAM                   $1.;
run;

title 'PLAN_CHAR_2017';
proc contents data=ccw.PLAN_CHAR_2017 varnum;
proc print data=ccw.PLAN_CHAR_2017(obs=5);
  title2 'Sample Listing - First 5 Rows';
run;
proc means data=ccw.PLAN_CHAR_2017;
  title2 'Simple Means';
run;

proc freq data=ccw.PLAN_CHAR_2017;
  title2 'Freqs';
  table
    COV_CRITERIA
    DED_APPLY
    DED_APPLY_ALL
    DEMINIMIS_PD_FLAG
    DEMO_TYPE
    DRUG_BENEFIT_TYPE
    DSNP_ZERODOLLAR
    EGHP_CALENDAR_YEAR_FLAG
    EGWP_INDICATOR
    EXCLUDED_DRUGS
    FIDE_SNP
    FREE_FIRST_FILL
    ICL_APPLY
    INCREASED_ICL
    NATIONAL_PDP
    ORGANIZATION_TYPE
    OTC_UM_PROGRAM
    PLAN_TYPE
    POST_OOPT_APPLY
    PRE_ICL_APPLY
    PTCD_INDICATOR
    REDUCED_COST_SHARE
    REDUCED_DED
    REDUCED_OOPT_CS
    REDUCED_PREICL_CS
    SNP_TYPE
        /missing;
run;

* End of Program *;
