* SAS Read-In Program
*
* Name: plan_crosswalk_2017_readin.sas
*
* Purpose: Read-In the delimited flat file PLAN_CROSSWALK_2017.
*
* Delimiter: Fixed Column
*
* Date: 17SEP18   Time: 17:42
*
* Help: cmsdata@gdit.com, 1-866-766-1915
*
*;

filename in  'plan_crosswalk_2017.dat'  lrecl=32768;
libname  ccw '.';

data ccw.PLAN_CROSSWALK_2017;
  length CONTRACT_ID_16                   $5
         PLAN_ID_16                       $3
         CONTRACT_ID_17                   $5
         PLAN_ID_17                       $3
         PTCD_INDICATOR_17                $1
         RELATIONSHIP_CODE                $1
         RELATIONSHIP_DESC                $15;

  format CONTRACT_ID_16                   $5.
         PLAN_ID_16                       $3.
         CONTRACT_ID_17                   $5.
         PLAN_ID_17                       $3.
         PTCD_INDICATOR_17                $1.
         RELATIONSHIP_CODE                $1.
         RELATIONSHIP_DESC                $15.;

  label  CONTRACT_ID_16                   = "Previous Year Part D Plan Contract Identifier"
         PLAN_ID_16                       = "Previous Year Part D Plan Benefit Identifier"
         CONTRACT_ID_17                   = "Reference Year Part D Plan Contract Identifier"
         PLAN_ID_17                       = "Reference Year Part D Plan Benefit Identifier"
         PTCD_INDICATOR_17                = "Indicates Whether the Reference Year Plan is Part C, Part D or Both"
         RELATIONSHIP_CODE                = "Relationship Code"
         RELATIONSHIP_DESC                = "Relationship Description";

  infile in missover truncover;

  input @01    CONTRACT_ID_16                   $5.
        @06    PLAN_ID_16                       $3.
        @09    CONTRACT_ID_17                   $5.
        @14    PLAN_ID_17                       $3.
        @17    PTCD_INDICATOR_17                $1.
        @18    RELATIONSHIP_CODE                $1.
        @19    RELATIONSHIP_DESC                $15.;
run;

title 'PLAN_CROSSWALK_2017';
proc contents data=ccw.PLAN_CROSSWALK_2017 varnum;
proc print data=ccw.PLAN_CROSSWALK_2017(obs=5);
  title2 'Sample Listing - First 5 Rows';
run;
proc means data=ccw.PLAN_CROSSWALK_2017;
  title2 'Simple Means';
run;

proc freq data=ccw.PLAN_CROSSWALK_2017;
  title2 'Freqs';
  table
    PTCD_INDICATOR_17
    RELATIONSHIP_CODE
        /missing;
run;

* End of Program *;
