* SAS Read-In Program
*
* Name: tier_2012_readin.sas
*
* Purpose: Read-In the delimited flat file TIER_2012.
*
* Delimiter: Fixed Column
*
* Date: 17DEC14   Time: 18:04
*
* Programmer: Adam Hendricks, Adam.Hendricks@gdit.com, 515-645-3015
*
*;

%let dirpath = .; * <--  Directory Path for Input Flat File in FILENAME Statement *;

filename in  "%trim(&dirpath)/tier_2012.dat" lrecl=1278;

libname  out '.'; * <--  Directory Path for Output Library in LIBNAME Statement   *;

* Start *;
data out.TIER_2012;
  length CONTRACT_ID                      $5
         PLAN_ID                          $3
         TIER_ID                          $2
         GAP_TIER                         $1
         GAP_TIER_PARTIAL                 $1
         EXCLUDED_TIER_GAP                $1
         EXCLUDED_TIER_PRE_ICL            $1
         SPECIALTY_TIER                   $1
         PRE_ICL_TIER_DRUG_TYPE           $6
         PRE_ICL_COSTSHARE_TYPE           $1
         PRE_ICL_INP_COINS_1M             8
         PRE_ICL_INP_COINS_3M             8
         PRE_ICL_INP_COINS_OS             8
         PRE_ICL_INPP_COINS_1M            8
         PRE_ICL_INPP_COINS_3M            8
         PRE_ICL_INPP_COINS_OS            8
         PRE_ICL_INNPP_COINS_1M           8
         PRE_ICL_INNPP_COINS_3M           8
         PRE_ICL_INNPP_COINS_OS           8
         PRE_ICL_OONP_COINS_1M            8
         PRE_ICL_OONP_COINS_OS            8
         PRE_ICL_MO_COINS_1M              8
         PRE_ICL_MO_COINS_3M              8
         PRE_ICL_MO_COINS_OS              8
         PRE_ICL_MOPP_COINS_1M            8
         PRE_ICL_MOPP_COINS_3M            8
         PRE_ICL_MOPP_COINS_OS            8
         PRE_ICL_MONPP_COINS_1M           8
         PRE_ICL_MONPP_COINS_3M           8
         PRE_ICL_MONPP_COINS_OS           8
         PRE_ICL_LTCP_COINS_1M            8
         PRE_ICL_INP_COPAY_1M             8
         PRE_ICL_INP_COPAY_3M             8
         PRE_ICL_INP_COPAY_OS             8
         PRE_ICL_INPP_COPAY_1M            8
         PRE_ICL_INPP_COPAY_3M            8
         PRE_ICL_INPP_COPAY_OS            8
         PRE_ICL_INNPP_COPAY_1M           8
         PRE_ICL_INNPP_COPAY_3M           8
         PRE_ICL_INNPP_COPAY_OS           8
         PRE_ICL_OONP_COPAY_1M            8
         PRE_ICL_OONP_COPAY_OS            8
         PRE_ICL_MO_COPAY_1M              8
         PRE_ICL_MO_COPAY_3M              8
         PRE_ICL_MO_COPAY_OS              8
         PRE_ICL_MOPP_COPAY_1M            8
         PRE_ICL_MOPP_COPAY_3M            8
         PRE_ICL_MOPP_COPAY_OS            8
         PRE_ICL_MONPP_COPAY_1M           8
         PRE_ICL_MONPP_COPAY_3M           8
         PRE_ICL_MONPP_COPAY_OS           8
         PRE_ICL_LTCP_COPAY_1M            8
         PRE_ICL_DAYS_INP_1M              8
         PRE_ICL_DAYS_INP_3M              8
         PRE_ICL_DAYS_INP_OS              8
         PRE_ICL_DAYS_INPP_1M             8
         PRE_ICL_DAYS_INPP_3M             8
         PRE_ICL_DAYS_INPP_OS             8
         PRE_ICL_DAYS_INNPP_1M            8
         PRE_ICL_DAYS_INNPP_3M            8
         PRE_ICL_DAYS_INNPP_OS            8
         PRE_ICL_DAYS_OONP_1M             8
         PRE_ICL_DAYS_OONP_OS             8
         PRE_ICL_DAYS_MO_1M               8
         PRE_ICL_DAYS_MO_3M               8
         PRE_ICL_DAYS_MO_OS               8
         PRE_ICL_DAYS_MOPP_1M             8
         PRE_ICL_DAYS_MOPP_3M             8
         PRE_ICL_DAYS_MOPP_OS             8
         PRE_ICL_DAYS_MONPP_1M            8
         PRE_ICL_DAYS_MONPP_3M            8
         PRE_ICL_DAYS_MONPP_OS            8
         PRE_ICL_DAYS_LTCP_1M             8
         GAP_TIER_DRUG_TYPE               $6
         GAP_COSTSHARE_TYPE               $1
         GAP_INP_COINS_1M                 8
         GAP_INP_COINS_3M                 8
         GAP_INP_COINS_OS                 8
         GAP_INPP_COINS_1M                8
         GAP_INPP_COINS_3M                8
         GAP_INPP_COINS_OS                8
         GAP_INNPP_COINS_1M               8
         GAP_INNPP_COINS_3M               8
         GAP_INNPP_COINS_OS               8
         GAP_OONP_COINS_1M                8
         GAP_OONP_COINS_OS                8
         GAP_MO_COINS_1M                  8
         GAP_MO_COINS_3M                  8
         GAP_MO_COINS_OS                  8
         GAP_MOPP_COINS_1M                8
         GAP_MOPP_COINS_3M                8
         GAP_MOPP_COINS_OS                8
         GAP_MONPP_COINS_1M               8
         GAP_MONPP_COINS_3M               8
         GAP_MONPP_COINS_OS               8
         GAP_LTCP_COINS_1M                8
         GAP_INP_COPAY_1M                 8
         GAP_INP_COPAY_3M                 8
         GAP_INP_COPAY_OS                 8
         GAP_INPP_COPAY_1M                8
         GAP_INPP_COPAY_3M                8
         GAP_INPP_COPAY_OS                8
         GAP_INNPP_COPAY_1M               8
         GAP_INNPP_COPAY_3M               8
         GAP_INNPP_COPAY_OS               8
         GAP_OONP_COPAY_1M                8
         GAP_OONP_COPAY_OS                8
         GAP_MO_COPAY_1M                  8
         GAP_MO_COPAY_3M                  8
         GAP_MO_COPAY_OS                  8
         GAP_MOPP_COPAY_1M                8
         GAP_MOPP_COPAY_3M                8
         GAP_MOPP_COPAY_OS                8
         GAP_MONPP_COPAY_1M               8
         GAP_MONPP_COPAY_3M               8
         GAP_MONPP_COPAY_OS               8
         GAP_LTCP_COPAY_1M                8
         GAP_DAYS_INP_1M                  8
         GAP_DAYS_INP_3M                  8
         GAP_DAYS_INP_OS                  8
         GAP_DAYS_INPP_1M                 8
         GAP_DAYS_INPP_3M                 8
         GAP_DAYS_INPP_OS                 8
         GAP_DAYS_INNPP_1M                8
         GAP_DAYS_INNPP_3M                8
         GAP_DAYS_INNPP_OS                8
         GAP_DAYS_OONP_1M                 8
         GAP_DAYS_OONP_OS                 8
         GAP_DAYS_MO_1M                   8
         GAP_DAYS_MO_3M                   8
         GAP_DAYS_MO_OS                   8
         GAP_DAYS_MOPP_1M                 8
         GAP_DAYS_MOPP_3M                 8
         GAP_DAYS_MOPP_OS                 8
         GAP_DAYS_MONPP_1M                8
         GAP_DAYS_MONPP_3M                8
         GAP_DAYS_MONPP_OS                8
         GAP_DAYS_LTCP_1M                 8
         POST_OOPT_TIER_DRUG_TYPE         $6
         POST_OOPT_COSTSHARE_TYPE         $1
         POST_OOPT_COINS_PCT              8
         POST_OOPT_COPAY_AMT              8;

  format CONTRACT_ID                      $5.
         PLAN_ID                          $3.
         TIER_ID                          $2.
         GAP_TIER                         $1.
         GAP_TIER_PARTIAL                 $1.
         EXCLUDED_TIER_GAP                $1.
         EXCLUDED_TIER_PRE_ICL            $1.
         SPECIALTY_TIER                   $1.
         PRE_ICL_TIER_DRUG_TYPE           $6.
         PRE_ICL_COSTSHARE_TYPE           $1.
         PRE_ICL_INP_COINS_1M             12.2
         PRE_ICL_INP_COINS_3M             12.2
         PRE_ICL_INP_COINS_OS             12.2
         PRE_ICL_INPP_COINS_1M            12.2
         PRE_ICL_INPP_COINS_3M            12.2
         PRE_ICL_INPP_COINS_OS            12.2
         PRE_ICL_INNPP_COINS_1M           12.2
         PRE_ICL_INNPP_COINS_3M           12.2
         PRE_ICL_INNPP_COINS_OS           12.2
         PRE_ICL_OONP_COINS_1M            12.2
         PRE_ICL_OONP_COINS_OS            12.2
         PRE_ICL_MO_COINS_1M              12.2
         PRE_ICL_MO_COINS_3M              12.2
         PRE_ICL_MO_COINS_OS              12.2
         PRE_ICL_MOPP_COINS_1M            12.2
         PRE_ICL_MOPP_COINS_3M            12.2
         PRE_ICL_MOPP_COINS_OS            12.2
         PRE_ICL_MONPP_COINS_1M           12.2
         PRE_ICL_MONPP_COINS_3M           12.2
         PRE_ICL_MONPP_COINS_OS           12.2
         PRE_ICL_LTCP_COINS_1M            12.2
         PRE_ICL_INP_COPAY_1M             12.2
         PRE_ICL_INP_COPAY_3M             12.2
         PRE_ICL_INP_COPAY_OS             12.2
         PRE_ICL_INPP_COPAY_1M            12.2
         PRE_ICL_INPP_COPAY_3M            12.2
         PRE_ICL_INPP_COPAY_OS            12.2
         PRE_ICL_INNPP_COPAY_1M           12.2
         PRE_ICL_INNPP_COPAY_3M           12.2
         PRE_ICL_INNPP_COPAY_OS           12.2
         PRE_ICL_OONP_COPAY_1M            12.2
         PRE_ICL_OONP_COPAY_OS            12.2
         PRE_ICL_MO_COPAY_1M              12.2
         PRE_ICL_MO_COPAY_3M              12.2
         PRE_ICL_MO_COPAY_OS              12.2
         PRE_ICL_MOPP_COPAY_1M            12.2
         PRE_ICL_MOPP_COPAY_3M            12.2
         PRE_ICL_MOPP_COPAY_OS            12.2
         PRE_ICL_MONPP_COPAY_1M           12.2
         PRE_ICL_MONPP_COPAY_3M           12.2
         PRE_ICL_MONPP_COPAY_OS           12.2
         PRE_ICL_LTCP_COPAY_1M            12.2
         PRE_ICL_DAYS_INP_1M              5.
         PRE_ICL_DAYS_INP_3M              5.
         PRE_ICL_DAYS_INP_OS              5.
         PRE_ICL_DAYS_INPP_1M             5.
         PRE_ICL_DAYS_INPP_3M             5.
         PRE_ICL_DAYS_INPP_OS             5.
         PRE_ICL_DAYS_INNPP_1M            5.
         PRE_ICL_DAYS_INNPP_3M            5.
         PRE_ICL_DAYS_INNPP_OS            5.
         PRE_ICL_DAYS_OONP_1M             5.
         PRE_ICL_DAYS_OONP_OS             5.
         PRE_ICL_DAYS_MO_1M               5.
         PRE_ICL_DAYS_MO_3M               5.
         PRE_ICL_DAYS_MO_OS               5.
         PRE_ICL_DAYS_MOPP_1M             5.
         PRE_ICL_DAYS_MOPP_3M             5.
         PRE_ICL_DAYS_MOPP_OS             5.
         PRE_ICL_DAYS_MONPP_1M            5.
         PRE_ICL_DAYS_MONPP_3M            5.
         PRE_ICL_DAYS_MONPP_OS            5.
         PRE_ICL_DAYS_LTCP_1M             5.
         GAP_TIER_DRUG_TYPE               $6.
         GAP_COSTSHARE_TYPE               $1.
         GAP_INP_COINS_1M                 12.2
         GAP_INP_COINS_3M                 12.2
         GAP_INP_COINS_OS                 12.2
         GAP_INPP_COINS_1M                12.2
         GAP_INPP_COINS_3M                12.2
         GAP_INPP_COINS_OS                12.2
         GAP_INNPP_COINS_1M               12.2
         GAP_INNPP_COINS_3M               12.2
         GAP_INNPP_COINS_OS               12.2
         GAP_OONP_COINS_1M                12.2
         GAP_OONP_COINS_OS                12.2
         GAP_MO_COINS_1M                  12.2
         GAP_MO_COINS_3M                  12.2
         GAP_MO_COINS_OS                  12.2
         GAP_MOPP_COINS_1M                12.2
         GAP_MOPP_COINS_3M                12.2
         GAP_MOPP_COINS_OS                12.2
         GAP_MONPP_COINS_1M               12.2
         GAP_MONPP_COINS_3M               12.2
         GAP_MONPP_COINS_OS               12.2
         GAP_LTCP_COINS_1M                12.2
         GAP_INP_COPAY_1M                 12.2
         GAP_INP_COPAY_3M                 12.2
         GAP_INP_COPAY_OS                 12.2
         GAP_INPP_COPAY_1M                12.2
         GAP_INPP_COPAY_3M                12.2
         GAP_INPP_COPAY_OS                12.2
         GAP_INNPP_COPAY_1M               12.2
         GAP_INNPP_COPAY_3M               12.2
         GAP_INNPP_COPAY_OS               12.2
         GAP_OONP_COPAY_1M                12.2
         GAP_OONP_COPAY_OS                12.2
         GAP_MO_COPAY_1M                  12.2
         GAP_MO_COPAY_3M                  12.2
         GAP_MO_COPAY_OS                  12.2
         GAP_MOPP_COPAY_1M                12.2
         GAP_MOPP_COPAY_3M                12.2
         GAP_MOPP_COPAY_OS                12.2
         GAP_MONPP_COPAY_1M               12.2
         GAP_MONPP_COPAY_3M               12.2
         GAP_MONPP_COPAY_OS               12.2
         GAP_LTCP_COPAY_1M                12.2
         GAP_DAYS_INP_1M                  5.
         GAP_DAYS_INP_3M                  5.
         GAP_DAYS_INP_OS                  5.
         GAP_DAYS_INPP_1M                 5.
         GAP_DAYS_INPP_3M                 5.
         GAP_DAYS_INPP_OS                 5.
         GAP_DAYS_INNPP_1M                5.
         GAP_DAYS_INNPP_3M                5.
         GAP_DAYS_INNPP_OS                5.
         GAP_DAYS_OONP_1M                 5.
         GAP_DAYS_OONP_OS                 5.
         GAP_DAYS_MO_1M                   5.
         GAP_DAYS_MO_3M                   5.
         GAP_DAYS_MO_OS                   5.
         GAP_DAYS_MOPP_1M                 5.
         GAP_DAYS_MOPP_3M                 5.
         GAP_DAYS_MOPP_OS                 5.
         GAP_DAYS_MONPP_1M                5.
         GAP_DAYS_MONPP_3M                5.
         GAP_DAYS_MONPP_OS                5.
         GAP_DAYS_LTCP_1M                 5.
         POST_OOPT_TIER_DRUG_TYPE         $6.
         POST_OOPT_COSTSHARE_TYPE         $1.
         POST_OOPT_COINS_PCT              12.2
         POST_OOPT_COPAY_AMT              12.2;

  label  CONTRACT_ID                      = "Contract ID"
         PLAN_ID                          = "Plan ID"
         TIER_ID                          = "Tier Number"
         GAP_TIER                         = "Indicates whether tier is covered in the gap"
         GAP_TIER_PARTIAL                 = "Indicates whether tier is partially covered in the gap"
         EXCLUDED_TIER_GAP                = "Indicates whether excluded drugs are covered on this tier in the gap phase"
         EXCLUDED_TIER_PRE_ICL            = "Indicates whether excluded drugs are covered on this tier in the Pre ICL phase"
         SPECIALTY_TIER                   = "Indicates whether tier is a specialty tier"
         PRE_ICL_TIER_DRUG_TYPE           = "Pre-ICL Tier Drug Type"
         PRE_ICL_COSTSHARE_TYPE           = "Pre-ICL Costshare Type"
         PRE_ICL_INP_COINS_1M             = "Pre-ICL Coinsurance In-Network Pharmacy - one month supply"
         PRE_ICL_INP_COINS_3M             = "Pre-ICL Coinsurance In-Network Pharmacy - three month supply"
         PRE_ICL_INP_COINS_OS             = "Pre-ICL Coinsurance In-Network Pharmacy - other day supply"
         PRE_ICL_INPP_COINS_1M            = "Pre-ICL Coinsurance In-Network Preferred Pharmacy - one month supply"
         PRE_ICL_INPP_COINS_3M            = "Pre-ICL Coinsurance In-Network Preferred Pharmacy - three month supply"
         PRE_ICL_INPP_COINS_OS            = "Pre-ICL Coinsurance In-Network Preferred Pharmacy - other day supply"
         PRE_ICL_INNPP_COINS_1M           = "Pre-ICL Coinsurance In-Network Non-Preferred Pharmacy - one month supply"
         PRE_ICL_INNPP_COINS_3M           = "Pre-ICL Coinsurance In-Network Non-Preferred Pharmacy - three month supply"
         PRE_ICL_INNPP_COINS_OS           = "Pre-ICL Coinsurance In-Network Non-Preferred Pharmacy - other day supply"
         PRE_ICL_OONP_COINS_1M            = "Pre-ICL Coinsurance Out-of-Network Pharmacy - one month supply"
         PRE_ICL_OONP_COINS_OS            = "Pre-ICL Coinsurance Out-of-Network Pharmacy - other day supply"
         PRE_ICL_MO_COINS_1M              = "Pre-ICL Coinsurance Mail Order Pharmacy - one month supply"
         PRE_ICL_MO_COINS_3M              = "Pre-ICL Coinsurance Mail Order Pharmacy - three month supply"
         PRE_ICL_MO_COINS_OS              = "Pre-ICL Coinsurance Mail Order Pharmacy - other day supply"
         PRE_ICL_MOPP_COINS_1M            = "Pre-ICL Coinsurance Mail Order Preferred Pharmacy - one month supply"
         PRE_ICL_MOPP_COINS_3M            = "Pre-ICL Coinsurance Mail Order Preferred Pharmacy - three month supply"
         PRE_ICL_MOPP_COINS_OS            = "Pre-ICL Coinsurance Mail Order Preferred Pharmacy - other day supply"
         PRE_ICL_MONPP_COINS_1M           = "Pre-ICL Coinsurance Mail Order Non-Preferred Pharmacy - one month supply"
         PRE_ICL_MONPP_COINS_3M           = "Pre-ICL Coinsurance Mail Order Non-Preferred Pharmacy - three month supply"
         PRE_ICL_MONPP_COINS_OS           = "Pre-ICL Coinsurance Mail Order Non-Preferred Pharmacy - other day supply"
         PRE_ICL_LTCP_COINS_1M            = "Pre-ICL Coinsurance Long Term Care Pharmacy - one month supply"
         PRE_ICL_INP_COPAY_1M             = "Pre-ICL Copay In-Network Pharmacy - one month supply"
         PRE_ICL_INP_COPAY_3M             = "Pre-ICL Copay In-Network Pharmacy - three month supply"
         PRE_ICL_INP_COPAY_OS             = "Pre-ICL Copay In-Network Pharmacy - other day supply"
         PRE_ICL_INPP_COPAY_1M            = "Pre-ICL Copay In-Network Preferred Pharmacy - one month supply"
         PRE_ICL_INPP_COPAY_3M            = "Pre-ICL Copay In-Network Preferred Pharmacy - three month supply"
         PRE_ICL_INPP_COPAY_OS            = "Pre-ICL Copay In-Network Preferred Pharmacy - other day supply"
         PRE_ICL_INNPP_COPAY_1M           = "Pre-ICL Copay In-Network Non-Preferred Pharmacy - one month supply"
         PRE_ICL_INNPP_COPAY_3M           = "Pre-ICL Copay In-Network Non-Preferred Pharmacy - three month supply"
         PRE_ICL_INNPP_COPAY_OS           = "Pre-ICL Copay In-Network Non-Preferred Pharmacy - other day supply"
         PRE_ICL_OONP_COPAY_1M            = "Pre-ICL Copay Out-of-Network Pharmacy - one month supply"
         PRE_ICL_OONP_COPAY_OS            = "Pre-ICL Copay Out-of-Network Pharmacy - other day supply"
         PRE_ICL_MO_COPAY_1M              = "Pre-ICL Copay Mail Order Pharmacy - one month supply"
         PRE_ICL_MO_COPAY_3M              = "Pre-ICL Copay Mail Order Pharmacy - three month supply"
         PRE_ICL_MO_COPAY_OS              = "Pre-ICL Copay Mail Order Pharmacy - other day supply"
         PRE_ICL_MOPP_COPAY_1M            = "Pre-ICL Copay Mail Order Preferred Pharmacy - one month supply"
         PRE_ICL_MOPP_COPAY_3M            = "Pre-ICL Copay Mail Order Preferred Pharmacy - three month supply"
         PRE_ICL_MOPP_COPAY_OS            = "Pre-ICL Copay Mail Order Preferred Pharmacy - other day supply"
         PRE_ICL_MONPP_COPAY_1M           = "Pre-ICL Copay Mail Order Non-Preferred Pharmacy - one month supply"
         PRE_ICL_MONPP_COPAY_3M           = "Pre-ICL Copay Mail Order Non-Preferred Pharmacy - three month supply"
         PRE_ICL_MONPP_COPAY_OS           = "Pre-ICL Copay Mail Order Non-Preferred Pharmacy - other day supply"
         PRE_ICL_LTCP_COPAY_1M            = "Pre-ICL Copay Long Term Care Pharmacy - one month supply"
         PRE_ICL_DAYS_INP_1M              = "Pre-ICL In-Network Pharmacy - number of days in one month supply"
         PRE_ICL_DAYS_INP_3M              = "Pre-ICL In-Network Pharmacy - number of days in three month supply"
         PRE_ICL_DAYS_INP_OS              = "Pre-ICL In-Network Pharmacy - number of days in other day supply"
         PRE_ICL_DAYS_INPP_1M             = "Pre-ICL In-Network Preferred Pharmacy - number of days in one month supply"
         PRE_ICL_DAYS_INPP_3M             = "Pre-ICL In-Network Preferred Pharmacy - number of days in three month supply"
         PRE_ICL_DAYS_INPP_OS             = "Pre-ICL In-Network Preferred Pharmacy - number of days in other day supply"
         PRE_ICL_DAYS_INNPP_1M            = "Pre-ICL In-Network Non-Preferred Pharmacy - number of days in one month supply"
         PRE_ICL_DAYS_INNPP_3M            = "Pre-ICL In-Network Non-Preferred Pharmacy - number of days in three month supply"
         PRE_ICL_DAYS_INNPP_OS            = "Pre-ICL In-Network Non-Preferred Pharmacy - number of days in other day supply"
         PRE_ICL_DAYS_OONP_1M             = "Pre-ICL Out-of-Network Pharmacy - number of days in one month supply"
         PRE_ICL_DAYS_OONP_OS             = "Pre-ICL Out-of-Network Pharmacy - number of days in other day supply"
         PRE_ICL_DAYS_MO_1M               = "Pre-ICL Mail Order Pharmacy - number of days in one month supply"
         PRE_ICL_DAYS_MO_3M               = "Pre-ICL Mail Order Pharmacy - number of days in three month supply"
         PRE_ICL_DAYS_MO_OS               = "Pre-ICL Mail Order Pharmacy - number of days in other day supply"
         PRE_ICL_DAYS_MOPP_1M             = "Pre-ICL Mail Order Preferred Pharmacy - number of days in one month supply"
         PRE_ICL_DAYS_MOPP_3M             = "Pre-ICL Mail Order Preferred Pharmacy - number of days in three month supply"
         PRE_ICL_DAYS_MOPP_OS             = "Pre-ICL Mail Order Preferred Pharmacy - number of days in other day supply"
         PRE_ICL_DAYS_MONPP_1M            = "Pre-ICL Mail Order Non-Preferred Pharmacy - number of days in one month supply"
         PRE_ICL_DAYS_MONPP_3M            = "Pre-ICL Mail Order Non-Preferred Pharmacy - number of days in three month supply"
         PRE_ICL_DAYS_MONPP_OS            = "Pre-ICL Mail Order Non-Preferred Pharmacy - number of days in other day supply"
         PRE_ICL_DAYS_LTCP_1M             = "Pre-ICL Long Term Care Pharmacy - number of days in one month supply"
         GAP_TIER_DRUG_TYPE               = "Gap Tier Drug Type"
         GAP_COSTSHARE_TYPE               = "Gap Cost Share Type"
         GAP_INP_COINS_1M                 = "Gap Coinsurance In-Network Pharmacy - one month supply"
         GAP_INP_COINS_3M                 = "Gap Coinsurance In-Network Pharmacy - three month supply"
         GAP_INP_COINS_OS                 = "Gap Coinsurance In-Network Pharmacy - other day supply"
         GAP_INPP_COINS_1M                = "Gap Coinsurance In-Network Preferred Pharmacy - one month supply"
         GAP_INPP_COINS_3M                = "Gap Coinsurance In-Network Preferred Pharmacy - three month supply"
         GAP_INPP_COINS_OS                = "Gap Coinsurance In-Network Preferred Pharmacy - other day supply"
         GAP_INNPP_COINS_1M               = "Gap Coinsurance In-Network Non-Preferred Pharmacy - one month supply"
         GAP_INNPP_COINS_3M               = "Gap Coinsurance In-Network Non-Preferred Pharmacy - three month supply"
         GAP_INNPP_COINS_OS               = "Gap Coinsurance In-Network Non-Preferred Pharmacy - other day supply"
         GAP_OONP_COINS_1M                = "Gap Coinsurance Out-of-Network Pharmacy - one month supply"
         GAP_OONP_COINS_OS                = "Gap Coinsurance Out-of-Network Pharmacy - other day supply"
         GAP_MO_COINS_1M                  = "Gap Coinsurance Mail Order Pharmacy - one month supply"
         GAP_MO_COINS_3M                  = "Gap Coinsurance Mail Order Pharmacy - three month supply"
         GAP_MO_COINS_OS                  = "Gap Coinsurance Mail Order Pharmacy - other day supply"
         GAP_MOPP_COINS_1M                = "Gap Coinsurance Mail Order Preferred Pharmacy - one month supply"
         GAP_MOPP_COINS_3M                = "Gap Coinsurance Mail Order Preferred Pharmacy - three month supply"
         GAP_MOPP_COINS_OS                = "Gap Coinsurance Mail Order Preferred Pharmacy - other day supply"
         GAP_MONPP_COINS_1M               = "Gap Coinsurance Mail Order Non-Preferred Pharmacy - one month supply"
         GAP_MONPP_COINS_3M               = "Gap Coinsurance Mail Order Non-Preferred Pharmacy - three month supply"
         GAP_MONPP_COINS_OS               = "Gap Coinsurance Mail Order Non-Preferred Pharmacy - other day supply"
         GAP_LTCP_COINS_1M                = "Gap Coinsurance Long Term Care Pharmacy - one month supply"
         GAP_INP_COPAY_1M                 = "Gap Copay In-Network Pharmacy - one month supply"
         GAP_INP_COPAY_3M                 = "Gap Copay In-Network Pharmacy - three month supply"
         GAP_INP_COPAY_OS                 = "Gap Copay In-Network Pharmacy - other day supply"
         GAP_INPP_COPAY_1M                = "Gap Copay In-Network Preferred Pharmacy - one month supply"
         GAP_INPP_COPAY_3M                = "Gap Copay In-Network Preferred Pharmacy - three month supply"
         GAP_INPP_COPAY_OS                = "Gap Copay In-Network Preferred Pharmacy - other day supply"
         GAP_INNPP_COPAY_1M               = "Gap Copay In-Network Non-Preferred Pharmacy - one month supply"
         GAP_INNPP_COPAY_3M               = "Gap Copay In-Network Non-Preferred Pharmacy - three month supply"
         GAP_INNPP_COPAY_OS               = "Gap Copay In-Network Non-Preferred Pharmacy - other day supply"
         GAP_OONP_COPAY_1M                = "Gap Copay Out-of-Network Pharmacy - one month supply"
         GAP_OONP_COPAY_OS                = "Gap Copay Out-of-Network Pharmacy - other day supply"
         GAP_MO_COPAY_1M                  = "Gap Copay Mail Order Pharmacy - one month supply"
         GAP_MO_COPAY_3M                  = "Gap Copay Mail Order Pharmacy - three month supply"
         GAP_MO_COPAY_OS                  = "Gap Copay Mail Order Pharmacy - other day supply"
         GAP_MOPP_COPAY_1M                = "Gap Copay Mail Order Preferred Pharmacy - one month supply"
         GAP_MOPP_COPAY_3M                = "Gap Copay Mail Order Preferred Pharmacy - three month supply"
         GAP_MOPP_COPAY_OS                = "Gap Copay Mail Order Preferred Pharmacy - other day supply"
         GAP_MONPP_COPAY_1M               = "Gap Copay Mail Order Non-Preferred Pharmacy - one month supply"
         GAP_MONPP_COPAY_3M               = "Gap Copay Mail Order Non-Preferred Pharmacy - three month supply"
         GAP_MONPP_COPAY_OS               = "Gap Copay Mail Order Non-Preferred Pharmacy - other day supply"
         GAP_LTCP_COPAY_1M                = "Gap Copay Long Term Care Pharmacy - one month supply"
         GAP_DAYS_INP_1M                  = "Gap In-Network Pharmacy - number of days in one month supply"
         GAP_DAYS_INP_3M                  = "Gap In-Network Pharmacy - number of days in three month supply"
         GAP_DAYS_INP_OS                  = "Gap In-Network Pharmacy - number of days in other day supply"
         GAP_DAYS_INPP_1M                 = "Gap In-Network Preferred Pharmacy - number of days in one month supply"
         GAP_DAYS_INPP_3M                 = "Gap In-Network Preferred Pharmacy - number of days in three month supply"
         GAP_DAYS_INPP_OS                 = "Gap In-Network Preferred Pharmacy - number of days in other day supply"
         GAP_DAYS_INNPP_1M                = "Gap In-Network Non-Preferred Pharmacy - number of days in one month supply"
         GAP_DAYS_INNPP_3M                = "Gap In-Network Non-Preferred Pharmacy - number of days in three month supply"
         GAP_DAYS_INNPP_OS                = "Gap In-Network Non-Preferred Pharmacy - number of days in other day supply"
         GAP_DAYS_OONP_1M                 = "Gap Out-of-Network Pharmacy - number of days in one month supply"
         GAP_DAYS_OONP_OS                 = "Gap Out-of-Network Pharmacy - number of days in other day supply"
         GAP_DAYS_MO_1M                   = "Gap Mail Order Pharmacy - number of days in one month supply"
         GAP_DAYS_MO_3M                   = "Gap Mail Order Pharmacy - number of days in three month supply"
         GAP_DAYS_MO_OS                   = "Gap Mail Order Pharmacy - number of days in other day supply"
         GAP_DAYS_MOPP_1M                 = "Gap Mail Order Preferred Pharmacy - number of days in one month supply"
         GAP_DAYS_MOPP_3M                 = "Gap Mail Order Preferred Pharmacy - number of days in three month supply"
         GAP_DAYS_MOPP_OS                 = "Gap Mail Order Preferred Pharmacy - number of days in other day supply"
         GAP_DAYS_MONPP_1M                = "Gap Mail Order Non-Preferred Pharmacy - number of days in one month supply"
         GAP_DAYS_MONPP_3M                = "Gap Mail Order Non-Preferred Pharmacy - number of days in three month supply"
         GAP_DAYS_MONPP_OS                = "Gap Mail Order Non-Preferred Pharmacy - number of days in other day supply"
         GAP_DAYS_LTCP_1M                 = "Gap Long Term Care Pharmacy - number of days in one month supply"
         POST_OOPT_TIER_DRUG_TYPE         = "Post-Out-of-pocket threshold tier drug type"
         POST_OOPT_COSTSHARE_TYPE         = "Post-Out-of-pocket threshold costshare type"
         POST_OOPT_COINS_PCT              = "Post-Out-of-pocket threshold Coinsurance"
         POST_OOPT_COPAY_AMT              = "Post-Out-of-pocket threshold Copay";

  infile in missover truncover;

  input @0001  CONTRACT_ID                      $5.
        @0006  PLAN_ID                          $3.
        @0009  TIER_ID                          $2.
        @0011  GAP_TIER                         $1.
        @0012  GAP_TIER_PARTIAL                 $1.
        @0013  EXCLUDED_TIER_GAP                $1.
        @0014  EXCLUDED_TIER_PRE_ICL            $1.
        @0015  SPECIALTY_TIER                   $1.
        @0016  PRE_ICL_TIER_DRUG_TYPE           $6.
        @0022  PRE_ICL_COSTSHARE_TYPE           $1.
        @0023  PRE_ICL_INP_COINS_1M             12.2
        @0035  PRE_ICL_INP_COINS_3M             12.2
        @0047  PRE_ICL_INP_COINS_OS             12.2
        @0059  PRE_ICL_INPP_COINS_1M            12.2
        @0071  PRE_ICL_INPP_COINS_3M            12.2
        @0083  PRE_ICL_INPP_COINS_OS            12.2
        @0095  PRE_ICL_INNPP_COINS_1M           12.2
        @0107  PRE_ICL_INNPP_COINS_3M           12.2
        @0119  PRE_ICL_INNPP_COINS_OS           12.2
        @0131  PRE_ICL_OONP_COINS_1M            12.2
        @0143  PRE_ICL_OONP_COINS_OS            12.2
        @0155  PRE_ICL_MO_COINS_1M              12.2
        @0167  PRE_ICL_MO_COINS_3M              12.2
        @0179  PRE_ICL_MO_COINS_OS              12.2
        @0191  PRE_ICL_MOPP_COINS_1M            12.2
        @0203  PRE_ICL_MOPP_COINS_3M            12.2
        @0215  PRE_ICL_MOPP_COINS_OS            12.2
        @0227  PRE_ICL_MONPP_COINS_1M           12.2
        @0239  PRE_ICL_MONPP_COINS_3M           12.2
        @0251  PRE_ICL_MONPP_COINS_OS           12.2
        @0263  PRE_ICL_LTCP_COINS_1M            12.2
        @0275  PRE_ICL_INP_COPAY_1M             12.2
        @0287  PRE_ICL_INP_COPAY_3M             12.2
        @0299  PRE_ICL_INP_COPAY_OS             12.2
        @0311  PRE_ICL_INPP_COPAY_1M            12.2
        @0323  PRE_ICL_INPP_COPAY_3M            12.2
        @0335  PRE_ICL_INPP_COPAY_OS            12.2
        @0347  PRE_ICL_INNPP_COPAY_1M           12.2
        @0359  PRE_ICL_INNPP_COPAY_3M           12.2
        @0371  PRE_ICL_INNPP_COPAY_OS           12.2
        @0383  PRE_ICL_OONP_COPAY_1M            12.2
        @0395  PRE_ICL_OONP_COPAY_OS            12.2
        @0407  PRE_ICL_MO_COPAY_1M              12.2
        @0419  PRE_ICL_MO_COPAY_3M              12.2
        @0431  PRE_ICL_MO_COPAY_OS              12.2
        @0443  PRE_ICL_MOPP_COPAY_1M            12.2
        @0455  PRE_ICL_MOPP_COPAY_3M            12.2
        @0467  PRE_ICL_MOPP_COPAY_OS            12.2
        @0479  PRE_ICL_MONPP_COPAY_1M           12.2
        @0491  PRE_ICL_MONPP_COPAY_3M           12.2
        @0503  PRE_ICL_MONPP_COPAY_OS           12.2
        @0515  PRE_ICL_LTCP_COPAY_1M            12.2
        @0527  PRE_ICL_DAYS_INP_1M              5.
        @0532  PRE_ICL_DAYS_INP_3M              5.
        @0537  PRE_ICL_DAYS_INP_OS              5.
        @0542  PRE_ICL_DAYS_INPP_1M             5.
        @0547  PRE_ICL_DAYS_INPP_3M             5.
        @0552  PRE_ICL_DAYS_INPP_OS             5.
        @0557  PRE_ICL_DAYS_INNPP_1M            5.
        @0562  PRE_ICL_DAYS_INNPP_3M            5.
        @0567  PRE_ICL_DAYS_INNPP_OS            5.
        @0572  PRE_ICL_DAYS_OONP_1M             5.
        @0577  PRE_ICL_DAYS_OONP_OS             5.
        @0582  PRE_ICL_DAYS_MO_1M               5.
        @0587  PRE_ICL_DAYS_MO_3M               5.
        @0592  PRE_ICL_DAYS_MO_OS               5.
        @0597  PRE_ICL_DAYS_MOPP_1M             5.
        @0602  PRE_ICL_DAYS_MOPP_3M             5.
        @0607  PRE_ICL_DAYS_MOPP_OS             5.
        @0612  PRE_ICL_DAYS_MONPP_1M            5.
        @0617  PRE_ICL_DAYS_MONPP_3M            5.
        @0622  PRE_ICL_DAYS_MONPP_OS            5.
        @0627  PRE_ICL_DAYS_LTCP_1M             5.
        @0632  GAP_TIER_DRUG_TYPE               $6.
        @0638  GAP_COSTSHARE_TYPE               $1.
        @0639  GAP_INP_COINS_1M                 12.2
        @0651  GAP_INP_COINS_3M                 12.2
        @0663  GAP_INP_COINS_OS                 12.2
        @0675  GAP_INPP_COINS_1M                12.2
        @0687  GAP_INPP_COINS_3M                12.2
        @0699  GAP_INPP_COINS_OS                12.2
        @0711  GAP_INNPP_COINS_1M               12.2
        @0723  GAP_INNPP_COINS_3M               12.2
        @0735  GAP_INNPP_COINS_OS               12.2
        @0747  GAP_OONP_COINS_1M                12.2
        @0759  GAP_OONP_COINS_OS                12.2
        @0771  GAP_MO_COINS_1M                  12.2
        @0783  GAP_MO_COINS_3M                  12.2
        @0795  GAP_MO_COINS_OS                  12.2
        @0807  GAP_MOPP_COINS_1M                12.2
        @0819  GAP_MOPP_COINS_3M                12.2
        @0831  GAP_MOPP_COINS_OS                12.2
        @0843  GAP_MONPP_COINS_1M               12.2
        @0855  GAP_MONPP_COINS_3M               12.2
        @0867  GAP_MONPP_COINS_OS               12.2
        @0879  GAP_LTCP_COINS_1M                12.2
        @0891  GAP_INP_COPAY_1M                 12.2
        @0903  GAP_INP_COPAY_3M                 12.2
        @0915  GAP_INP_COPAY_OS                 12.2
        @0927  GAP_INPP_COPAY_1M                12.2
        @0939  GAP_INPP_COPAY_3M                12.2
        @0951  GAP_INPP_COPAY_OS                12.2
        @0963  GAP_INNPP_COPAY_1M               12.2
        @0975  GAP_INNPP_COPAY_3M               12.2
        @0987  GAP_INNPP_COPAY_OS               12.2
        @0999  GAP_OONP_COPAY_1M                12.2
        @1011  GAP_OONP_COPAY_OS                12.2
        @1023  GAP_MO_COPAY_1M                  12.2
        @1035  GAP_MO_COPAY_3M                  12.2
        @1047  GAP_MO_COPAY_OS                  12.2
        @1059  GAP_MOPP_COPAY_1M                12.2
        @1071  GAP_MOPP_COPAY_3M                12.2
        @1083  GAP_MOPP_COPAY_OS                12.2
        @1095  GAP_MONPP_COPAY_1M               12.2
        @1107  GAP_MONPP_COPAY_3M               12.2
        @1119  GAP_MONPP_COPAY_OS               12.2
        @1131  GAP_LTCP_COPAY_1M                12.2
        @1143  GAP_DAYS_INP_1M                  5.
        @1148  GAP_DAYS_INP_3M                  5.
        @1153  GAP_DAYS_INP_OS                  5.
        @1158  GAP_DAYS_INPP_1M                 5.
        @1163  GAP_DAYS_INPP_3M                 5.
        @1168  GAP_DAYS_INPP_OS                 5.
        @1173  GAP_DAYS_INNPP_1M                5.
        @1178  GAP_DAYS_INNPP_3M                5.
        @1183  GAP_DAYS_INNPP_OS                5.
        @1188  GAP_DAYS_OONP_1M                 5.
        @1193  GAP_DAYS_OONP_OS                 5.
        @1198  GAP_DAYS_MO_1M                   5.
        @1203  GAP_DAYS_MO_3M                   5.
        @1208  GAP_DAYS_MO_OS                   5.
        @1213  GAP_DAYS_MOPP_1M                 5.
        @1218  GAP_DAYS_MOPP_3M                 5.
        @1223  GAP_DAYS_MOPP_OS                 5.
        @1228  GAP_DAYS_MONPP_1M                5.
        @1233  GAP_DAYS_MONPP_3M                5.
        @1238  GAP_DAYS_MONPP_OS                5.
        @1243  GAP_DAYS_LTCP_1M                 5.
        @1248  POST_OOPT_TIER_DRUG_TYPE         $6.
        @1254  POST_OOPT_COSTSHARE_TYPE         $1.
        @1255  POST_OOPT_COINS_PCT              12.2
        @1267  POST_OOPT_COPAY_AMT              12.2;
run;

title 'Part D Tier Characteristics 2012';
proc contents data=out.TIER_2012 varnum;
proc print data=out.TIER_2012(obs=5);
  title2 'Sample Listing - First 5 Rows';
run;
proc means data=out.TIER_2012;
  title2 'Simple Means';
run;

proc freq data=out.TIER_2012;
  title2 'Freqs';
  table EXCLUDED_TIER_GAP
        EXCLUDED_TIER_PRE_ICL
        GAP_COSTSHARE_TYPE
        GAP_TIER
        GAP_TIER_PARTIAL
        POST_OOPT_COSTSHARE_TYPE
        PRE_ICL_COSTSHARE_TYPE
        SPECIALTY_TIER
        TIER_ID/missing;
run;

* End of Program *;
