* SAS Read-In Program
*
* Name: plan_id_bridge_file_readin.sas
*
* Purpose: Read-In the delimited flat file PLAN_ID_BRIDGE_FILE.
*
* Delimiter: Fixed Column
*
* Date: 12JAN15   Time: 15:28
*
* Programmer: Adam Hendricks, Adam.Hendricks@gdit.com, 515-645-3015
*
*;

%let dirpath = .; * <--  Directory Path for Input Flat File in FILENAME Statement *;

filename in  "%trim(&dirpath)/plan_id_bridge_file.dat" lrecl=477;

libname  out '.'; * <--  Directory Path for Output Library in LIBNAME Statement   *;

* Start *;
data out.PLAN_ID_BRIDGE_FILE;
  length YEAR                             4
         CONTRACT_ID                      $5
         PLAN_ID                          $3
         SEGMENT_ID                       $3
         FORMULARY_ID                     $8
         CONTRACT_ID_ENCRYPTED            $5
         PLAN_ID_ENCRYPTED                $3
         SEGMENT_ID_ENCRYPTED             $3
         FORMULARY_ID_ENCRYPTED           $8
         CONTRACT_NAME                    $150
         PLAN_NAME                        $75
         ORGANIZATION_MARKETING_NAME      $150
         PARENT_ORGANIZATION              $50
         EFFECTIVE_DATE                   $10;

  format YEAR                             4.
         CONTRACT_ID                      $5.
         PLAN_ID                          $3.
         SEGMENT_ID                       $3.
         FORMULARY_ID                     $8.
         CONTRACT_ID_ENCRYPTED            $5.
         PLAN_ID_ENCRYPTED                $3.
         SEGMENT_ID_ENCRYPTED             $3.
         FORMULARY_ID_ENCRYPTED           $8.
         CONTRACT_NAME                    $150.
         PLAN_NAME                        $75.
         ORGANIZATION_MARKETING_NAME      $150.
         PARENT_ORGANIZATION              $50.
         EFFECTIVE_DATE                   $10.;

  label  YEAR                             = "Reference Year"
         CONTRACT_ID                      = "Unencrypted Contract ID"
         PLAN_ID                          = "Unencrypted Plan (PBP) ID"
         SEGMENT_ID                       = "Unencrypted Segment ID"
         FORMULARY_ID                     = "Unencrypted Formulary ID"
         CONTRACT_ID_ENCRYPTED            = "Encrypted Contract ID"
         PLAN_ID_ENCRYPTED                = "Encrypted Plan (PBP) ID"
         SEGMENT_ID_ENCRYPTED             = "Encrypted Segment ID"
         FORMULARY_ID_ENCRYPTED           = "Encrypted Formulary ID"
         CONTRACT_NAME                    = "Contract Name"
         PLAN_NAME                        = "Plan Name"
         ORGANIZATION_MARKETING_NAME      = "Organization Marketing Name"
         PARENT_ORGANIZATION              = "Parent Organization Name"
         EFFECTIVE_DATE                   = "Effective Date";

  infile in missover truncover;

  input @001   YEAR                             4.
        @005   CONTRACT_ID                      $5.
        @010   PLAN_ID                          $3.
        @013   SEGMENT_ID                       $3.
        @016   FORMULARY_ID                     $8.
        @024   CONTRACT_ID_ENCRYPTED            $5.
        @029   PLAN_ID_ENCRYPTED                $3.
        @032   SEGMENT_ID_ENCRYPTED             $3.
        @035   FORMULARY_ID_ENCRYPTED           $8.
        @043   CONTRACT_NAME                    $150.
        @193   PLAN_NAME                        $75.
        @268   ORGANIZATION_MARKETING_NAME      $150.
        @418   PARENT_ORGANIZATION              $50.
        @468   EFFECTIVE_DATE                   $10.;
run;

title 'Part D Plan ID Bridge File';
proc contents data=out.PLAN_ID_BRIDGE_FILE varnum;
proc print data=out.PLAN_ID_BRIDGE_FILE(obs=5);
  title2 'Sample Listing - First 5 Rows';
run;
proc means data=out.PLAN_ID_BRIDGE_FILE;
  title2 'Simple Means';
run;

* End of Program *;
