* SAS Read-In Program
*
* Name: plan_char_2011_readin.sas
*
* Purpose: Read-In the delimited flat file PLAN_CHAR_2011.
*
* Delimiter: Fixed Column
*
* Date: 22DEC14   Time: 16:18
*
* Programmer: Adam Hendricks, Adam.Hendricks@gdit.com, 515-645-3015
*
*;

%let dirpath = .; * <--  Directory Path for Input Flat File in FILENAME Statement *;

filename in  "%trim(&dirpath)/plan_char_2011.dat" lrecl=870;

libname  out '.'; * <--  Directory Path for Output Library in LIBNAME Statement   *;

* Start *;
data out.PLAN_CHAR_2011;
  length CONTRACT_ID                      $5
         PLAN_ID                          $3
         FORMULARY_ID                     $8
         CONTRACT_NAME                    $150
         PLAN_NAME                        $75
         ORGANIZATION_MARKETING_NAME      $150
         EFFECTIVE_DATE                   $10
         ORGANIZATION_TYPE                $2
         PLAN_TYPE                        $2
         DEMO_TYPE                        $1
         SNP_TYPE                         $1
         DRUG_BENEFIT_TYPE                $1
         EGWP_INDICATOR                   $1
         EGHP_CALENDAR_YEAR_FLAG          $1
         COV_CRITERIA                     $1
         NATIONAL_PDP                     $1
         GAP_COVERAGE_TYPE                $2
         DEMINIMIS_PD_FLAG                $1
         DED_APPLY                        $1
         DED_AMT                          8
         DED_APPLY_ALL                    $1
         DED_COSTSHARE_TIERS              $6
         DED_COPAY                        8
         DED_COINS                        8
         FREE_FIRST_FILL                  $1
         PRE_ICL_APPLY                    $1
         ICL_APPLY                        $1
         ICL_AMT                          8
         POST_OOPT_APPLY                  $1
         OOPT_AMT                         8
         EXCLUDED_DRUGS                   $1
         REDUCED_COST_SHARE               $1
         REDUCED_DED                      $1
         REDUCED_PREICL_CS                $1
         REDUCED_GAP_CS                   $1
         REDUCED_OOPT_CS                  $1
         INCREASED_ICL                    $1
         SPECIALTY_TIER                   $2
         NAT_RX_COV_YN                    $1
         OTC_UM_PROGRAM                   $1
         PRE_ICL_DRUG_TYPE_TIER_01-PRE_ICL_DRUG_TYPE_TIER_06       $6
         PRE_ICL_INP_1M_COPAY_TIER_01-PRE_ICL_INP_1M_COPAY_TIER_06 8
         PRE_ICL_INP_1M_COINS_TIER_01-PRE_ICL_INP_1M_COINS_TIER_06 8
         GAP_TIER_01-GAP_TIER_06                                   $1
         GAP_PARTIAL_TIER_01-GAP_PARTIAL_TIER_06                   $1
         GAP_DRUG_type_tier_01-GAP_DRUG_TYPE_TIER_06               $6
         GAP_INP_1M_COPAY_TIER_01-GAP_INP_1M_COPAY_TIER_06         8
         GAP_INP_1M_COINS_TIER_01-GAP_INP_1M_COINS_TIER_06         8;

  format CONTRACT_ID                      $5.
         PLAN_ID                          $3.
         FORMULARY_ID                     $8.
         CONTRACT_NAME                    $150.
         PLAN_NAME                        $75.
         ORGANIZATION_MARKETING_NAME      $150.
         EFFECTIVE_DATE                   $10.
         ORGANIZATION_TYPE                $2.
         PLAN_TYPE                        $2.
         DEMO_TYPE                        $1.
         SNP_TYPE                         $1.
         DRUG_BENEFIT_TYPE                $1.
         EGWP_INDICATOR                   $1.
         EGHP_CALENDAR_YEAR_FLAG          $1.
         COV_CRITERIA                     $1.
         NATIONAL_PDP                     $1.
         GAP_COVERAGE_TYPE                $2.
         DEMINIMIS_PD_FLAG                $1.
         DED_APPLY                        $1.
         DED_AMT                          12.2
         DED_APPLY_ALL                    $1.
         DED_COSTSHARE_TIERS              $6.
         DED_COPAY                        12.2
         DED_COINS                        12.2
         FREE_FIRST_FILL                  $1.
         PRE_ICL_APPLY                    $1.
         ICL_APPLY                        $1.
         ICL_AMT                          12.2
         POST_OOPT_APPLY                  $1.
         OOPT_AMT                         12.2
         EXCLUDED_DRUGS                   $1.
         REDUCED_COST_SHARE               $1.
         REDUCED_DED                      $1.
         REDUCED_PREICL_CS                $1.
         REDUCED_GAP_CS                   $1.
         REDUCED_OOPT_CS                  $1.
         INCREASED_ICL                    $1.
         SPECIALTY_TIER                   $2.
         NAT_RX_COV_YN                    $1.
         OTC_UM_PROGRAM                   $1.
         PRE_ICL_DRUG_TYPE_TIER_01-PRE_ICL_DRUG_TYPE_TIER_06       $6.
         PRE_ICL_INP_1M_COPAY_TIER_01-PRE_ICL_INP_1M_COPAY_TIER_06 12.2
         PRE_ICL_INP_1M_COINS_TIER_01-PRE_ICL_INP_1M_COINS_TIER_06 12.2
         GAP_TIER_01-GAP_TIER_06                                   $1.
         GAP_PARTIAL_TIER_01-GAP_PARTIAL_TIER_06                   $1.
         GAP_DRUG_TYPE_TIER_01-GAP_DRUG_TYPE_TIER_06               $6.
         GAP_INP_1M_COPAY_TIER_01-GAP_INP_1M_COPAY_TIER_06         12.2
         GAP_INP_1M_COINS_TIER_01-GAP_INP_1M_COINS_TIER_06         12.2;

  label  CONTRACT_ID                      = "Contract ID"
         PLAN_ID                          = "Plan ID"
         FORMULARY_ID                     = "Formulary Identifier"
         CONTRACT_NAME                    = "Contract Name"
         PLAN_NAME                        = "Plan Name"
         ORGANIZATION_MARKETING_NAME      = "Organization Marketing Name"
         EFFECTIVE_DATE                   = "Effective Date"
         ORGANIZATION_TYPE                = "Organization Type"
         PLAN_TYPE                        = "Plan Type"
         DEMO_TYPE                        = "Demo Type"
         SNP_TYPE                         = "SNP Type"
         DRUG_BENEFIT_TYPE                = "Drug Benefit Type"
         EGWP_INDICATOR                   = "Employer Plan Indicator"
         EGHP_CALENDAR_YEAR_FLAG          = "EGHP Calendar Year Indicator"
         COV_CRITERIA                     = "Coverage Criteria (A/B or B only)"
         NATIONAL_PDP                     = "Indicates whether plan belongs to a National PDP sponsor"
         GAP_COVERAGE_TYPE                = "Type of Gap Coverage Offered"
         DEMINIMIS_PD_FLAG                = "Deminimis Paid Flag"
         DED_APPLY                        = "How Deductible is applied"
         DED_AMT                          = "Deductible Amount"
         DED_APPLY_ALL                    = "Type of Cost Sharing in the Deductible Phase"
         DED_COSTSHARE_TIERS              = "Tiers with Cost Sharing in the Deductible Phase"
         DED_COPAY                        = "Deductible Phase Copay Amount"
         DED_COINS                        = "Deductible Phase Coinsurance Percentage"
         FREE_FIRST_FILL                  = "Indicates whether first prescription fill is free of charge"
         PRE_ICL_APPLY                    = "How Pre-ICL cost shares are applied"
         ICL_APPLY                        = "How ICL is applied"
         ICL_AMT                          = "ICL Amount"
         POST_OOPT_APPLY                  = "How Post OOP threshold cost shares are applied"
         OOPT_AMT                         = "OOP Threshold Amount"
         EXCLUDED_DRUGS                   = "Indicates whether the plan covers Part D excluded drugs"
         REDUCED_COST_SHARE               = "Indicates whether the plan has reduced cost sharing below Medicare standard"
         REDUCED_DED                      = "Flag for reduced deductible amount"
         REDUCED_PREICL_CS                = "Flag for reduced pre-ICL cost sharing amounts"
         REDUCED_GAP_CS                   = "Flag for reduced coverage gap cost sharing amounts"
         REDUCED_OOPT_CS                  = "Flag for reduced post out-of-pocket threshold cost sharing amounts"
         INCREASED_ICL                    = "Flag for increased Initial Coverage Limit"
         SPECIALTY_TIER                   = "Specialty Tier Number"
         NAT_RX_COV_YN                    = "Plan offers national prescription coverage"
         OTC_UM_PROGRAM                   = "Plan pays for Over-the-Counter medications (OTCs) under the Utilization Management Program"
         PRE_ICL_DRUG_TYPE_TIER_01        = "Pre-ICL Drug Type for Tier 1"
         PRE_ICL_DRUG_TYPE_TIER_02        = "Pre-ICL Drug Type for Tier 2"
         PRE_ICL_DRUG_TYPE_TIER_03        = "Pre-ICL Drug Type for Tier 3"
         PRE_ICL_DRUG_TYPE_TIER_04        = "Pre-ICL Drug Type for Tier 4"
         PRE_ICL_DRUG_TYPE_TIER_05        = "Pre-ICL Drug Type for Tier 5"
         PRE_ICL_DRUG_TYPE_TIER_06        = "Pre-ICL Drug Type for Tier 6"
         PRE_ICL_INP_1M_COPAY_TIER_01     = "Pre-ICL In-network Pharmacy 1 month Copay for Tier 1"
         PRE_ICL_INP_1M_COPAY_TIER_02     = "Pre-ICL In-network Pharmacy 1 month Copay for Tier 2"
         PRE_ICL_INP_1M_COPAY_TIER_03     = "Pre-ICL In-network Pharmacy 1 month Copay for Tier 3"
         PRE_ICL_INP_1M_COPAY_TIER_04     = "Pre-ICL In-network Pharmacy 1 month Copay for Tier 4"
         PRE_ICL_INP_1M_COPAY_TIER_05     = "Pre-ICL In-network Pharmacy 1 month Copay for Tier 5"
         PRE_ICL_INP_1M_COPAY_TIER_06     = "Pre-ICL In-network Pharmacy 1 month Copay for Tier 6"
         PRE_ICL_INP_1M_COINS_TIER_01     = "Pre-ICL In-network Pharmacy 1 month Coinsurance for Tier 1"
         PRE_ICL_INP_1M_COINS_TIER_02     = "Pre-ICL In-network Pharmacy 1 month Coinsurance for Tier 2"
         PRE_ICL_INP_1M_COINS_TIER_03     = "Pre-ICL In-network Pharmacy 1 month Coinsurance for Tier 3"
         PRE_ICL_INP_1M_COINS_TIER_04     = "Pre-ICL In-network Pharmacy 1 month Coinsurance for Tier 4"
         PRE_ICL_INP_1M_COINS_TIER_05     = "Pre-ICL In-network Pharmacy 1 month Coinsurance for Tier 5"
         PRE_ICL_INP_1M_COINS_TIER_06     = "Pre-ICL In-network Pharmacy 1 month Coinsurance for Tier 6"
         GAP_TIER_01                      = "Gap Coverage on Tier 1"
         GAP_TIER_02                      = "Gap Coverage on Tier 2"
         GAP_TIER_03                      = "Gap Coverage on Tier 3"
         GAP_TIER_04                      = "Gap Coverage on Tier 4"
         GAP_TIER_05                      = "Gap Coverage on Tier 5"
         GAP_TIER_06                      = "Gap Coverage on Tier 6"
         GAP_PARTIAL_TIER_01              = "Partial Gap Coverage on Tier 1"
         GAP_PARTIAL_TIER_02              = "Partial Gap Coverage on Tier 2"
         GAP_PARTIAL_TIER_03              = "Partial Gap Coverage on Tier 3"
         GAP_PARTIAL_TIER_04              = "Partial Gap Coverage on Tier 4"
         GAP_PARTIAL_TIER_05              = "Partial Gap Coverage on Tier 5"
         GAP_PARTIAL_TIER_06              = "Partial Gap Coverage on Tier 6"
         GAP_DRUG_TYPE_TIER_01            = "Gap Drug Type for Tier 1"
         GAP_DRUG_TYPE_TIER_02            = "Gap Drug Type for Tier 2"
         GAP_DRUG_TYPE_TIER_03            = "Gap Drug Type for Tier 3"
         GAP_DRUG_TYPE_TIER_04            = "Gap Drug Type for Tier 4"
         GAP_DRUG_TYPE_TIER_05            = "Gap Drug Type for Tier 5"
         GAP_DRUG_TYPE_TIER_06            = "Gap Drug Type for Tier 6"
         GAP_INP_1M_COPAY_TIER_01         = "Gap In-network Pharmacy 1 month Copay for Tier 1"
         GAP_INP_1M_COPAY_TIER_02         = "Gap In-network Pharmacy 1 month Copay for Tier 2"
         GAP_INP_1M_COPAY_TIER_03         = "Gap In-network Pharmacy 1 month Copay for Tier 3"
         GAP_INP_1M_COPAY_TIER_04         = "Gap In-network Pharmacy 1 month Copay for Tier 4"
         GAP_INP_1M_COPAY_TIER_05         = "Gap In-network Pharmacy 1 month Copay for Tier 5"
         GAP_INP_1M_COPAY_TIER_06         = "Gap In-network Pharmacy 1 month Copay for Tier 6"
         GAP_INP_1M_COINS_TIER_01         = "Gap In-network Pharmacy 1 month Coinsurance for Tier 1"
         GAP_INP_1M_COINS_TIER_02         = "Gap In-network Pharmacy 1 month Coinsurance for Tier 2"
         GAP_INP_1M_COINS_TIER_03         = "Gap In-network Pharmacy 1 month Coinsurance for Tier 3"
         GAP_INP_1M_COINS_TIER_04         = "Gap In-network Pharmacy 1 month Coinsurance for Tier 4"
         GAP_INP_1M_COINS_TIER_05         = "Gap In-network Pharmacy 1 month Coinsurance for Tier 5"
         GAP_INP_1M_COINS_TIER_06         = "Gap In-network Pharmacy 1 month Coinsurance for Tier 6";

  infile in missover truncover;

  input @001   CONTRACT_ID                      $5.
        @006   PLAN_ID                          $3.
        @009   FORMULARY_ID                     $8.
        @017   CONTRACT_NAME                    $150.
        @167   PLAN_NAME                        $75.
        @242   ORGANIZATION_MARKETING_NAME      $150.
        @392   EFFECTIVE_DATE                   $10.
        @402   ORGANIZATION_TYPE                $2.
        @404   PLAN_TYPE                        $2.
        @406   DEMO_TYPE                        $1.
        @407   SNP_TYPE                         $1.
        @408   DRUG_BENEFIT_TYPE                $1.
        @409   EGWP_INDICATOR                   $1.
        @410   EGHP_CALENDAR_YEAR_FLAG          $1.
        @411   COV_CRITERIA                     $1.
        @412   NATIONAL_PDP                     $1.
        @413   GAP_COVERAGE_TYPE                $2.
        @415   DEMINIMIS_PD_FLAG                $1.
        @416   DED_APPLY                        $1.
        @417   DED_AMT                          12.2
        @429   DED_APPLY_ALL                    $1.
        @430   DED_COSTSHARE_TIERS              $6.
        @436   DED_COPAY                        12.2
        @448   DED_COINS                        12.2
        @460   FREE_FIRST_FILL                  $1.
        @461   PRE_ICL_APPLY                    $1.
        @462   ICL_APPLY                        $1.
        @463   ICL_AMT                          12.2
        @475   POST_OOPT_APPLY                  $1.
        @476   OOPT_AMT                         12.2
        @488   EXCLUDED_DRUGS                   $1.
        @489   REDUCED_COST_SHARE               $1.
        @490   REDUCED_DED                      $1.
        @491   REDUCED_PREICL_CS                $1.
        @492   REDUCED_GAP_CS                   $1.
        @493   REDUCED_OOPT_CS                  $1.
        @494   INCREASED_ICL                    $1.
        @495   SPECIALTY_TIER                   $2.
        @497   NAT_RX_COV_YN                    $1.
        @498   OTC_UM_PROGRAM                   $1.
        @499  (PRE_ICL_DRUG_TYPE_TIER_01-PRE_ICL_DRUG_TYPE_TIER_06)       ($6.)
        @535  (PRE_ICL_INP_1M_COPAY_TIER_01-PRE_ICL_INP_1M_COPAY_TIER_06) (12.2)
        @607  (PRE_ICL_INP_1M_COINS_TIER_01-PRE_ICL_INP_1M_COINS_TIER_06) (12.2)
        @679  (GAP_TIER_01-GAP_TIER_06)                                   ($1.)
        @685  (GAP_PARTIAL_TIER_01-GAP_PARTIAL_TIER_06)                   ($1.)
        @691  (GAP_DRUG_TYPE_TIER_01-GAP_DRUG_TYPE_TIER_06)               ($6.)
        @727  (GAP_INP_1M_COPAY_TIER_01-GAP_INP_1M_COPAY_TIER_06)         (12.2)
        @799  (GAP_INP_1M_COINS_TIER_01-GAP_INP_1M_COINS_TIER_06)         (12.2);
run;

title 'Part D Plan Characteristics 2011';
proc contents data=out.PLAN_CHAR_2011 varnum;
proc print data=out.PLAN_CHAR_2011(obs=5);
  title2 'Sample Listing - First 5 Rows';
run;
proc means data=out.PLAN_CHAR_2011;
  title2 'Simple Means';
run;

proc freq data=out.PLAN_CHAR_2011;
  title2 'Freqs';
  table COV_CRITERIA
        DED_APPLY
        DED_APPLY_ALL
        DEMINIMIS_PD_FLAG
        DEMO_TYPE
        DRUG_BENEFIT_TYPE
        EGHP_CALENDAR_YEAR_FLAG
        EGWP_INDICATOR
        EXCLUDED_DRUGS
        FREE_FIRST_FILL
        GAP_COVERAGE_TYPE
        GAP_PARTIAL_TIER_01-GAP_PARTIAL_TIER_06
        GAP_TIER_01-GAP_TIER_06
        ICL_APPLY
        INCREASED_ICL
        NATIONAL_PDP
        NAT_RX_COV_YN
        ORGANIZATION_TYPE
        OTC_UM_PROGRAM
        PLAN_TYPE
        POST_OOPT_APPLY
        PRE_ICL_APPLY
        REDUCED_COST_SHARE
        REDUCED_DED
        REDUCED_GAP_CS
        REDUCED_OOPT_CS
        REDUCED_PREICL_CS
        SNP_TYPE
        SPECIALTY_TIER/missing;
run;

* End of Program *;
