***  Custom SAS Formats for the 2016 Plan Characteristics Code Variables  ***;

proc format;

***  PTCD_INDICATOR or PTCD_INDICATOR_YY  ***;
value $ cdind
'1'='1:Part C Only'
'2'='2:Part D Only'
'3'='3:Part C and D';


***  ORGANIZATION_TYPE  ***;
value $ org_tp
'01'='01:Local CCP'
'04'='04:PFFS'
'05'='05:Demo'
'06'='06:1876 Cost'
'08'='08:National PACE'
'10'='10:PDP'
'11'='11:Regional CCP'
'13'='13:Employer/Union Only Direct Contract PDP'
'16'='16:POS Contractor'
;


***  PLAN_TYPE  ***;
value $ plan_tp
'01'='01:HMO'
'02'='02:HMOPOS'
'04'='04:Local PPO'
'09'='09:PFFS'
'18'='18:1876 Cost'
'20'='20:National PACE'
'29'='29:Medicare Prescription Drug Plan'
'30'='30:Employer/Union Only Direct Contract PDP'
'31'='31:Regional PPO'
'46'='46:Point-of-Sale Contractor'
'48'='48:Medicare-Medicaid Plan HMO'
'49'='49:Medicare-Medicaid Plan HMOPOS'
;

***  DEMO_TYPE (No Demonstration Projects in 2011)  ***;
value $ demo_tp
'0'='0:Non-Demo'
'1'='1:Demo'
;

***  SNP_TYPE  ***;
value $ snp_tp
'0'='0:Non-SNP'
'C'='C:Chronic or Disabling Condition'
'D'='D:Dual-Eligible'
'I'='I:Institutional'
;

***  DRUG_BENEFIT_TYPE  ***;
value  $ benefit
'0'='0:No Plan Benefit Information'
'1'='1:Defined Standard Benefit'
'2'='2:Actuarially Equivalent Standard'
'3'='3:Basic Alternative'
'4'='4:Enhanced Alternative'
;

***  YES/NO VARIABLES  ***;
value $ yesno
'Y'='Y:Yes'
'N'='N:No'
'9'='9:Not Applicable'
'X'='X:Unknown'
;

***  COV_CRITERIA  ***;
value  $ ben_cov
'1'='1:Part A/B'
'2'='2:Part B Only'
'9'='9:Not Applicable'
;

***  DED_APPLY  ***;
value $ ded_ap
'1'='1:Medicare-defined amount'
'2'='2:Plan-defined amount'
'3'='3:No deductible'
;

***  DED_APPLY_ALL  ***;
value $ ded_tp
'1'='1:No cost sharing'
'2'='2:Pre ICL cost sharing applies to selected tiers'
'3'='3:Other type of cost sharing applies to selected tiers'
'9'='9:Not Applicable'
;


***  PRE_ICL_APPLY  ***;
value  $ pre_ap
'1'='1:Medicare-defined Part D Coinsurance Amount'
'2'='2:Cost Share Tiers'
'3'='3:No cost sharing'
;

***  ICL_APPLY  ***;
value $ icl_ap
'1'='1:Medicare-defined amount'
'2'='2:Plan-defined amount'
'3'='3:No ICL'
;

***  POST_OOPT_APPLY  ***;
value $ post_ap
'1'='1:Medicare-defined Post Threshold Cost Shares'
'2'='2:Cost Share Tiers'
'3'='3:No cost sharing'
;

***  BELOW_BENCHMARK  ***;
value $ bench
'B'='B:Below Regional Benchmark'
'D'='D:Below De minimus Amount'
'N'='N:No'
'9'='9:Not Applicable'
'X'='X:Unknown'
;

***  TIER FILE COST SHARE VARIABLES  ***;
value $ cs_tp
'1'='1:Coinsurance'
'2'='2:Copayment'
'3'='3:Greater of Coinsurance and Copayment'
'4'='4:Lesser of Coinsurance and Copayment'
;

run;
