* SAS Read-In Program
*
* Name: premium_2012_readin.sas
*
* Purpose: Read-In the delimited flat file PREMIUM_2012.
*
* Delimiter: Fixed Column
*
* Date: 17DEC14   Time: 18:03
*
* Programmer: Adam Hendricks, Adam.Hendricks@gdit.com, 515-645-3015
*
*;

%let dirpath = .; * <--  Directory Path for Input Flat File in FILENAME Statement *;

filename in  "%trim(&dirpath)/premium_2012.dat" lrecl=168;

libname  out '.'; * <--  Directory Path for Output Library in LIBNAME Statement   *;

* Start *;
data out.PREMIUM_2012;
  length CONTRACT_ID                      $5
         PLAN_ID                          $3
         SEGMENT_ID                       $3
         PART_B_PREMIUM_REDUCTION_AMT     8
         PART_C_PREMIUM                   8
         PLAN_BASIC_PREMIUM_NET_REBATE    8
         PLAN_SUPP_PREMIUM_NET_REBATE     8
         PLAN_TOTAL_PREMIUM_NET_REBATE    8
         PART_D_LIS_25                    8
         PART_D_LIS_50                    8
         PART_D_LIS_75                    8
         PART_D_LIS_100                   8
         PART_D_LIPS_25                   8
         PART_D_LIPS_50                   8
         PART_D_LIPS_75                   8
         PART_D_LIPS_100                  8
         BELOW_BENCHMARK                  $1;

  format CONTRACT_ID                      $5.
         PLAN_ID                          $3.
         SEGMENT_ID                       $3.
         PART_B_PREMIUM_REDUCTION_AMT     12.2
         PART_C_PREMIUM                   12.2
         PLAN_BASIC_PREMIUM_NET_REBATE    12.2
         PLAN_SUPP_PREMIUM_NET_REBATE     12.2
         PLAN_TOTAL_PREMIUM_NET_REBATE    12.2
         PART_D_LIS_25                    12.2
         PART_D_LIS_50                    12.2
         PART_D_LIS_75                    12.2
         PART_D_LIS_100                   12.2
         PART_D_LIPS_25                   12.2
         PART_D_LIPS_50                   12.2
         PART_D_LIPS_75                   12.2
         PART_D_LIPS_100                  12.2
         BELOW_BENCHMARK                  $1.;

  label  CONTRACT_ID                      = "Contract ID"
         PLAN_ID                          = "Plan ID"
         SEGMENT_ID                       = "Segment Identifier"
         PART_B_PREMIUM_REDUCTION_AMT     = "Part B Premium Reduction Amt"
         PART_C_PREMIUM                   = "Part C Premium"
         PLAN_BASIC_PREMIUM_NET_REBATE    = "Part D Basic Premium Net of Rebate"
         PLAN_SUPP_PREMIUM_NET_REBATE     = "Part D Supplemental Premium Net of Rebate"
         PLAN_TOTAL_PREMIUM_NET_REBATE    = "Part D Total Premium Net of Rebate"
         PART_D_LIS_25                    = "Part D Low Income Subsidy 25%"
         PART_D_LIS_50                    = "Part D Low Income Subsidy 50%"
         PART_D_LIS_75                    = "Part D Low Income Subsidy 75%"
         PART_D_LIS_100                   = "Part D Low Income Subsidy 100%"
         PART_D_LIPS_25                   = "Part D Low Income Premium Subsidy 25%"
         PART_D_LIPS_50                   = "Part D Low Income Premium Subsidy 50%"
         PART_D_LIPS_75                   = "Part D Low Income Premium Subsidy 75%"
         PART_D_LIPS_100                  = "Part D Low Income Premium Subsidy 100%"
         BELOW_BENCHMARK                  = "Indicates whether plan is a basic plan with a premium below the regional benchmark or de minimis amount";

  infile in missover truncover;

  input @001   CONTRACT_ID                      $5.
        @006   PLAN_ID                          $3.
        @009   SEGMENT_ID                       $3.
        @012   PART_B_PREMIUM_REDUCTION_AMT     12.2
        @024   PART_C_PREMIUM                   12.2
        @036   PLAN_BASIC_PREMIUM_NET_REBATE    12.2
        @048   PLAN_SUPP_PREMIUM_NET_REBATE     12.2
        @060   PLAN_TOTAL_PREMIUM_NET_REBATE    12.2
        @072   PART_D_LIS_25                    12.2
        @084   PART_D_LIS_50                    12.2
        @096   PART_D_LIS_75                    12.2
        @108   PART_D_LIS_100                   12.2
        @120   PART_D_LIPS_25                   12.2
        @132   PART_D_LIPS_50                   12.2
        @144   PART_D_LIPS_75                   12.2
        @156   PART_D_LIPS_100                  12.2
        @168   BELOW_BENCHMARK                  $1.;
run;

title 'Part D Premimum Characteristics 2012';
proc contents data=out.PREMIUM_2012 varnum;
proc print data=out.PREMIUM_2012(obs=5);
  title2 'Sample Listing - First 5 Rows';
run;
proc means data=out.PREMIUM_2012;
  title2 'Simple Means';
run;

proc freq data=out.PREMIUM_2012;
  title2 'Freqs';
  table BELOW_BENCHMARK/missing;
run;

* End of Program *;
