* SAS Read-In Program
*
* Name: snp_contract_info_2016_readin.sas
*
* Purpose: Read-In the delimited flat file SNP_CONTRACT_INFO_2016.
*
* Delimiter: Fixed Column
*
* Date: 09MAY18   Time: 14:01
*
* Help: cmsdata@gdit.com, 1-866-766-1915
*
*;

filename in  'snp_contract_info_2016.dat'  lrecl=32768;
libname  ccw '.';

data ccw.SNP_CONTRACT_INFO_2016;
  length CONTRACT_ID                      $5
         PLAN_ID                          $3
         SNP_PERCENTAGE_TYPE              $1
         SNP_INSTITUTIONAL_TYPE           $1
         CONDITION_CATEGORY_01            $1
         CONDITION_CATEGORY_02            $1
         CONDITION_CATEGORY_03            $1
         CONDITION_CATEGORY_04            $1
         CONDITION_CATEGORY_05            $1
         CONDITION_CATEGORY_06            $1
         CONDITION_CATEGORY_07            $1
         CONDITION_CATEGORY_08            $1
         CONDITION_CATEGORY_09            $1
         CONDITION_CATEGORY_10            $1
         CONDITION_CATEGORY_11            $1
         CONDITION_CATEGORY_12            $1
         CONDITION_CATEGORY_13            $1
         CONDITION_CATEGORY_14            $1
         CONDITION_CATEGORY_15            $1
         CONDITION_CATEGORY_16            $1
         CONDITION_CATEGORY_17            $1
         CONDITION_CATEGORY_18            $1
         CONDITION_CATEGORY_19            $1
         CONDITION_CATEGORY_20            $1;

  format CONTRACT_ID                      $5.
         PLAN_ID                          $3.
         SNP_PERCENTAGE_TYPE              $1.
         SNP_INSTITUTIONAL_TYPE           $1.
         CONDITION_CATEGORY_01            $1.
         CONDITION_CATEGORY_02            $1.
         CONDITION_CATEGORY_03            $1.
         CONDITION_CATEGORY_04            $1.
         CONDITION_CATEGORY_05            $1.
         CONDITION_CATEGORY_06            $1.
         CONDITION_CATEGORY_07            $1.
         CONDITION_CATEGORY_08            $1.
         CONDITION_CATEGORY_09            $1.
         CONDITION_CATEGORY_10            $1.
         CONDITION_CATEGORY_11            $1.
         CONDITION_CATEGORY_12            $1.
         CONDITION_CATEGORY_13            $1.
         CONDITION_CATEGORY_14            $1.
         CONDITION_CATEGORY_15            $1.
         CONDITION_CATEGORY_16            $1.
         CONDITION_CATEGORY_17            $1.
         CONDITION_CATEGORY_18            $1.
         CONDITION_CATEGORY_19            $1.
         CONDITION_CATEGORY_20            $1.;

  label  CONTRACT_ID                      = "Contract Number"
         PLAN_ID                          = "Plan Identifier"
         SNP_PERCENTAGE_TYPE              = "SNP Percentage Type"
         SNP_INSTITUTIONAL_TYPE           = "SNP Instituational Type"
         CONDITION_CATEGORY_01            = "Chronic Alcohol and Other Drug Dependence"
         CONDITION_CATEGORY_02            = "Auto-immune Disorders"
         CONDITION_CATEGORY_03            = "Cancer Excluding Pre-cancer Conditions or In-situ Status"
         CONDITION_CATEGORY_04            = "Cardiovascular Disorders"
         CONDITION_CATEGORY_05            = "Chronic Heart Failure"
         CONDITION_CATEGORY_06            = "Dementia"
         CONDITION_CATEGORY_07            = "Diabetes Mellitus"
         CONDITION_CATEGORY_08            = "End-Stage Liver Disease"
         CONDITION_CATEGORY_09            = "End-Stage Renal Disease Requiring Any Mode of Dialysis"
         CONDITION_CATEGORY_10            = "Severe Hemotologic Disorders"
         CONDITION_CATEGORY_11            = "HIV/AIDS"
         CONDITION_CATEGORY_12            = "Chronic Lung Disorders"
         CONDITION_CATEGORY_13            = "Chronic and Disabling Mental Health Conditions"
         CONDITION_CATEGORY_14            = "Neurologic Disorders"
         CONDITION_CATEGORY_15            = "Stroke"
         CONDITION_CATEGORY_16            = "Cardiovascular Disorders and/or Chronic Heart Failure"
         CONDITION_CATEGORY_17            = "Cardiovascular Disorders and/or Diabetes"
         CONDITION_CATEGORY_18            = "Chronic Heart Failure and/or Diabetes"
         CONDITION_CATEGORY_19            = "Cardiovascular Disorders, Chronic Heart Failure, and/or Diabetes"
         CONDITION_CATEGORY_20            = "Cardiovascular Disorders and/or Stroke";

  infile in missover truncover;

  input @01    CONTRACT_ID                      $5.
        @06    PLAN_ID                          $3.
        @09    SNP_PERCENTAGE_TYPE              $1.
        @10    SNP_INSTITUTIONAL_TYPE           $1.
        @11    CONDITION_CATEGORY_01            $1.
        @12    CONDITION_CATEGORY_02            $1.
        @13    CONDITION_CATEGORY_03            $1.
        @14    CONDITION_CATEGORY_04            $1.
        @15    CONDITION_CATEGORY_05            $1.
        @16    CONDITION_CATEGORY_06            $1.
        @17    CONDITION_CATEGORY_07            $1.
        @18    CONDITION_CATEGORY_08            $1.
        @19    CONDITION_CATEGORY_09            $1.
        @20    CONDITION_CATEGORY_10            $1.
        @21    CONDITION_CATEGORY_11            $1.
        @22    CONDITION_CATEGORY_12            $1.
        @23    CONDITION_CATEGORY_13            $1.
        @24    CONDITION_CATEGORY_14            $1.
        @25    CONDITION_CATEGORY_15            $1.
        @26    CONDITION_CATEGORY_16            $1.
        @27    CONDITION_CATEGORY_17            $1.
        @28    CONDITION_CATEGORY_18            $1.
        @29    CONDITION_CATEGORY_19            $1.
        @30    CONDITION_CATEGORY_20            $1.;
run;

title 'SNP_CONTRACT_INFO_2016';
proc contents data=ccw.SNP_CONTRACT_INFO_2016 varnum;
proc print data=ccw.SNP_CONTRACT_INFO_2016(obs=5);
  title2 'Sample Listing - First 5 Rows';
run;
proc means data=ccw.SNP_CONTRACT_INFO_2016;
  title2 'Simple Means';
run;

proc freq data=ccw.SNP_CONTRACT_INFO_2016;
  title2 'Freqs';
  table
    CONDITION_CATEGORY_01
    CONDITION_CATEGORY_02
    CONDITION_CATEGORY_03
    CONDITION_CATEGORY_04
    CONDITION_CATEGORY_05
    CONDITION_CATEGORY_06
    CONDITION_CATEGORY_07
    CONDITION_CATEGORY_08
    CONDITION_CATEGORY_09
    CONDITION_CATEGORY_10
    CONDITION_CATEGORY_11
    CONDITION_CATEGORY_12
    CONDITION_CATEGORY_13
    CONDITION_CATEGORY_14
    CONDITION_CATEGORY_15
    CONDITION_CATEGORY_16
    CONDITION_CATEGORY_17
    CONDITION_CATEGORY_18
    CONDITION_CATEGORY_19
    CONDITION_CATEGORY_20
    SNP_INSTITUTIONAL_TYPE
    SNP_PERCENTAGE_TYPE
        /missing;
run;

* End of Program *;
